#version 450

struct TexGenCustomParams
{
    vec2 resolution;
    vec2 resolutionInv;
    float param1;
    float param2;
    float _pad0;
    float _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform TexGenCustomParamsBuffer
{
    TexGenCustomParams params;
} _28;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

void main()
{
    vec4 base_color = vec4(1.0, 0.0, 0.5, 1.0);
    float x = (vTexcoord0.x + (_28.params.param2 / 40.0)) - 1.0;
    if (vTexcoord0.y > (_28.params.param1 / 100.0))
    {
        x -= 0.20000000298023223876953125;
    }
    x = 1.0 - clamp(x, 0.0, 1.0);
    base_color = vec4(x);
    outColor = base_color;
}

 