#version 450

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct RibbonRenderParams
{
    int max_segments;
    int base_idx;
    int base_segment;
    int particles_per_segment;
    float thickness;
    int lights_num;
    int material_index;
    float first_segment_time_factor;
    int render_as_strips;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct ParticleRibbonState
{
    float generation_id;
    uint segments;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    vec3 vCameraPosition;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct LightProperties
{
    vec4 diffuse;
    vec4 direction;
    vec4 position;
    vec4 up;
    vec4 right;
    vec2 dimensions;
    vec2 _pad1;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct _493
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _104;

layout(set = 0, binding = 4, std140) uniform RibbonRenderParamsBuffer
{
    RibbonRenderParams ribbon_render_params;
} _148;

layout(set = 0, binding = 2, std430) buffer RibbonStatesData
{
    ParticleRibbonState states[];
} prt_states_snapshots;

layout(set = 0, binding = 3, std430) buffer RibbonPositionsData
{
    float position[];
} prt_position_snapshots;

layout(set = 0, binding = 5, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _422;

layout(location = 1) out _493 vtx_output;
layout(location = 0) out uint instanceID;

bool prt_is_alive(uint id)
{
    return _104.prt_states[id].life_time < _104.prt_states[id].life_span;
}

int calculate_vidx_for_ribbon_segment(int ribbon_id, inout int ribbon_segment)
{
    ribbon_segment = _148.ribbon_render_params.base_segment - ribbon_segment;
    if (ribbon_segment < 0)
    {
        ribbon_segment += _148.ribbon_render_params.max_segments;
    }
    if (ribbon_segment >= _148.ribbon_render_params.max_segments)
    {
        ribbon_segment -= _148.ribbon_render_params.max_segments;
    }
    int vidx = ((ribbon_segment * _148.ribbon_render_params.particles_per_segment) + ribbon_id) + _148.ribbon_render_params.base_idx;
    return vidx;
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(uint id)
{
    vec4 c = vec4(1.0);
    uint param = _104.prt_states[id].color;
    vec3 _135 = color_convert_uint_to_float3(param);
    c.x = _135.x;
    c.y = _135.y;
    c.z = _135.z;
    return c;
}

ParticleState prt_get_state(uint id)
{
    ParticleState _122;
    _122.life_time = _104.prt_states[id].life_time;
    _122.life_span = _104.prt_states[id].life_span;
    _122.generation_id = _104.prt_states[id].generation_id;
    _122.color = _104.prt_states[id].color;
    ParticleState _121 = _122;
    return _121;
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

void main()
{
    int odd_even = ((gl_VertexIndex & 1) == 0) ? 1 : (-1);
    int ribbon_id;
    int ribbon_segment;
    if (_148.ribbon_render_params.render_as_strips != 0)
    {
        ribbon_id = gl_InstanceIndex;
        ribbon_segment = gl_VertexIndex / 2;
    }
    else
    {
        uint max_segments_uint = uint(_148.ribbon_render_params.max_segments);
        ribbon_segment = gl_VertexIndex / 2;
        ribbon_id = (gl_InstanceIndex * 64) + int(uint(ribbon_segment) / max_segments_uint);
        ribbon_segment = int(uint(ribbon_segment) % max_segments_uint);
    }
    uint param = uint(ribbon_id);
    if (!prt_is_alive(param))
    {
        gl_Position = vec4(0.0, 0.0, 0.0, -1.0);
        return;
    }
    int ribbon_segments = max(0, (min(_148.ribbon_render_params.max_segments, int(prt_states_snapshots.states[ribbon_id].segments)) - 1));
    ribbon_segment = min(ribbon_segment, ribbon_segments);
    int param_1 = ribbon_id;
    int param_2 = ribbon_segment;
    int _265 = calculate_vidx_for_ribbon_segment(param_1, param_2);
    int vidx = _265;
    vec3 vInstPosition = vec3(prt_position_snapshots.position[(vidx * 3) + 0], prt_position_snapshots.position[(vidx * 3) + 1], prt_position_snapshots.position[(vidx * 3) + 2]);
    vec3 vInstNormal = vec3(1.0, 0.0, 0.0);
    uint param_3 = uint(ribbon_id);
    vec4 vInstColor = prt_get_color(param_3);
    uint param_4 = uint(ribbon_id);
    ParticleState vState = prt_get_state(param_4);
    bool is_last = ribbon_segment >= ribbon_segments;
    bool is_first = ribbon_segment == 0;
    if ((ribbon_segment > 0) || true)
    {
        float shrink_factor = _148.ribbon_render_params.first_segment_time_factor;
        vec3 pos_off = vec3(0.00999999977648258209228515625);
        int param_5 = ribbon_id;
        int param_6 = ribbon_segment - 1;
        int _327 = calculate_vidx_for_ribbon_segment(param_5, param_6);
        int next_vidx = _327;
        vec3 nextPosition = vec3(prt_position_snapshots.position[(next_vidx * 3) + 0], prt_position_snapshots.position[(next_vidx * 3) + 1], prt_position_snapshots.position[(next_vidx * 3) + 2]);
        vec3 dir = normalize(cross(-normalize((vInstPosition - nextPosition) + pos_off), vInstNormal));
        if ((ribbon_segment == ribbon_segments) && (ribbon_segments > 1))
        {
            vInstPosition = mix(vInstPosition, nextPosition, vec3(_148.ribbon_render_params.first_segment_time_factor));
            dir *= 0.100000001490116119384765625;
        }
        if (is_first)
        {
            dir *= (-0.100000001490116119384765625);
        }
        if ((ribbon_segment == 1) && (ribbon_segments > 2))
        {
            dir *= max(0.100000001490116119384765625, shrink_factor);
        }
        if ((ribbon_segment == (ribbon_segments - 1)) && (ribbon_segments > 2))
        {
            dir *= max(0.100000001490116119384765625, 1.0 - shrink_factor);
        }
        vInstPosition += ((dir * _148.ribbon_render_params.thickness) * float(odd_even));
    }
    vec3 pos = vInstPosition;
    vec3 vPos1 = pos;
    vec3 param_7 = vPos1;
    mat4 param_8 = _422.transform_params.mModelView;
    vec3 vPos = vector_transform_by_mat43(param_7, param_8);
    gl_Position = _422.transform_params.mProjection * vec4(vPos, 1.0);
}

 