#version 450

struct TexGenCustomParams
{
    vec2 resolution;
    vec2 resolutionInv;
    float param1;
    float param2;
    float _pad0;
    float _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

layout(set = 1, binding = 1, std140) uniform TexGenCustomParamsBuffer
{
    TexGenCustomParams params;
} _23;

layout(set = 1, binding = 2, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _53;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

void main()
{
    float y = vTexcoord0.y;
    vec2 c = _23.params.resolution * 0.5;
    vec2 dxy = (vTexcoord0 * _23.params.resolution) - c;
    float d = sqrt(dot(dxy, dxy)) / length(_23.params.resolution);
    d = 0.5 + (0.5 * sin((d * 40.0) + (_53.globals.time * 1.0)));
    vec4 base_color = vec4(d, d, d, 1.0);
    outColor = base_color;
}

 