#version 450

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct _58
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    vec3 vCameraPosition;
};

layout(set = 1, binding = 1, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _31;

layout(location = 1) in _58 vtx_input;

bool getMaterialDiscard(MaterialPropertiesGPU material, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return false;
}

void main()
{
    MaterialPropertiesGPU material;
    material.diffuse = _31.colorDiffuse.xyz;
    material.emissive = vec3(0.0);
    material.metalness = 0.0;
    material.roughness = 0.5;
    material.transparency = 0.0;
    material.refraction = 0.0;
    material.flags = 0u;
    MaterialPropertiesGPU param = material;
    vec3 param_1 = vtx_input.vWorldPos;
    vec3 param_2 = vtx_input.vLocalPos;
    vec3 param_3 = vtx_input.vNorm;
    vec3 param_4 = vtx_input.vWorldNorm;
    bool to_discard = getMaterialDiscard(param, param_1, param_2, param_3, param_4);
    if (to_discard)
    {
        discard;
    }
}

 