#version 450

struct RaymarchParams
{
    vec3 function_scale;
    int show_bounding_box;
    vec3 function_origin;
    int clamp_to_volume;
    float animation_time;
    float clouds_height;
    float intersection_density_modifier;
    float density;
    int use_instance_origin;
    int txt1_flip_y;
    int txt2_flip_y;
    int gradient_idx;
    vec4 near_far_plane;
    int trace_inside;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    vec3 vCameraPosition;
};

struct _1240
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct LightProperties
{
    vec4 diffuse;
    vec4 direction;
    vec4 position;
    vec4 up;
    vec4 right;
    vec2 dimensions;
    vec2 _pad1;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 2, std140) uniform RaymarchParamsBuffer
{
    RaymarchParams raymarch_params;
} _201;

layout(set = 1, binding = 3, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 4, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _1005;

layout(set = 1, binding = 5, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1026;

layout(set = 1, binding = 1, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1036;

layout(set = 1, binding = 6, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _1139;

layout(set = 1, binding = 7) uniform sampler2D s_Gradients;
layout(set = 1, binding = 8) uniform sampler2D s_NoiseRGBA;
layout(set = 1, binding = 9) uniform sampler2D sImage1;
layout(set = 1, binding = 10) uniform sampler2DArray s_BlueNoise;
layout(set = 1, binding = 11) uniform sampler2D sDepth;

layout(location = 0) flat in uint instanceID;
layout(location = 1) in _1240 vtx_input;
layout(location = 2) out uvec4 outMetalnessRoughnessMeterialTags;
layout(location = 1) out uint outNormalMaterial;
layout(location = 0) out vec4 outAlbedo;

float det(mat2 matrix)
{
    return (matrix[0].x * matrix[1].y) - (matrix[0].y * matrix[1].x);
}

mat3 transpose_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat3 result = mat3(vec3(vec3(row0.x, row1.x, row2.x)), vec3(vec3(row0.y, row1.y, row2.y)), vec3(vec3(row0.z, row1.z, row2.z)));
    return result;
}

mat3 inverse_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat2 param = mat2(vec2(row1.y, row1.z), vec2(row2.y, row2.z));
    mat2 param_1 = mat2(vec2(row1.z, row1.x), vec2(row2.z, row2.x));
    mat2 param_2 = mat2(vec2(row1.x, row1.y), vec2(row2.x, row2.y));
    vec3 minors0 = vec3(det(param), det(param_1), det(param_2));
    mat2 param_3 = mat2(vec2(row2.y, row2.z), vec2(row0.y, row0.z));
    mat2 param_4 = mat2(vec2(row2.z, row2.x), vec2(row0.z, row0.x));
    mat2 param_5 = mat2(vec2(row2.x, row2.y), vec2(row0.x, row0.y));
    vec3 minors1 = vec3(det(param_3), det(param_4), det(param_5));
    mat2 param_6 = mat2(vec2(row0.y, row0.z), vec2(row1.y, row1.z));
    mat2 param_7 = mat2(vec2(row0.z, row0.x), vec2(row1.z, row1.x));
    mat2 param_8 = mat2(vec2(row0.x, row0.y), vec2(row1.x, row1.y));
    vec3 minors2 = vec3(det(param_6), det(param_7), det(param_8));
    mat3 param_9 = mat3(vec3(minors0), vec3(minors1), vec3(minors2));
    mat3 adj = transpose_mat3(param_9);
    return adj * (1.0 / dot(row0, minors0));
}

uvec2 encode_metalness_roughness_material(float metalness, float roughness, uint material)
{
    return uvec2((uint(min(1.0, metalness) * 255.0) << uint(8)) | (uint(min(1.0, roughness) * 255.0) << uint(0)), material);
}

float linearizeDepth(float d)
{
    return _201.raymarch_params.near_far_plane.z / ((_201.raymarch_params.near_far_plane.y + _201.raymarch_params.near_far_plane.x) - (d * _201.raymarch_params.near_far_plane.w));
}

float sdBox(vec3 p, vec3 b)
{
    vec3 q = abs(p) - b;
    return length(max(q, vec3(0.0))) + min(max(q.x, max(q.y, q.z)), 0.0);
}

float raymarchBBox(vec3 ro, vec3 rd, vec3 function_scale)
{
    float h = 0.00200000009499490261077880859375;
    float t = 0.0;
    float res = -1.0;
    for (int i = 0; i < 48; i++)
    {
        if ((h < 0.001000000047497451305389404296875) || (t > 20000.0))
        {
            break;
        }
        vec3 param = ro + (rd * t);
        vec3 param_1 = vec3(1000.0);
        vec3 param_2 = ro + (rd * t);
        vec3 param_3 = (function_scale * 0.5) + vec3(0.00999999977648258209228515625);
        h = max(sdBox(param, param_1), -sdBox(param_2, param_3));
        t += h;
    }
    if (t < 20000.0)
    {
        res = t;
    }
    return res;
}

float _noise(vec3 x)
{
    vec3 p = floor(x);
    vec3 f = fract(x);
    f = (f * f) * (vec3(3.0) - (f * 2.0));
    vec2 uv = (p.xy + (vec2(37.0, 17.0) * p.z)) + f.xy;
    vec2 rg = textureLod(s_NoiseRGBA, (uv + vec2(0.5)) / vec2(256.0), 0.0).yx;
    return mix(rg.x, rg.y, f.z);
}

vec2 density_map(vec3 p, vec3 p_noise)
{
    float t = texture(sImage1, fract((p.xz / _201.raymarch_params.function_scale.xy) + vec2(0.5))).y;
    float b = 1.0 - clamp(abs(0.5 - t) * 2.0, 0.0, 1.0);
    vec3 param = vec3(p_noise * 3.1340999603271484375);
    float n = _noise(param);
    return vec2(t, (b * t) * clamp(n * 4.0, -0.5, 4.0));
}

vec4 map(vec3 p)
{
    float den = (-1.0) - ((abs((p.y / (_201.raymarch_params.clouds_height * 0.100000001490116119384765625)) - 0.5) + 0.5) / 2.0);
    float cloud_time = _201.raymarch_params.animation_time;
    vec3 q = ((p * 0.5) - (vec3(0.0, 0.0, 1.5) * cloud_time)) + ((vec3(-0.4000000059604644775390625, 0.0, 1.5) * cloud_time) * 0.703100025653839111328125);
    vec3 param = p;
    vec3 param_1 = q;
    vec2 texture_base_den = density_map(param, param_1);
    vec3 param_2 = q;
    float f = 0.5 * _noise(param_2);
    q = (q * 2.019999980926513671875) - (vec3(0.0, 0.0, 1.39999997615814208984375) * cloud_time);
    vec3 param_3 = q;
    f += (0.25 * _noise(param_3));
    q = (q * 2.0299999713897705078125) - (vec3(0.0, 0.0, 1.60000002384185791015625) * cloud_time);
    vec3 param_4 = q;
    f += (0.125 * _noise(param_4));
    q = (q * 2.0099999904632568359375) - (vec3(0.0, 0.0, 1.7999999523162841796875) * cloud_time);
    vec3 param_5 = q;
    f += (0.0625 * _noise(param_5));
    q = (q * 2.019999980926513671875) - (vec3(0.0, 0.0, 1.0) * cloud_time);
    vec3 param_6 = q;
    f += (0.03125 * _noise(param_6));
    den += (4.0 * f);
    den = clamp(den, 0.0, 1.0);
    vec3 col = mix(vec3(1.0), vec3(0.60000002384185791015625, 0.5, 0.4000000059604644775390625), vec3(den * 0.5));
    return vec4(col, ((den * 0.699999988079071044921875) * _201.raymarch_params.density) * 0.001000000047497451305389404296875);
}

float testshadow(vec3 p, float dither)
{
    float shadow = 1.0;
    float s = 0.0500000007450580596923828125 * dither;
    for (int j = 0; j < 5; j++)
    {
        vec3 shadpos = p + (vec3(-1.0, 0.5, 0.5) * s);
        vec3 param = shadpos;
        shadow -= (map(param).w * shadow);
        s += 0.07500000298023223876953125;
    }
    return shadow;
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

vec4 raymarch(vec3 ro, vec3 rd, float max_t, out float intersection)
{
    vec4 sum = vec4(0.0);
    float t = 0.0;
    intersection = -1.0;
    float t_step = 0.100000001490116119384765625;
    float dither = texelFetch(s_BlueNoise, ivec3(ivec2(uvec2(gl_FragCoord.xy) % uvec2(128u)), 0), 0).x;
    t += (0.100000001490116119384765625 * dither);
    float total_scene_light = 0.0;
    float shadow = 0.0;
    for (int i = 0; i < 96; i++)
    {
        float trace_t = t + ((0.20000000298023223876953125 * t) * t);
        if ((sum.w > 0.9900000095367431640625) || (trace_t >= max_t))
        {
            continue;
        }
        vec3 pos = ro + (rd * trace_t);
        vec3 param = pos;
        vec4 col = map(param);
        if (i > 16)
        {
            float prev_shadow = shadow;
            if ((i & 3) == 0)
            {
                vec3 param_1 = pos;
                float param_2 = dither;
                shadow = testshadow(param_1, param_2);
            }
            shadow = mix(prev_shadow, shadow, 0.75);
        }
        else
        {
            vec3 param_3 = pos;
            float param_4 = dither;
            shadow = testshadow(param_3, param_4);
        }
        float scene_light = 1.0;
        if (true)
        {
        }
        vec3 cloud_color_for_shadow = vec3(1.0);
        if (_201.raymarch_params.gradient_idx != (-1))
        {
            int param_5 = _201.raymarch_params.gradient_idx;
            float param_6 = shadow;
            cloud_color_for_shadow = gradient_sample(param_5, param_6).xyz;
        }
        vec4 _684 = col;
        vec3 _686 = _684.xyz * cloud_color_for_shadow;
        col.x = _686.x;
        col.y = _686.y;
        col.z = _686.z;
        vec4 _695 = col;
        vec3 _697 = _695.xyz * (scene_light + 0.100000001490116119384765625);
        col.x = _697.x;
        col.y = _697.y;
        col.z = _697.z;
        float _705 = col.w;
        vec4 _706 = col;
        vec3 _708 = _706.xyz * _705;
        col.x = _708.x;
        col.y = _708.y;
        col.z = _708.z;
        sum += (col * (1.0 - sum.w));
        t += t_step;
    }
    vec4 bg = mix(vec4(0.300000011920928955078125, 0.4000000059604644775390625, 0.5, 0.0), vec4(0.5, 0.699999988079071044921875, 1.0, 0.0), vec4(smoothstep(-0.4000000059604644775390625, 0.0, rd.y)));
    sum += ((bg * (1.0 - sum.w)) * (total_scene_light * 0.0500000007450580596923828125));
    intersection = t;
    return vec4(max(vec3(0.0), sum.xyz), sum.w);
}

float calcIntersection(vec3 ro, vec3 rd, float max_t, out vec4 color)
{
    vec3 param = ro;
    vec3 param_1 = rd;
    float param_2 = max_t;
    float param_3;
    vec4 _767 = raymarch(param, param_1, param_2, param_3);
    float intersection = param_3;
    color = _767;
    return intersection;
}

vec3 doModelNormal(vec3 p)
{
    return vec3(1.0);
}

uint packSnorm2x15(vec2 v)
{
    uvec2 d = uvec2(round(vec2(16383.5) + (v * 16383.5)));
    return d.x | (d.y << 15u);
}

uint encode_normal_31bit(vec3 n)
{
    vec2 v = n.xy;
    uint s = uint((n.z > 0.0) ? 1073741824 : 0);
    vec2 param = v;
    return s | packSnorm2x15(param);
}

uint encode_normal_material(vec3 n, int id)
{
    vec3 param = n;
    uint normal_material = encode_normal_31bit(param);
    normal_material = (uint(id) << 31u) | normal_material;
    return normal_material;
}

void main()
{
    MaterialPropertiesGPU _1011;
    _1011.diffuse = materials.material_properties[_1005.materialIndex].diffuse;
    _1011.transparency = materials.material_properties[_1005.materialIndex].transparency;
    _1011.emissive = materials.material_properties[_1005.materialIndex].emissive;
    _1011.roughness = materials.material_properties[_1005.materialIndex].roughness;
    _1011.triplanar_factor = materials.material_properties[_1005.materialIndex].triplanar_factor;
    _1011.refraction = materials.material_properties[_1005.materialIndex].refraction;
    _1011.normal_factor = materials.material_properties[_1005.materialIndex].normal_factor;
    _1011.emissive_factor = materials.material_properties[_1005.materialIndex].emissive_factor;
    _1011.temporal_accumulation_factor = materials.material_properties[_1005.materialIndex].temporal_accumulation_factor;
    _1011.shadowmap_bias = materials.material_properties[_1005.materialIndex].shadowmap_bias;
    _1011.metalness = materials.material_properties[_1005.materialIndex].metalness;
    _1011.albedo_sampler = materials.material_properties[_1005.materialIndex].albedo_sampler;
    _1011.emissive_sampler = materials.material_properties[_1005.materialIndex].emissive_sampler;
    _1011.normal_sampler = materials.material_properties[_1005.materialIndex].normal_sampler;
    _1011.metalic_roughness_sampler = materials.material_properties[_1005.materialIndex].metalic_roughness_sampler;
    _1011.flags = materials.material_properties[_1005.materialIndex].flags;
    _1011._pad0 = materials.material_properties[_1005.materialIndex]._pad0;
    _1011._pad1 = materials.material_properties[_1005.materialIndex]._pad1;
    MaterialPropertiesGPU material = _1011;
    mat4 mat_instance_model;
    mat_instance_model[0] = vec4(1.0, 0.0, 0.0, 0.0);
    mat_instance_model[1] = vec4(0.0, 1.0, 0.0, 0.0);
    mat_instance_model[2] = vec4(0.0, 0.0, 1.0, 0.0);
    mat_instance_model[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (_1026.instance_params.stride > 0)
    {
        vec4 inst_m0 = _1036.instance_transform[(instanceID * uint(_1026.instance_params.stride)) + 0u];
        vec4 inst_m1 = _1036.instance_transform[(instanceID * uint(_1026.instance_params.stride)) + 1u];
        vec4 inst_m2 = _1036.instance_transform[(instanceID * uint(_1026.instance_params.stride)) + 2u];
        vec3 _1072 = vec3(inst_m0.x, inst_m1.x, inst_m2.x);
        mat_instance_model[0].x = _1072.x;
        mat_instance_model[0].y = _1072.y;
        mat_instance_model[0].z = _1072.z;
        vec3 _1085 = vec3(inst_m0.y, inst_m1.y, inst_m2.y);
        mat_instance_model[1].x = _1085.x;
        mat_instance_model[1].y = _1085.y;
        mat_instance_model[1].z = _1085.z;
        vec3 _1098 = vec3(inst_m0.z, inst_m1.z, inst_m2.z);
        mat_instance_model[2].x = _1098.x;
        mat_instance_model[2].y = _1098.y;
        mat_instance_model[2].z = _1098.z;
        vec3 _1111 = vec3(inst_m0.w, inst_m1.w, inst_m2.w);
        mat_instance_model[3].x = _1111.x;
        mat_instance_model[3].y = _1111.y;
        mat_instance_model[3].z = _1111.z;
    }
    vec3 instance_function_origin = _201.raymarch_params.function_origin;
    if (_201.raymarch_params.use_instance_origin != 0)
    {
        instance_function_origin = (mat_instance_model * vec4(_201.raymarch_params.function_origin, 1.0)).xyz * 0.001000000047497451305389404296875;
    }
    mat_instance_model = _1139.transform_params.mModel * mat_instance_model;
    mat4 mat_instance_model_inv = mat_instance_model;
    mat3 param = mat3(mat_instance_model_inv[0].xyz, mat_instance_model_inv[1].xyz, mat_instance_model_inv[2].xyz);
    mat3 inv = inverse_mat3(param);
    mat_instance_model_inv[0].x = inv[0].x;
    mat_instance_model_inv[0].y = inv[0].y;
    mat_instance_model_inv[0].z = inv[0].z;
    mat_instance_model_inv[1].x = inv[1].x;
    mat_instance_model_inv[1].y = inv[1].y;
    mat_instance_model_inv[1].z = inv[1].z;
    mat_instance_model_inv[2].x = inv[2].x;
    mat_instance_model_inv[2].y = inv[2].y;
    mat_instance_model_inv[2].z = inv[2].z;
    mat_instance_model_inv[3].x = -(((inv[0].x * mat_instance_model[3].x) + (inv[1].x * mat_instance_model[3].y)) + (inv[2].x * mat_instance_model[3].z));
    mat_instance_model_inv[3].y = -(((inv[0].y * mat_instance_model[3].x) + (inv[1].y * mat_instance_model[3].y)) + (inv[2].y * mat_instance_model[3].z));
    mat_instance_model_inv[3].z = -(((inv[0].z * mat_instance_model[3].x) + (inv[1].z * mat_instance_model[3].y)) + (inv[2].z * mat_instance_model[3].z));
    float g = (vtx_input.vNorm.z * 0.5) + 0.5;
    vec3 worldNorm = vtx_input.vWorldNorm;
    float param_1 = material.metalness;
    float param_2 = material.roughness;
    uint param_3 = uint(_1005.materialIndex);
    uvec2 _1266 = encode_metalness_roughness_material(param_1, param_2, param_3);
    outMetalnessRoughnessMeterialTags.x = _1266.x;
    outMetalnessRoughnessMeterialTags.y = _1266.y;
    vec3 ro = (mat_instance_model_inv * vec4(vtx_input.vWorldPos, 1.0)).xyz;
    vec3 rd = (mat_instance_model_inv * vec4(_1139.transform_params.vCameraPosition, 1.0)).xyz;
    rd = normalize(ro - rd);
    if (_201.raymarch_params.trace_inside != 0)
    {
        ro = (mat_instance_model_inv * vec4(_1139.transform_params.vCameraPosition, 1.0)).xyz;
    }
    ro *= _201.raymarch_params.function_scale;
    vec3 ro_bounding_volume = ro;
    ro += instance_function_origin;
    float param_4 = texelFetch(sDepth, ivec2(gl_FragCoord.xy), 0).x;
    float max_depth = linearizeDepth(param_4);
    vec4 color = vec4(1.0);
    float bounding_volume_intersection = 100000.0;
    if (_201.raymarch_params.clamp_to_volume != 0)
    {
        vec3 param_5 = ro_bounding_volume;
        vec3 param_6 = rd;
        vec3 param_7 = _201.raymarch_params.function_scale;
        bounding_volume_intersection = raymarchBBox(param_5, param_6, param_7);
    }
    bounding_volume_intersection = min((max_depth - vtx_input.vCoords.z) / (_201.raymarch_params.intersection_density_modifier * _201.raymarch_params.function_scale.x), bounding_volume_intersection);
    vec3 param_8 = ro;
    vec3 param_9 = rd;
    float param_10 = bounding_volume_intersection;
    vec4 param_11;
    float _1369 = calcIntersection(param_8, param_9, param_10, param_11);
    color = param_11;
    float intersection = _1369;
    if (intersection > 0.0)
    {
        vec3 ri = ro + (rd * intersection);
        vec3 param_12 = ri;
        vec3 normal = doModelNormal(param_12);
        vec3 world_normal = (mat_instance_model * vec4(normal, 0.0)).xyz;
        vec3 param_13 = normalize(world_normal);
        int param_14 = _1005.materialId;
        outNormalMaterial = encode_normal_material(param_13, param_14);
        ri -= instance_function_origin;
        ri /= _201.raymarch_params.function_scale;
        ri = ((_1139.transform_params.mView * mat_instance_model) * vec4(ri, 1.0)).xyz;
        outAlbedo.x = color.xyz.x;
        outAlbedo.y = color.xyz.y;
        outAlbedo.z = color.xyz.z;
        outAlbedo.w = 1.0 - color.w;
    }
    else
    {
        if (_201.raymarch_params.show_bounding_box != 0)
        {
            if (intersection == (-1.0))
            {
                outAlbedo = vec4(0.4000000059604644775390625, 0.20000000298023223876953125, 0.0, 1.0);
            }
            else
            {
                outAlbedo = vec4(5.0, 0.0, 0.0, 1.0);
            }
            vec3 _1452 = fract(vtx_input.vCoords * 0.00999999977648258209228515625);
            outAlbedo.x = _1452.x;
            outAlbedo.y = _1452.y;
            outAlbedo.z = _1452.z;
        }
        else
        {
            outAlbedo.w = 1.0;
            discard;
        }
    }
}

 