#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct ParticleModifierSwirl_Params
{
    vec3 position;
    int falloff_curve_idx;
    vec3 radius;
    int falloff_inverse;
    float velocity;
    float velocity_randomness;
    float time_step;
    float axis_randomness;
    vec3 axis;
    float _pad0;
    vec3 scale;
    float _pad1;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ParticleEmitterInstances_Params
{
    vec4 particle_color;
    vec3 primitive_size;
    float particle_lifetime;
    vec3 position_randomness;
    float particle_lifetime_randomness;
    float rate;
    float seed;
    int pending;
    int _instance_buffer_capacity;
};

struct ParticleModifierCurl_Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 noise_strength;
    float noise_speed;
    vec3 noise_scale;
    float time_step;
};

struct ParticleModifierColorize_Params
{
    int mode;
    int color_gradient_idx;
    float randomness;
    float blend_from_previous;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct InstanceParamsVM1
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct InstanceParamsVM4
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct ParticleLifecycleParams
{
    float time_step;
    float max_lifetime;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _360;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    vec4 prt_positions[];
} _385;

layout(set = 0, binding = 11, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _948;

layout(set = 0, binding = 3, std430) buffer VM0
{
    ParticleModifierSwirl_Params VM0_params;
} _1342;

layout(set = 0, binding = 4, std430) buffer VM1
{
    ParticleEmitterInstances_Params VM1_params;
} _1364;

layout(set = 0, binding = 12, std140) uniform InstanceParamsBufferVM1
{
    InstanceParamsVM1 instance_params_VM1;
} _1407;

layout(set = 0, binding = 5, std430) buffer InstanceTransformBufferVM1
{
    vec4 instance_transform_VM1[];
} _1420;

layout(set = 0, binding = 6, std430) buffer VM2
{
    ParticleModifierSwirl_Params VM2_params;
} _1496;

layout(set = 0, binding = 7, std430) buffer VM3
{
    ParticleModifierCurl_Params VM3_params;
} _1516;

layout(set = 0, binding = 8, std430) buffer VM4
{
    ParticleEmitterInstances_Params VM4_params;
} _1537;

layout(set = 0, binding = 13, std140) uniform InstanceParamsBufferVM4
{
    InstanceParamsVM4 instance_params_VM4;
} _1576;

layout(set = 0, binding = 9, std430) buffer InstanceTransformBufferVM4
{
    vec4 instance_transform_VM4[];
} _1588;

layout(set = 0, binding = 10, std430) buffer VM5
{
    ParticleModifierColorize_Params VM5_params;
} _1663;

layout(set = 0, binding = 14, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _1678;

layout(set = 0, binding = 15) uniform sampler2D s_Curves;
layout(set = 0, binding = 16) uniform sampler2D s_Gradients;

vec3 prt_get_position(uint id)
{
    return _385.prt_positions[id].xyz;
}

ParticleState prt_get_state(uint id)
{
    ParticleState _366;
    _366.life_time = _360.prt_states[id].life_time;
    _366.life_span = _360.prt_states[id].life_span;
    _366.generation_id = _360.prt_states[id].generation_id;
    _366.color = _360.prt_states[id].color;
    ParticleState _365 = _366;
    return _365;
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _343 = hash(param);
    uint param_1 = _343;
    float _345 = floatConstruct(param_1);
    return _345;
}

vec4 quaternion_from_axis_angle(vec3 axis, float angle_in_radians)
{
    vec4 v = vec4((-axis) * sin(angle_in_radians * 0.5), cos(angle_in_radians * 0.5));
    return v;
}

vec3 vector_rotate_by_quaternion(vec3 v, vec4 q)
{
    vec3 u = q.xyz;
    float s = q.w;
    return ((u * (2.0 * dot(u, v))) + (v * ((s * s) - dot(u, u)))) + (cross(u, v) * (2.0 * s));
}

void particle_modifier_swirl(ParticleModifierSwirl_Params modifier_params, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec3 influence_pos = p.pos;
    float influence = length((influence_pos - modifier_position) / (modifier_params.radius * 0.5));
    if (influence > 1.0)
    {
        influence = 1.0;
    }
    if (modifier_params.falloff_inverse == 0)
    {
        influence = 1.0 - influence;
    }
    influence = 1.0 - influence;
    int param = modifier_params.falloff_curve_idx;
    float param_1 = influence;
    influence = clamp(curve_sample(param, param_1), 0.0, 1.0);
    vec3 axis = modifier_params.axis;
    float param_2 = float(id) * 0.012470000423491001129150390625;
    float randomness_1 = random(param_2);
    float param_3 = float(id) * 0.1031199991703033447265625;
    float randomness_2 = random(param_3);
    axis.x += (randomness_1 * modifier_params.axis_randomness);
    axis.y -= (randomness_1 * modifier_params.axis_randomness);
    axis.z += (randomness_2 * modifier_params.axis_randomness);
    axis = normalize(axis);
    float angle_rad = modifier_params.velocity * (1.0 + (randomness_1 * modifier_params.velocity_randomness));
    angle_rad *= (modifier_params.time_step * influence);
    vec3 param_4 = axis;
    float param_5 = angle_rad;
    vec4 q = quaternion_from_axis_angle(param_4, param_5);
    vec3 pos = p.pos - modifier_params.position;
    vec3 param_6 = pos;
    vec4 param_7 = q;
    pos = vector_rotate_by_quaternion(param_6, param_7);
    vec3 pos_scaled = pos * modifier_params.scale;
    pos = mix(pos, pos_scaled, vec3(modifier_params.time_step * influence));
    pos += modifier_params.position;
    p.pos = pos;
}

float particle_emitter_instances_rand(float n)
{
    float param = n;
    return random(param);
}

void prt_spawn(inout ParticleState state, float life_span)
{
    state.life_time = 0.0;
    state.life_span = life_span;
    state.generation_id += 1.0;
}

uint color_convert_rgb_float3_uint(inout vec3 v)
{
    float v_mag = ceil(length(v));
    v /= vec3(v_mag);
    v_mag = min(255.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    return vi;
}

void prt_set_color(inout ParticleState state, vec3 c)
{
    vec3 param = c;
    uint _421 = color_convert_rgb_float3_uint(param);
    uint v = _421;
    state.color = v;
}

void particle_emitter_instances_emit(ParticleEmitterInstances_Params emitter_params, vec4 instance_transform0, vec4 instance_transform1, vec4 instance_transform2, inout Particle p, uint id)
{
    float fid = float(id);
    float param = (_948.globals.time + (fid * 5.131999969482421875)) + emitter_params.seed;
    float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * particle_emitter_instances_rand(param)));
    ParticleState param_1 = p.state;
    float param_2 = lifetime;
    prt_spawn(param_1, param_2);
    p.state = param_1;
    vec3 pos = vec3(instance_transform0.w, instance_transform1.w, instance_transform2.w);
    float param_3 = fid + (emitter_params.seed * 0.1271300017833709716796875);
    pos.x += (emitter_params.position_randomness.x * (particle_emitter_instances_rand(param_3) - 0.5));
    float param_4 = fid - (emitter_params.seed * 1.2127130031585693359375);
    pos.y += (emitter_params.position_randomness.y * (particle_emitter_instances_rand(param_4) - 0.5));
    float param_5 = fid + (emitter_params.seed * 2.3127129077911376953125);
    pos.z += (emitter_params.position_randomness.z * (particle_emitter_instances_rand(param_5) - 0.5));
    p.pos = pos;
    ParticleState param_6 = p.state;
    vec3 param_7 = emitter_params.particle_color.xyz;
    prt_set_color(param_6, param_7);
    p.state = param_6;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

vec3 pm_curl_snoiseVec3(vec3 x)
{
    vec3 param = vec3(x);
    float s = snoise(param);
    vec3 param_1 = vec3(x.y - 19.1000003814697265625, x.z + 33.40000152587890625, x.x + 47.200000762939453125);
    float s1 = snoise(param_1);
    vec3 param_2 = vec3(x.z + 74.1999969482421875, x.x - 124.5, x.y + 99.40000152587890625);
    float s2 = snoise(param_2);
    vec3 c = vec3(s, s1, s2);
    return c;
}

vec3 pm_curl_curlNoise(vec3 p, out vec3 gradient, out float out_scale)
{
    vec3 dx = vec3(0.100000001490116119384765625, 0.0, 0.0);
    vec3 dy = vec3(0.0, 0.100000001490116119384765625, 0.0);
    vec3 dz = vec3(0.0, 0.0, 0.100000001490116119384765625);
    vec3 param = p - dx;
    vec3 p_x0 = pm_curl_snoiseVec3(param);
    vec3 param_1 = p + dx;
    vec3 p_x1 = pm_curl_snoiseVec3(param_1);
    vec3 param_2 = p - dy;
    vec3 p_y0 = pm_curl_snoiseVec3(param_2);
    vec3 param_3 = p + dy;
    vec3 p_y1 = pm_curl_snoiseVec3(param_3);
    vec3 param_4 = p - dz;
    vec3 p_z0 = pm_curl_snoiseVec3(param_4);
    vec3 param_5 = p + dz;
    vec3 p_z1 = pm_curl_snoiseVec3(param_5);
    float x = ((p_y1.z - p_y0.z) - p_z1.y) + p_z0.y;
    float y = ((p_z1.x - p_z0.x) - p_x1.z) + p_x0.z;
    float z = ((p_x1.y - p_x0.y) - p_y1.x) + p_y0.x;
    gradient = vec3(p_x0.x, p_y0.y, p_z0.z) * 3.1400001049041748046875;
    out_scale = p_x0.x;
    return normalize(vec3(x, y, z));
}

void particle_modifier_curl(ParticleModifierCurl_Params modifier_params, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec3 param = (p.pos * modifier_params.noise_scale) + (vec3(_948.globals.time, _948.globals.time * 0.3014999926090240478515625, (-_948.globals.time) * 0.3129999935626983642578125) * modifier_params.noise_speed);
    vec3 param_1;
    float param_2;
    vec3 _1214 = pm_curl_curlNoise(param, param_1, param_2);
    vec3 gradient = param_1;
    float out_scale = param_2;
    p.pos += ((_1214 * modifier_params.noise_strength) * modifier_params.time_step);
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(ParticleState state)
{
    vec4 c = vec4(1.0);
    uint param = state.color;
    vec3 _408 = color_convert_uint_to_float3(param);
    c.x = _408.x;
    c.y = _408.y;
    c.z = _408.z;
    return c;
}

void particle_modifier_colorize(ParticleModifierColorize_Params modifier_params, inout Particle p, uint id)
{
    if (modifier_params.color_gradient_idx == (-1))
    {
        return;
    }
    float v = 0.0;
    if (modifier_params.mode == 0)
    {
        v = float(id) * modifier_params.randomness;
    }
    if (modifier_params.mode == 1)
    {
        vec3 param = p.pos * modifier_params.randomness;
        v = snoise(param);
    }
    if (modifier_params.mode == 2)
    {
        if (p.state.life_time == 0.0)
        {
            vec3 param_1 = p.pos * modifier_params.randomness;
            v = snoise(param_1);
        }
        else
        {
            return;
        }
    }
    v = fract(v);
    int param_2 = modifier_params.color_gradient_idx;
    float param_3 = v;
    vec3 color = gradient_sample(param_2, param_3).xyz;
    ParticleState param_4 = p.state;
    vec4 color_previous = prt_get_color(param_4);
    color = mix(color_previous.xyz, color, vec3(modifier_params.blend_from_previous));
    ParticleState param_5 = p.state;
    vec3 param_6 = color;
    prt_set_color(param_5, param_6);
    p.state = param_5;
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _373;
    _373.life_time = state.life_time;
    _373.life_span = state.life_span;
    _373.generation_id = state.generation_id;
    _373.color = state.color;
    _360.prt_states[id] = _373;
}

void prt_set_position(uint id, vec3 p)
{
    _385.prt_positions[id].x = p.x;
    _385.prt_positions[id].y = p.y;
    _385.prt_positions[id].z = p.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    ParticleState param_2 = p.state;
    if (prt_is_alive(param_2))
    {
        ParticleModifierSwirl_Params _1347;
        _1347.position = _1342.VM0_params.position;
        _1347.falloff_curve_idx = _1342.VM0_params.falloff_curve_idx;
        _1347.radius = _1342.VM0_params.radius;
        _1347.falloff_inverse = _1342.VM0_params.falloff_inverse;
        _1347.velocity = _1342.VM0_params.velocity;
        _1347.velocity_randomness = _1342.VM0_params.velocity_randomness;
        _1347.time_step = _1342.VM0_params.time_step;
        _1347.axis_randomness = _1342.VM0_params.axis_randomness;
        _1347.axis = _1342.VM0_params.axis;
        _1347._pad0 = _1342.VM0_params._pad0;
        _1347.scale = _1342.VM0_params.scale;
        _1347._pad1 = _1342.VM0_params._pad1;
        ParticleModifierSwirl_Params param_3 = _1347;
        Particle param_4 = p;
        uint param_5 = id;
        particle_modifier_swirl(param_3, param_4, param_5);
        p = param_4;
    }
    ParticleState param_6 = p.state;
    bool _1358 = !prt_is_alive(param_6);
    bool _1369;
    if (_1358)
    {
        _1369 = _1364.VM1_params.pending > 0;
    }
    else
    {
        _1369 = _1358;
    }
    if (_1369)
    {
        int final_emit_idx = -1;
        for (int pi = 0; pi < 8; pi++)
        {
            float param_7 = float(id) * 1.61803400516510009765625;
            float fid = random(param_7);
            uint instance_id = uint(fid * 10000000.0);
            instance_id = (instance_id + uint(_1364.VM1_params.seed)) + uint(pi * 7919);
            instance_id %= uint(_1407.instance_params_VM1.instance_count);
            uint transform_idx = instance_id * 3u;
            vec4 instance_transform0 = _1420.instance_transform_VM1[transform_idx + 0u];
            float s = dot(instance_transform0.xyz, instance_transform0.xyz);
            if (s > 9.9999997473787516355514526367188e-06)
            {
                final_emit_idx = int(instance_id);
                break;
            }
        }
        if (final_emit_idx != (-1))
        {
            int _1447 = atomicAdd(_1364.VM1_params.pending, -1);
            int pending = _1447;
            if (pending > 0)
            {
                uint transform_idx_1 = uint(final_emit_idx) * 3u;
                vec4 instance_transform0_1 = _1420.instance_transform_VM1[transform_idx_1 + 0u];
                vec4 instance_transform1 = _1420.instance_transform_VM1[transform_idx_1 + 1u];
                vec4 instance_transform2 = _1420.instance_transform_VM1[transform_idx_1 + 2u];
                ParticleEmitterInstances_Params _1475;
                _1475.particle_color = _1364.VM1_params.particle_color;
                _1475.primitive_size = _1364.VM1_params.primitive_size;
                _1475.particle_lifetime = _1364.VM1_params.particle_lifetime;
                _1475.position_randomness = _1364.VM1_params.position_randomness;
                _1475.particle_lifetime_randomness = _1364.VM1_params.particle_lifetime_randomness;
                _1475.rate = _1364.VM1_params.rate;
                _1475.seed = _1364.VM1_params.seed;
                _1475.pending = _1364.VM1_params.pending;
                _1475._instance_buffer_capacity = _1364.VM1_params._instance_buffer_capacity;
                ParticleEmitterInstances_Params param_8 = _1475;
                vec4 param_9 = instance_transform0_1;
                vec4 param_10 = instance_transform1;
                vec4 param_11 = instance_transform2;
                Particle param_12 = p;
                uint param_13 = id;
                particle_emitter_instances_emit(param_8, param_9, param_10, param_11, param_12, param_13);
                p = param_12;
            }
        }
    }
    ParticleState param_14 = p.state;
    if (prt_is_alive(param_14))
    {
        ParticleModifierSwirl_Params _1500;
        _1500.position = _1496.VM2_params.position;
        _1500.falloff_curve_idx = _1496.VM2_params.falloff_curve_idx;
        _1500.radius = _1496.VM2_params.radius;
        _1500.falloff_inverse = _1496.VM2_params.falloff_inverse;
        _1500.velocity = _1496.VM2_params.velocity;
        _1500.velocity_randomness = _1496.VM2_params.velocity_randomness;
        _1500.time_step = _1496.VM2_params.time_step;
        _1500.axis_randomness = _1496.VM2_params.axis_randomness;
        _1500.axis = _1496.VM2_params.axis;
        _1500._pad0 = _1496.VM2_params._pad0;
        _1500.scale = _1496.VM2_params.scale;
        _1500._pad1 = _1496.VM2_params._pad1;
        ParticleModifierSwirl_Params param_15 = _1500;
        Particle param_16 = p;
        uint param_17 = id;
        particle_modifier_swirl(param_15, param_16, param_17);
        p = param_16;
    }
    ParticleState param_18 = p.state;
    if (prt_is_alive(param_18))
    {
        ParticleModifierCurl_Params _1521;
        _1521.position = _1516.VM3_params.position;
        _1521.falloff_mode = _1516.VM3_params.falloff_mode;
        _1521.radius = _1516.VM3_params.radius;
        _1521.falloff_inverse = _1516.VM3_params.falloff_inverse;
        _1521.noise_strength = _1516.VM3_params.noise_strength;
        _1521.noise_speed = _1516.VM3_params.noise_speed;
        _1521.noise_scale = _1516.VM3_params.noise_scale;
        _1521.time_step = _1516.VM3_params.time_step;
        ParticleModifierCurl_Params param_19 = _1521;
        Particle param_20 = p;
        uint param_21 = id;
        particle_modifier_curl(param_19, param_20, param_21);
        p = param_20;
    }
    ParticleState param_22 = p.state;
    bool _1532 = !prt_is_alive(param_22);
    bool _1541;
    if (_1532)
    {
        _1541 = _1537.VM4_params.pending > 0;
    }
    else
    {
        _1541 = _1532;
    }
    if (_1541)
    {
        int final_emit_idx_1 = -1;
        for (int pi_1 = 0; pi_1 < 8; pi_1++)
        {
            float param_23 = float(id) * 1.61803400516510009765625;
            float fid_1 = random(param_23);
            uint instance_id_1 = uint(fid_1 * 10000000.0);
            instance_id_1 = (instance_id_1 + uint(_1537.VM4_params.seed)) + uint(pi_1 * 7919);
            instance_id_1 %= uint(_1576.instance_params_VM4.instance_count);
            uint transform_idx_2 = instance_id_1 * 3u;
            vec4 instance_transform0_2 = _1588.instance_transform_VM4[transform_idx_2 + 0u];
            float s_1 = dot(instance_transform0_2.xyz, instance_transform0_2.xyz);
            if (s_1 > 9.9999997473787516355514526367188e-06)
            {
                final_emit_idx_1 = int(instance_id_1);
                break;
            }
        }
        if (final_emit_idx_1 != (-1))
        {
            int _1614 = atomicAdd(_1537.VM4_params.pending, -1);
            int pending_1 = _1614;
            if (pending_1 > 0)
            {
                uint transform_idx_3 = uint(final_emit_idx_1) * 3u;
                vec4 instance_transform0_3 = _1588.instance_transform_VM4[transform_idx_3 + 0u];
                vec4 instance_transform1_1 = _1588.instance_transform_VM4[transform_idx_3 + 1u];
                vec4 instance_transform2_1 = _1588.instance_transform_VM4[transform_idx_3 + 2u];
                ParticleEmitterInstances_Params _1641;
                _1641.particle_color = _1537.VM4_params.particle_color;
                _1641.primitive_size = _1537.VM4_params.primitive_size;
                _1641.particle_lifetime = _1537.VM4_params.particle_lifetime;
                _1641.position_randomness = _1537.VM4_params.position_randomness;
                _1641.particle_lifetime_randomness = _1537.VM4_params.particle_lifetime_randomness;
                _1641.rate = _1537.VM4_params.rate;
                _1641.seed = _1537.VM4_params.seed;
                _1641.pending = _1537.VM4_params.pending;
                _1641._instance_buffer_capacity = _1537.VM4_params._instance_buffer_capacity;
                ParticleEmitterInstances_Params param_24 = _1641;
                vec4 param_25 = instance_transform0_3;
                vec4 param_26 = instance_transform1_1;
                vec4 param_27 = instance_transform2_1;
                Particle param_28 = p;
                uint param_29 = id;
                particle_emitter_instances_emit(param_24, param_25, param_26, param_27, param_28, param_29);
                p = param_28;
            }
        }
    }
    ParticleState param_30 = p.state;
    if (prt_is_alive(param_30))
    {
        ParticleModifierColorize_Params _1668;
        _1668.mode = _1663.VM5_params.mode;
        _1668.color_gradient_idx = _1663.VM5_params.color_gradient_idx;
        _1668.randomness = _1663.VM5_params.randomness;
        _1668.blend_from_previous = _1663.VM5_params.blend_from_previous;
        ParticleModifierColorize_Params param_31 = _1668;
        Particle param_32 = p;
        uint param_33 = id;
        particle_modifier_colorize(param_31, param_32, param_33);
        p = param_32;
    }
    ParticleState param_34 = p.state;
    float param_35 = _1678.lifecycle_params.time_step;
    float param_36 = _1678.lifecycle_params.max_lifetime;
    prt_advance_life(param_34, param_35, param_36);
    p.state = param_34;
    uint param_37 = id;
    ParticleState param_38 = p.state;
    prt_set_state(param_37, param_38);
    uint param_39 = id;
    vec3 param_40 = p.pos;
    prt_set_position(param_39, param_40);
}

 