#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ProcessInstanceModifiersParams
{
    int buffer_capacity;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct link_list_node
{
    uint value;
    uint next;
};

layout(set = 0, binding = 4, std140) uniform ProcessInstanceModifiersParamsBuffer
{
    ProcessInstanceModifiersParams process_modifiers_params;
} _22;

layout(set = 0, binding = 5, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _37;

layout(set = 0, binding = 1, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _54;

layout(set = 0, binding = 2, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _83;

layout(set = 0, binding = 3, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _111;

void main()
{
    uint id = gl_GlobalInvocationID.x;
    if (id >= uint(_22.process_modifiers_params.buffer_capacity))
    {
        return;
    }
    if (id >= uint(_37.instance_params.instance_count))
    {
        return;
    }
    Instance instance;
    instance.m0 = _54.instance_transform[(id * 3u) + 0u];
    instance.m1 = _54.instance_transform[(id * 3u) + 1u];
    instance.m2 = _54.instance_transform[(id * 3u) + 2u];
    vec2 _91 = unpackHalf2x16(_83.instance_color[(id * 2u) + 0u]);
    instance.c.x = _91.x;
    instance.c.y = _91.y;
    vec2 _102 = unpackHalf2x16(_83.instance_color[(id * 2u) + 1u]);
    instance.c.z = _102.x;
    instance.c.w = _102.y;
    instance.hash = _111.instance_hash[id];
    _54.instance_transform[(id * 3u) + 0u] = instance.m0;
    _54.instance_transform[(id * 3u) + 1u] = instance.m1;
    _54.instance_transform[(id * 3u) + 2u] = instance.m2;
    _83.instance_color[(id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _83.instance_color[(id * 2u) + 1u] = packHalf2x16(instance.c.zw);
}

 