#version 450
layout(points) in;
layout(max_vertices = 1, points) out;

struct TransformGeometryOutputVertexParams
{
    int coord_stride;
    int normal_stride;
    int uv0_stride;
    int coord_offset;
    int normal_offset;
    int uv0_offset;
    int _pad0;
    int _pad1;
};

struct TransformGeometryParams
{
    TransformGeometryOutputVertexParams output_vtx_params;
    uint instance_idx;
    uint surface_idx;
    uint voxelize;
    uint raytrace;
    uint material_idx;
    int _points_per_instance;
    int _faces_per_instance;
    int transform_normals;
    int calculate_bbox_raytrace;
    int calculate_bbox_voxelize;
    uint _instances_num;
    uint _pad1;
    vec3 default_bbox_raytrace_min;
    vec3 default_bbox_raytrace_max;
    vec3 default_bbox_voxelize_min;
    vec3 default_bbox_voxelize_max;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 2, binding = 4, std140) uniform TransformGeometryParamsBuffer
{
    TransformGeometryParams transform_geometry_params;
} _42;

layout(set = 2, binding = 1, std430) buffer TransformedDataGeometryBuffer
{
    float data[];
} out_vtx_data;

layout(set = 2, binding = 2, std430) buffer GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _144;

layout(set = 2, binding = 3, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _166;

layout(set = 2, binding = 5, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _185;

layout(location = 0) in uint instanceID[1];
layout(location = 1) in Vertex
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
} vtx_inputs[1];


void put_coords(uint idx, vec3 p)
{
    uint coord_offset = uint(_42.transform_geometry_params.output_vtx_params.coord_offset) + (idx * uint(_42.transform_geometry_params.output_vtx_params.coord_stride));
    out_vtx_data.data[coord_offset + 0u] = p.x;
    out_vtx_data.data[coord_offset + 1u] = p.y;
    out_vtx_data.data[coord_offset + 2u] = p.z;
}

float asfloat(uint v)
{
    return uintBitsToFloat(v);
}

void put_normal(uint idx, vec3 p)
{
    uint normal_offset = (idx * 2u) + 30000000u;
    uint n1 = packSnorm2x16(p.xy);
    uint n2 = packSnorm2x16(vec2(p.z, 0.0));
    uint param = n1;
    out_vtx_data.data[normal_offset + 0u] = asfloat(param);
    uint param_1 = n2;
    out_vtx_data.data[normal_offset + 1u] = asfloat(param_1);
}

void put_uv0(uint idx, vec2 p)
{
    uint uv0_offset = uint(_42.transform_geometry_params.output_vtx_params.uv0_offset) + (idx * uint(_42.transform_geometry_params.output_vtx_params.uv0_stride));
    out_vtx_data.data[uv0_offset + 0u] = p.x;
    out_vtx_data.data[uv0_offset + 1u] = p.y;
}

void main()
{
    uint vtx_idx = uint(gl_PrimitiveIDIn) + (instanceID[0] * _144.geometry_information.vtx_num);
    uint prim_idx = _42.transform_geometry_params.instance_idx;
    uint out_vtx_idx = 0u;
    if (gl_PrimitiveIDIn == 0)
    {
        _166.transformed_data_location[prim_idx].surface_idx = 0u;
        _166.transformed_data_location[prim_idx].last_face_idx = 0u;
    }
    if (prim_idx == 0u)
    {
        if (vtx_idx == 0u)
        {
            _166.transformed_data_location[prim_idx].last_vtx_idx = (_144.geometry_information.vtx_num * uint(_185.instance_params.instance_count)) - 1u;
        }
        out_vtx_idx = vtx_idx;
    }
    else
    {
        out_vtx_idx = (_166.transformed_data_location[prim_idx - 1u].last_vtx_idx + vtx_idx) + 1u;
        if (vtx_idx == 0u)
        {
            _166.transformed_data_location[prim_idx].last_vtx_idx = (_166.transformed_data_location[prim_idx - 1u].last_vtx_idx + ((_144.geometry_information.vtx_num * uint(_185.instance_params.instance_count)) - 1u)) + 1u;
        }
    }
    vec3 p0 = vtx_inputs[0].vWorldPos;
    uint param = out_vtx_idx;
    vec3 param_1 = p0;
    put_coords(param, param_1);
    vec3 n0 = vec3(0.0);
    vec2 uv00 = vtx_inputs[0].vUV0;
    if (_42.transform_geometry_params.transform_normals != 0)
    {
        n0 = normalize(vtx_inputs[0].vWorldNorm);
    }
    uint param_2 = out_vtx_idx;
    vec3 param_3 = n0;
    put_normal(param_2, param_3);
    uint param_4 = out_vtx_idx;
    vec2 param_5 = uv00;
    put_uv0(param_4, param_5);
}

 