#version 450

struct VertexModifierUVParams
{
    mat4 transform;
    bool override;
    int override_mode;
};

struct VertexInput
{
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct VertexModifierUVParams_1
{
    mat4 transform;
    uint override;
    int override_mode;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct _437
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    vec3 vCameraPosition;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer VTXCoords
{
    float coords[];
} vtx_coords;

layout(set = 0, binding = 2, std430) buffer VTXNormals
{
    float normals[];
} vtx_normals;

layout(set = 0, binding = 3, std430) buffer VTXAlbedo
{
    float albedo[];
} vtx_albedo;

layout(set = 0, binding = 4, std430) buffer VTXUV0
{
    float uv0[];
} vtx_uv0;

layout(set = 0, binding = 7, std140) uniform GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _241;

layout(set = 0, binding = 8, std140) uniform VM0
{
    layout(row_major) VertexModifierUVParams_1 VM0_params;
} _287;

layout(set = 0, binding = 9, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _306;

layout(set = 0, binding = 5, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _317;

layout(set = 0, binding = 6, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _399;

layout(set = 0, binding = 10, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _448;

layout(location = 0) out uint instanceID;
layout(location = 1) out _437 vtx_output;

vec3 vtx_coords_load(uint idx)
{
    return vec3(vtx_coords.coords[(idx * 3u) + 0u], vtx_coords.coords[(idx * 3u) + 1u], vtx_coords.coords[(idx * 3u) + 2u]);
}

vec3 vtx_albedo_load(uint idx)
{
    return vec3(vtx_albedo.albedo[(idx * 3u) + 0u], vtx_albedo.albedo[(idx * 3u) + 1u], vtx_albedo.albedo[(idx * 3u) + 2u]);
}

vec3 vtx_normals_load(uint idx)
{
    return vec3(vtx_normals.normals[(idx * 3u) + 0u], vtx_normals.normals[(idx * 3u) + 1u], vtx_normals.normals[(idx * 3u) + 2u]);
}

vec2 vtx_uv0_load(uint idx)
{
    return vec2(vtx_uv0.uv0[(idx * 2u) + 0u], vtx_uv0.uv0[(idx * 2u) + 1u]);
}

void vertex_modifier_uv_apply(VertexModifierUVParams params, inout VertexInput vtx_input)
{
    vec2 uv = vtx_input.uv0;
    if (params.override)
    {
        if (params.override_mode == 0)
        {
            uv = vtx_input.pos.xy;
        }
        if (params.override_mode == 1)
        {
            uv = vtx_input.pos.yz;
        }
        if (params.override_mode == 2)
        {
            uv = vtx_input.pos.xz;
        }
        if (params.override_mode == 3)
        {
            uv.x = length(vtx_input.pos);
            uv.y = 0.0;
        }
    }
    uv = (params.transform * vec4(uv, 0.0, 1.0)).xy;
    vtx_input.uv0 = uv;
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

void main()
{
    uint param = uint(gl_VertexIndex);
    VertexInput vtx_input;
    vtx_input.pos = vtx_coords_load(param);
    vtx_input.norm = vec3(1.0, 0.0, 0.0);
    vtx_input.color = vec4(1.0);
    vtx_input.uv0 = vtx_input.pos.xy;
    if ((_241.geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = uint(gl_VertexIndex);
        vtx_input.color = vec4(vtx_albedo_load(param_1), 1.0);
    }
    if ((_241.geometry_information.builtin_attribute_mask & 2u) != 0u)
    {
        uint param_2 = uint(gl_VertexIndex);
        vtx_input.norm = vtx_normals_load(param_2);
    }
    if ((_241.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_3 = uint(gl_VertexIndex);
        vtx_input.uv0 = vtx_uv0_load(param_3);
    }
    VertexInput vtx_modifier_input_base = vtx_input;
    VertexModifierUVParams param_4;
    param_4.transform = _287.VM0_params.transform;
    param_4.override = _287.VM0_params.override != 0u;
    param_4.override_mode = _287.VM0_params.override_mode;
    VertexInput param_5 = vtx_input;
    vertex_modifier_uv_apply(param_4, param_5);
    vtx_input = param_5;
    if (_306.instance_params.stride > 0)
    {
        vec4 inst_m0 = _317.instance_transform[(gl_InstanceIndex * _306.instance_params.stride) + 0];
        vec4 inst_m1 = _317.instance_transform[(gl_InstanceIndex * _306.instance_params.stride) + 1];
        vec4 inst_m2 = _317.instance_transform[(gl_InstanceIndex * _306.instance_params.stride) + 2];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0, v);
        vtx_input.pos.y = dot(inst_m1, v);
        vtx_input.pos.z = dot(inst_m2, v);
        vec3 param_6 = vtx_input.norm;
        mat4 param_7 = transpose(mat4(vec4(inst_m0), vec4(inst_m1), vec4(inst_m2), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_6, param_7));
        vec2 _406 = unpackHalf2x16(_399.instance_color[(gl_InstanceIndex * 2) + 0]);
        vec4 inst_c;
        inst_c.x = _406.x;
        inst_c.y = _406.y;
        vec2 _416 = unpackHalf2x16(_399.instance_color[(gl_InstanceIndex * 2) + 1]);
        inst_c.z = _416.x;
        inst_c.w = _416.y;
        vec4 _422 = vtx_input.color;
        vec3 _426 = _422.xyz * inst_c.xyz;
        vtx_input.color.x = _426.x;
        vtx_input.color.y = _426.y;
        vtx_input.color.z = _426.z;
    }
    instanceID = uint(gl_InstanceIndex);
    vtx_output.vLocalPos = vtx_input.pos;
    vec3 param_8 = vtx_input.pos;
    mat4 param_9 = _448.transform_params.mModel;
    vec3 vPosModel = vector_transform_by_mat43(param_8, param_9);
    vec3 param_10 = vtx_input.norm;
    mat4 param_11 = _448.transform_params.mModelNormal;
    vtx_output.vWorldNorm = vec3(vector_transform_by_mat33(param_10, param_11));
    vec3 param_12 = vPosModel;
    mat4 param_13 = _448.transform_params.mView;
    vec3 vPosModelView = vector_transform_by_mat43(param_12, param_13);
    vtx_output.vCoords = vPosModelView;
    vtx_output.vWorldPos = vPosModel;
    vtx_output.vWorldNorm = normalize(vtx_output.vWorldNorm);
    vtx_output.vNorm.x = dot(_448.transform_params.mModelViewInvTrans[0].xyz, vtx_input.norm);
    vtx_output.vNorm.y = dot(_448.transform_params.mModelViewInvTrans[1].xyz, vtx_input.norm);
    vtx_output.vNorm.z = dot(_448.transform_params.mModelViewInvTrans[2].xyz, vtx_input.norm);
    vtx_output.vNorm = vec3(normalize(vtx_output.vNorm));
    vtx_output.vNorm = vec3(vtx_input.norm);
    vtx_output.vColor = vec4(vtx_input.color);
    vtx_output.vUV0 = vec2(vtx_input.uv0);
    gl_Position = _448.transform_params.mProjection * vec4(vtx_output.vCoords, 1.0);
}

 