#version 450

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct TexGenCustomParams
{
    vec2 resolution;
    vec2 resolutionInv;
    float param1;
    float param2;
    float _pad0;
    float _pad1;
};

layout(set = 1, binding = 1, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _54;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

void main()
{
    float y = vTexcoord0.y;
    float x = vTexcoord0.x;
    float angle = 0.0;
    float spread = 0.2060000002384185791015625;
    float s = sin((angle / 180.0) * 3.141590118408203125);
    float c = cos((angle / 180.0) * 3.141590118408203125);
    x *= c;
    y *= s;
    float m = fract(((x + y) / spread) + (_54.globals.time * 0.300000011920928955078125));
    if (m > 0.5)
    {
        m = 0.5 - (m - 0.5);
    }
    float d = smoothstep(0.300000011920928955078125, 0.699999988079071044921875, m * 2.0);
    vec4 base_color = vec4(d, d, d, 1.0);
    outColor = base_color;
}

 