#version 450
layout(local_size_x = 4, local_size_y = 4, local_size_z = 4) in;

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer OcclusionInputData
{
    uint in_data_occlusion[];
} _225;

layout(set = 0, binding = 2, std430) buffer ColorInputData
{
    uint in_data_color[];
} _410;

layout(set = 0, binding = 3, r8) uniform writeonly image3D imTarget0Occupancy;
layout(set = 0, binding = 4, rgba8) uniform writeonly image3D imTarget0Color;
layout(set = 0, binding = 5, rgba8) uniform writeonly image3D imTarget1Color;
layout(set = 0, binding = 6, r8) uniform writeonly image3D imTarget1Occupancy;
layout(set = 0, binding = 7, rgba8) uniform writeonly image3D imTarget2Color;
layout(set = 0, binding = 8, r8) uniform writeonly image3D imTarget2Occupancy;

shared vec4 cube_samples_mip1[4][4][4];

float rt_voxel_occlusion_decode(uint vi)
{
    return float(vi) / 1024.0;
}

vec4 color_convert_rgb_rgbm(inout vec3 v)
{
    v = sqrt(v);
    v /= vec3(128.0);
    vec4 rgbm;
    rgbm.w = clamp(max(max(v.x, v.y), max(v.z, 9.9999999747524270787835121154785e-07)), 0.0, 1.0);
    rgbm.w = ceil(rgbm.w * 256.0) / 255.0;
    float _62 = rgbm.w;
    vec3 _64 = v / vec3(_62);
    rgbm.x = _64.x;
    rgbm.y = _64.y;
    rgbm.z = _64.z;
    return rgbm;
}

vec4 rt_voxel_color_decode(uint vi)
{
    vec4 v = vec4(0.0);
    if ((vi >> uint(31)) > 0u)
    {
        uint v_mag = (vi >> uint(24)) & 127u;
        float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
        v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
        v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
        v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
        v.w = 1.0;
    }
    return v;
}

void main()
{
    uvec3 grid_pos_16x16x16 = uvec3(gl_WorkGroupID);
    uvec3 grid_pos = (grid_pos_16x16x16 * uvec3(8u)) + (uvec3(gl_LocalInvocationID) * uvec3(2u));
    int grid_size = 256;
    cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x] = vec4(0.0);
    barrier();
    memoryBarrierShared();
    uvec3 store_pos = grid_pos;
    bool all_occlusion_zero = true;
    for (int iz = 0; iz < 2; iz++)
    {
        for (int iy = 0; iy < 2; iy++)
        {
            for (int ix = 0; ix < 2; ix++)
            {
                uint source_off = (store_pos.x + (store_pos.y * uint(grid_size))) + ((store_pos.z * uint(grid_size)) * uint(grid_size));
                uint vi = _225.in_data_occlusion[source_off];
                uint param = vi;
                float a = rt_voxel_occlusion_decode(param);
                all_occlusion_zero = all_occlusion_zero && (a == 0.0);
                cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x].w += a;
                imageStore(imTarget0Occupancy, ivec3(store_pos), vec4(a));
                store_pos.x++;
            }
            store_pos.x -= 2u;
            store_pos.y++;
        }
        store_pos.y -= 2u;
        store_pos.z++;
    }
    store_pos = grid_pos;
    if (all_occlusion_zero)
    {
        for (int iz_1 = 0; iz_1 < 2; iz_1++)
        {
            for (int iy_1 = 0; iy_1 < 2; iy_1++)
            {
                for (int ix_1 = 0; ix_1 < 2; ix_1++)
                {
                    uint source_off_1 = (store_pos.x + (store_pos.y * uint(grid_size))) + ((store_pos.z * uint(grid_size)) * uint(grid_size));
                    vec4 v = vec4(0.0);
                    vec3 param_1 = v.xyz;
                    vec4 _339 = color_convert_rgb_rgbm(param_1);
                    imageStore(imTarget0Color, ivec3(store_pos), _339);
                    store_pos.x++;
                }
                store_pos.x -= 2u;
                store_pos.y++;
            }
            store_pos.y -= 2u;
            store_pos.z++;
        }
    }
    else
    {
        for (int iz_2 = 0; iz_2 < 2; iz_2++)
        {
            for (int iy_2 = 0; iy_2 < 2; iy_2++)
            {
                for (int ix_2 = 0; ix_2 < 2; ix_2++)
                {
                    uint source_off_2 = (store_pos.x + (store_pos.y * uint(grid_size))) + ((store_pos.z * uint(grid_size)) * uint(grid_size));
                    uint vi_1 = _410.in_data_color[source_off_2];
                    uint param_2 = vi_1;
                    vec4 v_1 = rt_voxel_color_decode(param_2);
                    vec3 param_3 = v_1.xyz;
                    vec4 _424 = color_convert_rgb_rgbm(param_3);
                    imageStore(imTarget0Color, ivec3(store_pos), _424);
                    vec4 _434 = cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x];
                    vec3 _436 = _434.xyz + v_1.xyz;
                    cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x].x = _436.x;
                    cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x].y = _436.y;
                    cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x].z = _436.z;
                    store_pos.x++;
                }
                store_pos.x -= 2u;
                store_pos.y++;
            }
            store_pos.y -= 2u;
            store_pos.z++;
        }
    }
    barrier();
    groupMemoryBarrier();
    memoryBarrierShared();
    store_pos = grid_pos;
    for (int iz_3 = 0; iz_3 < 2; iz_3++)
    {
        for (int iy_3 = 0; iy_3 < 2; iy_3++)
        {
            for (int ix_3 = 0; ix_3 < 2; ix_3++)
            {
                uint source_off_3 = (store_pos.x + (store_pos.y * uint(grid_size))) + ((store_pos.z * uint(grid_size)) * uint(grid_size));
                _410.in_data_color[source_off_3] = 0u;
                _225.in_data_occlusion[source_off_3] = 0u;
                store_pos.x++;
            }
            store_pos.x -= 2u;
            store_pos.y++;
        }
        store_pos.y -= 2u;
        store_pos.z++;
    }
    for (int iz_4 = 0; iz_4 < 1; iz_4++)
    {
        for (int iy_4 = 0; iy_4 < 1; iy_4++)
        {
            for (int ix_4 = 0; ix_4 < 1; ix_4++)
            {
                store_pos = (grid_pos / uvec3(2u)) + uvec3(ivec3(ix_4, iy_4, iz_4));
                vec4 samples_color = vec4(0.0);
                samples_color.w = cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x].w / 4.0;
                vec3 _592 = cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x].xyz / vec3(4.0);
                samples_color.x = _592.x;
                samples_color.y = _592.y;
                samples_color.z = _592.z;
                vec3 param_4 = samples_color.xyz;
                vec4 _606 = color_convert_rgb_rgbm(param_4);
                imageStore(imTarget1Color, ivec3(store_pos), _606);
                imageStore(imTarget1Occupancy, ivec3(store_pos), samples_color.wwww);
            }
        }
    }
    bool _622 = (gl_LocalInvocationID.z & 1u) == 0u;
    bool _629;
    if (_622)
    {
        _629 = (gl_LocalInvocationID.y & 1u) == 0u;
    }
    else
    {
        _629 = _622;
    }
    bool _636;
    if (_629)
    {
        _636 = (gl_LocalInvocationID.x & 1u) == 0u;
    }
    else
    {
        _636 = _629;
    }
    if (_636)
    {
        uint _641 = gl_LocalInvocationID.z + 0u;
        uint _644 = gl_LocalInvocationID.y + 0u;
        uint _647 = gl_LocalInvocationID.x + 0u;
        vec4 _730 = (((((cube_samples_mip1[gl_LocalInvocationID.z + 1u][gl_LocalInvocationID.y + 0u][gl_LocalInvocationID.x + 0u] + cube_samples_mip1[gl_LocalInvocationID.z + 0u][gl_LocalInvocationID.y + 1u][gl_LocalInvocationID.x + 0u]) + cube_samples_mip1[gl_LocalInvocationID.z + 1u][gl_LocalInvocationID.y + 1u][gl_LocalInvocationID.x + 0u]) + cube_samples_mip1[gl_LocalInvocationID.z + 0u][gl_LocalInvocationID.y + 0u][gl_LocalInvocationID.x + 1u]) + cube_samples_mip1[gl_LocalInvocationID.z + 1u][gl_LocalInvocationID.y + 0u][gl_LocalInvocationID.x + 1u]) + cube_samples_mip1[gl_LocalInvocationID.z + 0u][gl_LocalInvocationID.y + 1u][gl_LocalInvocationID.x + 1u]) + cube_samples_mip1[gl_LocalInvocationID.z + 1u][gl_LocalInvocationID.y + 1u][gl_LocalInvocationID.x + 1u];
        cube_samples_mip1[_641][_644][_647] += _730;
        uint _737 = gl_LocalInvocationID.z + 0u;
        uint _740 = gl_LocalInvocationID.y + 0u;
        uint _743 = gl_LocalInvocationID.x + 0u;
        cube_samples_mip1[_737][_740][_743] /= vec4(16.0);
        vec3 param_5 = cube_samples_mip1[gl_LocalInvocationID.z + 0u][gl_LocalInvocationID.y + 0u][gl_LocalInvocationID.x + 0u].xyz;
        vec4 _769 = color_convert_rgb_rgbm(param_5);
        imageStore(imTarget2Color, ivec3(grid_pos / uvec3(4u)), _769);
        imageStore(imTarget2Occupancy, ivec3(grid_pos / uvec3(4u)), cube_samples_mip1[gl_LocalInvocationID.z + 0u][gl_LocalInvocationID.y + 0u][gl_LocalInvocationID.x + 0u].wwww);
    }
}

 