#version 450

struct TexGenCustomParams
{
    vec2 resolution;
    vec2 resolutionInv;
    float param1;
    float param2;
    float _pad0;
    float _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

layout(set = 1, binding = 1, std140) uniform TexGenCustomParamsBuffer
{
    TexGenCustomParams params;
} _14;

layout(set = 1, binding = 2, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _46;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

void main()
{
    float threshold = _14.params.param1 / 100.0;
    float r = vTexcoord0.x;
    float v_color = 1.0;
    float v_alpha = 1.0;
    if (r > 0.0)
    {
        v_color = fract((r * 4.0) + (_46.globals.time * 0.300000011920928955078125));
        v_color = smoothstep(0.5, 0.60000002384185791015625, v_color);
    }
    r = vTexcoord0.x - threshold;
    if (r > 0.0)
    {
        v_alpha = fract(r * _14.params.param2);
        v_alpha = smoothstep(0.5, 0.60000002384185791015625, v_alpha);
    }
    v_color = min(1.0, v_color + 0.5);
    vec4 base_color = vec4(v_color, v_color * 0.699999988079071044921875, v_color * 0.300000011920928955078125, v_alpha);
    outColor = base_color;
}

 