#version 450

struct TexGenCustomParams
{
    vec2 resolution;
    vec2 resolutionInv;
    float param1;
    float param2;
    float _pad0;
    float _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform TexGenCustomParamsBuffer
{
    TexGenCustomParams params;
} _37;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

void main()
{
    float t = vTexcoord0.x;
    vec4 base_color = vec4(0.0);
    t = sqrt(t);
    base_color.x = 1.0 - t;
    base_color.y = ((base_color.x * base_color.x) * _37.params.param1) * 0.00999999977648258209228515625;
    base_color.z = (base_color.x * _37.params.param2) * 0.00999999977648258209228515625;
    base_color.w = 1.0 - t;
    outColor = base_color;
}

 