#version 450
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct DispatchParams
{
    mat4 mat_projection;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
};

struct FromDepthParams
{
    vec2 resolution;
    vec2 inv_resolution;
    float depth_min;
    float depth_max;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std140) uniform DeferredParams
{
    layout(row_major) DispatchParams dispatch_setup;
} _26;

layout(set = 0, binding = 2, std140) uniform FromDepthParamsBuffer
{
    FromDepthParams from_depth_params;
} _165;

layout(set = 0, binding = 4) uniform sampler2D sAlbedo;
layout(set = 0, binding = 5) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 3, r8) uniform writeonly image2D imTarget;

float linearizeDepth(float d)
{
    return _26.dispatch_setup.near_far_plane.z / ((_26.dispatch_setup.near_far_plane.y + _26.dispatch_setup.near_far_plane.x) - (d * _26.dispatch_setup.near_far_plane.w));
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return _26.dispatch_setup.camera_position + (_26.dispatch_setup.mat_model * vec4(vDirection * depth, 0.0)).xyz;
}

void main()
{
    ivec2 storePos = ivec2(gl_GlobalInvocationID.xy);
    vec2 tex_coord = vec2(storePos) * _26.dispatch_setup.inv_resolution;
    vec3 view_direction;
    view_direction.x = ((-_26.dispatch_setup.camera_projection_params.x) * 0.5) + ((_26.dispatch_setup.camera_projection_params.x * float(storePos.x)) * _26.dispatch_setup.inv_resolution.x);
    view_direction.y = ((-_26.dispatch_setup.camera_projection_params.y) * 0.5) + ((_26.dispatch_setup.camera_projection_params.y * float(storePos.y)) * _26.dispatch_setup.inv_resolution.y);
    view_direction.z = 1.0;
    vec4 albedo = texelFetch(sAlbedo, storePos, 0);
    float depth = texelFetch(sTextureDepth, storePos, 0).x;
    float param = depth;
    float linear_depth = linearizeDepth(param);
    vec3 param_1 = view_direction;
    float param_2 = linear_depth;
    vec3 view_coords = positionFromDepth(param_1, param_2);
    float output_val = 0.0;
    if (depth < 1.0)
    {
        float v = (linear_depth - _165.from_depth_params.depth_min) / (_165.from_depth_params.depth_max - _165.from_depth_params.depth_min);
        v = clamp(v, 0.0, 1.0);
        output_val = v;
    }
    imageStore(imTarget, storePos, vec4(output_val, 0.0, 0.0, 0.0));
}

 