#version 450

struct VertexModifierUVParams
{
    mat4 transform;
    bool override;
    int override_mode;
};

struct VertexInput
{
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct VertexModifierNoiseParams
{
    mat4 transform_world_to_local;
    mat4 transform_local_to_world;
    mat4 transform_local;
    mat4 transform_local_inv;
    mat4 transform_parent;
    mat4 transform_parent_inv;
    vec4 noise_phase;
    vec3 noise_scale;
    int falloff_curve_idx;
    vec3 scale;
    int falloff_inverse;
    vec3 position;
    int noise_relative_to_modifier;
    vec3 radius;
    int displacement_mode;
    float noise_value_base;
    int noise_value_absolute;
};

struct VertexModifierTwistParams
{
    mat4 transform_world_to_local;
    mat4 transform_local_to_world;
    mat4 transform_local;
    mat4 transform_local_inv;
    mat4 transform_parent;
    mat4 transform_parent_inv;
    vec3 axis;
    float angle;
    vec3 position;
    int blend_mode;
    vec3 radius;
    int falloff_curve_idx;
    int falloff_inverse;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    vec3 vCameraPosition;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct VertexModifierUVParams_1
{
    mat4 transform;
    uint override;
    int override_mode;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct _1508
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer VTXCoords
{
    float coords[];
} vtx_coords;

layout(set = 0, binding = 2, std430) buffer VTXNormals
{
    float normals[];
} vtx_normals;

layout(set = 0, binding = 3, std430) buffer VTXAlbedo
{
    float albedo[];
} vtx_albedo;

layout(set = 0, binding = 4, std430) buffer VTXUV0
{
    float uv0[];
} vtx_uv0;

layout(set = 0, binding = 7, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _752;

layout(set = 0, binding = 8, std140) uniform GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _1286;

layout(set = 0, binding = 9, std140) uniform VM0
{
    layout(row_major) VertexModifierUVParams_1 VM0_params;
} _1332;

layout(set = 0, binding = 10, std140) uniform VM1
{
    layout(row_major) VertexModifierNoiseParams VM1_params;
} _1351;

layout(set = 0, binding = 11, std140) uniform VM2
{
    layout(row_major) VertexModifierTwistParams VM2_params;
} _1364;

layout(set = 0, binding = 12, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1377;

layout(set = 0, binding = 5, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1388;

layout(set = 0, binding = 6, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1470;

layout(set = 0, binding = 13) uniform sampler2D s_Curves;

layout(location = 0) out uint instanceID;
layout(location = 1) out _1508 vtx_output;

vec3 vtx_coords_load(uint idx)
{
    return vec3(vtx_coords.coords[(idx * 3u) + 0u], vtx_coords.coords[(idx * 3u) + 1u], vtx_coords.coords[(idx * 3u) + 2u]);
}

vec3 vtx_albedo_load(uint idx)
{
    return vec3(vtx_albedo.albedo[(idx * 3u) + 0u], vtx_albedo.albedo[(idx * 3u) + 1u], vtx_albedo.albedo[(idx * 3u) + 2u]);
}

vec3 vtx_normals_load(uint idx)
{
    return vec3(vtx_normals.normals[(idx * 3u) + 0u], vtx_normals.normals[(idx * 3u) + 1u], vtx_normals.normals[(idx * 3u) + 2u]);
}

vec2 vtx_uv0_load(uint idx)
{
    return vec2(vtx_uv0.uv0[(idx * 2u) + 0u], vtx_uv0.uv0[(idx * 2u) + 1u]);
}

void vertex_modifier_uv_apply(VertexModifierUVParams params, inout VertexInput vtx_input)
{
    vec2 uv = vtx_input.uv0;
    if (params.override)
    {
        if (params.override_mode == 0)
        {
            uv = vtx_input.pos.xy;
        }
        if (params.override_mode == 1)
        {
            uv = vtx_input.pos.yz;
        }
        if (params.override_mode == 2)
        {
            uv = vtx_input.pos.xz;
        }
        if (params.override_mode == 3)
        {
            uv.x = length(vtx_input.pos);
            uv.y = 0.0;
        }
    }
    uv = (params.transform * vec4(uv, 0.0, 1.0)).xy;
    vtx_input.uv0 = uv;
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise_grad(vec3 v, inout vec3 gradient)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.60000002384185791015625) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    vec4 m2 = m * m;
    vec4 m4 = m2 * m2;
    vec4 pdotx = vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3));
    vec4 temp = (m2 * m) * pdotx;
    gradient = ((((x0 * temp.x) + (x1 * temp.y)) + (x2 * temp.z)) + (x3 * temp.w)) * (-8.0);
    gradient += ((((p0 * m4.x) + (p1 * m4.y)) + (p2 * m4.z)) + (p3 * m4.w));
    gradient *= 42.0;
    return 42.0 * dot(m4, pdotx);
}

void vertex_modifier_noise_apply(VertexModifierNoiseParams params, inout VertexInput vtx_input)
{
    vec3 modifier_position = vec3(0.0);
    vec3 base_pos = vtx_input.pos;
    vec3 param = vtx_input.pos;
    mat4 param_1 = (params.transform_parent_inv * params.transform_local_inv) * _752.transform_params.mModel;
    vec3 influence_pos = vector_transform_by_mat43(param, param_1);
    vec3 noise_pos = influence_pos;
    if (params.noise_relative_to_modifier == 0)
    {
        vec3 param_2 = noise_pos;
        mat4 param_3 = params.transform_local;
        noise_pos = vector_transform_by_mat43(param_2, param_3);
    }
    vec3 rel_coords = base_pos;
    vec3 influence_rel_coords = influence_pos;
    float influence = length((influence_rel_coords - modifier_position) / params.radius);
    if (influence <= 1.0)
    {
        if (params.falloff_inverse == 0)
        {
            influence = 1.0 - influence;
        }
        int param_4 = params.falloff_curve_idx;
        float param_5 = influence;
        influence = clamp(curve_sample(param_4, param_5), 0.0, 1.0);
        vec3 ni = noise_pos * params.noise_scale;
        vec3 n1_grad = vec3(0.0);
        vec3 n2_grad = vec3(0.0);
        vec3 param_6 = (ni + (params.noise_phase.xyz * 0.100000001490116119384765625)) + vec3(params.noise_phase.w * 0.01229999959468841552734375);
        vec3 param_7;
        float _834 = snoise_grad(param_6, param_7);
        n1_grad = param_7;
        float n1 = _834;
        vec3 param_8 = ((ni * 0.5) + (params.noise_phase.xyz * 0.100000001490116119384765625)) + vec3(params.noise_phase.w * 0.02170000039041042327880859375);
        vec3 param_9;
        float _852 = snoise_grad(param_8, param_9);
        n2_grad = param_9;
        float n2 = _852;
        n1_grad *= params.noise_scale;
        n2_grad *= (params.noise_scale * 0.5);
        n2 *= 0.5;
        n2_grad *= 0.5;
        float d = 1.0;
        float n = (params.noise_value_base + n1) + n2;
        float n_dx = (((params.noise_value_base + n1) + (n1_grad.x * d)) + n2) + (n2_grad.x * d);
        float n_dy = (((params.noise_value_base + n1) + (n1_grad.y * d)) + n2) + (n2_grad.y * d);
        float n_dz = (((params.noise_value_base + n1) + (n1_grad.z * d)) + n2) + (n2_grad.z * d);
        if (params.noise_value_absolute != 0)
        {
            n = abs(n);
            n_dx = abs(n_dx);
            n_dy = abs(n_dy);
            n_dz = abs(n_dz);
        }
        vec3 scale = params.scale;
        vec3 local_norm = vtx_input.norm;
        if (params.displacement_mode == 1)
        {
            vec3 param_10 = modifier_position;
            mat4 param_11 = params.transform_local;
            local_norm = normalize(base_pos - vector_transform_by_mat43(param_10, param_11));
        }
        vec3 new_pos = base_pos + ((local_norm * n) * scale);
        vec3 new_pos_dx = (base_pos + vec3(d, 0.0, 0.0)) + ((local_norm * n_dx) * scale);
        vec3 new_pos_dy = (base_pos + vec3(0.0, d, 0.0)) + ((local_norm * n_dy) * scale);
        vec3 new_pos_dz = (base_pos + vec3(0.0, 0.0, d)) + ((local_norm * n_dz) * scale);
        new_pos = mix(base_pos, new_pos, vec3(influence));
        new_pos_dx = mix(base_pos + vec3(d, 0.0, 0.0), new_pos_dx, vec3(influence));
        new_pos_dy = mix(base_pos + vec3(0.0, d, 0.0), new_pos_dy, vec3(influence));
        new_pos_dz = mix(base_pos + vec3(0.0, 0.0, d), new_pos_dz, vec3(influence));
        vec3 dx = new_pos_dx - new_pos;
        vec3 dy = new_pos_dy - new_pos;
        vec3 dz = new_pos_dz - new_pos;
        vec3 new_norm = vec3(1.0);
        bool _1053 = abs(vtx_input.norm.x) >= abs(vtx_input.norm.y);
        bool _1063;
        if (_1053)
        {
            _1063 = abs(vtx_input.norm.x) >= abs(vtx_input.norm.z);
        }
        else
        {
            _1063 = _1053;
        }
        if (_1063)
        {
            dy = normalize(dy);
            dz = normalize(dz);
            dx = cross(dy, dz);
        }
        else
        {
            bool _1080 = abs(vtx_input.norm.y) >= abs(vtx_input.norm.x);
            bool _1090;
            if (_1080)
            {
                _1090 = abs(vtx_input.norm.y) >= abs(vtx_input.norm.z);
            }
            else
            {
                _1090 = _1080;
            }
            if (_1090)
            {
                dx = normalize(dx);
                dz = normalize(dz);
                dy = cross(dz, dx);
            }
            else
            {
                dx = normalize(dx);
                dy = normalize(dy);
                dz = cross(dx, dy);
            }
        }
        new_norm = mat3(vec3(dx), vec3(dy), vec3(dz)) * vtx_input.norm;
        vtx_input.pos = new_pos;
        vtx_input.norm = normalize(new_norm);
    }
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

vec4 quaternion_from_axis_angle(vec3 axis, float angle_in_radians)
{
    vec4 v = vec4((-axis) * sin(angle_in_radians * 0.5), cos(angle_in_radians * 0.5));
    return v;
}

vec3 vector_rotate_by_quaternion(vec3 v, vec4 q)
{
    vec3 u = q.xyz;
    float s = q.w;
    return ((u * (2.0 * dot(u, v))) + (v * ((s * s) - dot(u, u)))) + (cross(u, v) * (2.0 * s));
}

void vertex_modifier_twist_apply(VertexModifierTwistParams params, inout VertexInput vtx_input)
{
    vec3 modifier_position = vec3(0.0);
    vec3 base_pos = vtx_input.pos;
    vec3 param = vtx_input.pos;
    mat4 param_1 = (params.transform_parent_inv * params.transform_local_inv) * _752.transform_params.mModel;
    vec3 influence_pos = vector_transform_by_mat43(param, param_1);
    vec3 noise_pos = influence_pos;
    vec3 param_2 = noise_pos;
    mat4 param_3 = params.transform_local;
    noise_pos = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = base_pos;
    vec3 influence_rel_coords = influence_pos;
    float influence = length((influence_rel_coords - modifier_position) / params.radius);
    if (influence <= 1.0)
    {
        if (params.falloff_inverse == 0)
        {
            influence = 1.0 - influence;
        }
        int param_4 = params.falloff_curve_idx;
        float param_5 = influence;
        influence = curve_sample(param_4, param_5);
        vec3 axis = params.axis;
        vec3 param_6 = axis;
        mat4 param_7 = (params.transform_parent_inv * params.transform_local_inv) * _752.transform_params.mModel;
        axis = vector_transform_by_mat33(param_6, param_7);
        axis = normalize(axis);
        float t = dot(influence_rel_coords - modifier_position, axis);
        float angle = params.angle * t;
        if (params.blend_mode == 0)
        {
            angle *= influence;
        }
        vec3 local_coords = (vtx_input.pos - modifier_position) - (axis * t);
        vec3 param_8 = axis;
        float param_9 = angle;
        vec3 param_10 = local_coords;
        vec4 param_11 = quaternion_from_axis_angle(param_8, param_9);
        vec3 new_pos = (modifier_position + (axis * t)) + vector_rotate_by_quaternion(param_10, param_11);
        if (params.blend_mode == 0)
        {
            vtx_input.pos = new_pos;
        }
        else
        {
            vtx_input.pos = mix(vtx_input.pos, new_pos, vec3(influence));
        }
    }
}

void main()
{
    uint param = uint(gl_VertexIndex);
    VertexInput vtx_input;
    vtx_input.pos = vtx_coords_load(param);
    vtx_input.norm = vec3(1.0, 0.0, 0.0);
    vtx_input.color = vec4(1.0);
    vtx_input.uv0 = vtx_input.pos.xy;
    if ((_1286.geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = uint(gl_VertexIndex);
        vtx_input.color = vec4(vtx_albedo_load(param_1), 1.0);
    }
    if ((_1286.geometry_information.builtin_attribute_mask & 2u) != 0u)
    {
        uint param_2 = uint(gl_VertexIndex);
        vtx_input.norm = vtx_normals_load(param_2);
    }
    if ((_1286.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_3 = uint(gl_VertexIndex);
        vtx_input.uv0 = vtx_uv0_load(param_3);
    }
    VertexInput vtx_modifier_input_base = vtx_input;
    VertexModifierUVParams param_4;
    param_4.transform = _1332.VM0_params.transform;
    param_4.override = _1332.VM0_params.override != 0u;
    param_4.override_mode = _1332.VM0_params.override_mode;
    VertexInput param_5 = vtx_input;
    vertex_modifier_uv_apply(param_4, param_5);
    vtx_input = param_5;
    VertexModifierNoiseParams _1356;
    _1356.transform_world_to_local = _1351.VM1_params.transform_world_to_local;
    _1356.transform_local_to_world = _1351.VM1_params.transform_local_to_world;
    _1356.transform_local = _1351.VM1_params.transform_local;
    _1356.transform_local_inv = _1351.VM1_params.transform_local_inv;
    _1356.transform_parent = _1351.VM1_params.transform_parent;
    _1356.transform_parent_inv = _1351.VM1_params.transform_parent_inv;
    _1356.noise_phase = _1351.VM1_params.noise_phase;
    _1356.noise_scale = _1351.VM1_params.noise_scale;
    _1356.falloff_curve_idx = _1351.VM1_params.falloff_curve_idx;
    _1356.scale = _1351.VM1_params.scale;
    _1356.falloff_inverse = _1351.VM1_params.falloff_inverse;
    _1356.position = _1351.VM1_params.position;
    _1356.noise_relative_to_modifier = _1351.VM1_params.noise_relative_to_modifier;
    _1356.radius = _1351.VM1_params.radius;
    _1356.displacement_mode = _1351.VM1_params.displacement_mode;
    _1356.noise_value_base = _1351.VM1_params.noise_value_base;
    _1356.noise_value_absolute = _1351.VM1_params.noise_value_absolute;
    VertexModifierNoiseParams param_6 = _1356;
    VertexInput param_7 = vtx_input;
    vertex_modifier_noise_apply(param_6, param_7);
    vtx_input = param_7;
    VertexModifierTwistParams _1369;
    _1369.transform_world_to_local = _1364.VM2_params.transform_world_to_local;
    _1369.transform_local_to_world = _1364.VM2_params.transform_local_to_world;
    _1369.transform_local = _1364.VM2_params.transform_local;
    _1369.transform_local_inv = _1364.VM2_params.transform_local_inv;
    _1369.transform_parent = _1364.VM2_params.transform_parent;
    _1369.transform_parent_inv = _1364.VM2_params.transform_parent_inv;
    _1369.axis = _1364.VM2_params.axis;
    _1369.angle = _1364.VM2_params.angle;
    _1369.position = _1364.VM2_params.position;
    _1369.blend_mode = _1364.VM2_params.blend_mode;
    _1369.radius = _1364.VM2_params.radius;
    _1369.falloff_curve_idx = _1364.VM2_params.falloff_curve_idx;
    _1369.falloff_inverse = _1364.VM2_params.falloff_inverse;
    VertexModifierTwistParams param_8 = _1369;
    VertexInput param_9 = vtx_input;
    vertex_modifier_twist_apply(param_8, param_9);
    vtx_input = param_9;
    if (_1377.instance_params.stride > 0)
    {
        vec4 inst_m0 = _1388.instance_transform[(gl_InstanceIndex * _1377.instance_params.stride) + 0];
        vec4 inst_m1 = _1388.instance_transform[(gl_InstanceIndex * _1377.instance_params.stride) + 1];
        vec4 inst_m2 = _1388.instance_transform[(gl_InstanceIndex * _1377.instance_params.stride) + 2];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0, v);
        vtx_input.pos.y = dot(inst_m1, v);
        vtx_input.pos.z = dot(inst_m2, v);
        vec3 param_10 = vtx_input.norm;
        mat4 param_11 = transpose(mat4(vec4(inst_m0), vec4(inst_m1), vec4(inst_m2), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_10, param_11));
        vec2 _1477 = unpackHalf2x16(_1470.instance_color[(gl_InstanceIndex * 2) + 0]);
        vec4 inst_c;
        inst_c.x = _1477.x;
        inst_c.y = _1477.y;
        vec2 _1487 = unpackHalf2x16(_1470.instance_color[(gl_InstanceIndex * 2) + 1]);
        inst_c.z = _1487.x;
        inst_c.w = _1487.y;
        vec4 _1493 = vtx_input.color;
        vec3 _1497 = _1493.xyz * inst_c.xyz;
        vtx_input.color.x = _1497.x;
        vtx_input.color.y = _1497.y;
        vtx_input.color.z = _1497.z;
    }
    instanceID = uint(gl_InstanceIndex);
    vtx_output.vLocalPos = vtx_input.pos;
    vec3 param_12 = vtx_input.pos;
    mat4 param_13 = _752.transform_params.mModel;
    vec3 vPosModel = vector_transform_by_mat43(param_12, param_13);
    vec3 param_14 = vtx_input.norm;
    mat4 param_15 = _752.transform_params.mModelNormal;
    vtx_output.vWorldNorm = vec3(vector_transform_by_mat33(param_14, param_15));
    vec3 param_16 = vPosModel;
    mat4 param_17 = _752.transform_params.mView;
    vec3 vPosModelView = vector_transform_by_mat43(param_16, param_17);
    vtx_output.vCoords = vPosModelView;
    vtx_output.vWorldPos = vPosModel;
    vtx_output.vWorldNorm = normalize(vtx_output.vWorldNorm);
    vtx_output.vNorm.x = dot(_752.transform_params.mModelViewInvTrans[0].xyz, vtx_input.norm);
    vtx_output.vNorm.y = dot(_752.transform_params.mModelViewInvTrans[1].xyz, vtx_input.norm);
    vtx_output.vNorm.z = dot(_752.transform_params.mModelViewInvTrans[2].xyz, vtx_input.norm);
    vtx_output.vNorm = vec3(normalize(vtx_output.vNorm));
    vtx_output.vNorm = vec3(vtx_input.norm);
    vtx_output.vColor = vec4(vtx_input.color);
    vtx_output.vUV0 = vec2(vtx_input.uv0);
    gl_Position = _752.transform_params.mProjection * vec4(vtx_output.vCoords, 1.0);
}

 