#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct TextureResourceParams
{
    int flip_y;
    int clamp_range_01;
    float remap_range_start;
    float remap_range_end;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct InstancingGeneratorParams
{
    int _buffer_capacity;
    int scale_sampling_mode;
    int rotation_sampling_mode;
    int color_sampling_mode;
    int displacement_sampling_mode;
    int plane;
    int grid_pattern;
    int rotation_align_to_surface;
    vec2 dimmensions;
    uvec2 replicas;
    vec3 instance_scale_base;
    int _pad2;
    vec3 instance_scale_factor;
    int _pad3;
    vec3 instance_displacement_factor;
    int _pad4;
    vec3 instance_rotation_base;
    int _pad5;
    vec3 instance_rotation_factor;
    int _pad6;
    float instance_color_factor;
    int _pad7;
    int _pad8;
    int _pad9;
    TextureResourceParams instance_color_txt_params;
    TextureResourceParams instance_scale_txt_params;
    TextureResourceParams instance_displacement_txt_params;
    TextureResourceParams instance_rotation_txt_params;
    TextureResourceParams instance_mask_txt_params;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct link_list_node
{
    uint value;
    uint next;
};

layout(set = 0, binding = 1, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _202;

layout(set = 0, binding = 5, std140) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _220;

layout(set = 0, binding = 2, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _729;

layout(set = 0, binding = 3, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _778;

layout(set = 0, binding = 4, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _798;

layout(set = 0, binding = 6) uniform sampler2D sColorImage;
layout(set = 0, binding = 7) uniform sampler2D sScaleImage;
layout(set = 0, binding = 8) uniform sampler2D sRotationImage;
layout(set = 0, binding = 9) uniform sampler2D sDisplacementImage;
layout(set = 0, binding = 10) uniform sampler2D sMaskImage;

vec4 texture_sample_lod_with_params(sampler2D smp, inout vec2 uv, float lod, TextureResourceParams params)
{
    if (params.flip_y != 0)
    {
        uv.y = 1.0 - uv.y;
    }
    vec4 v = textureLod(smp, uv, lod);
    v = (v - vec4(params.remap_range_start)) / vec4(params.remap_range_end - params.remap_range_start);
    if (params.clamp_range_01 != 0)
    {
        v = clamp(v, vec4(0.0), vec4(1.0));
    }
    return v;
}

vec3 texture_remap_with_params(inout vec3 v, TextureResourceParams params)
{
    v = (v - vec3(params.remap_range_start)) / vec3(params.remap_range_end - params.remap_range_start);
    if (params.clamp_range_01 != 0)
    {
        v = clamp(v, vec3(0.0), vec3(1.0));
    }
    return v;
}

vec3 textureLodAvg(sampler2D s, inout vec2 p, float lod, TextureResourceParams params)
{
    if (params.flip_y != 0)
    {
        p.y = 1.0 - p.y;
    }
    vec2 ts = vec2(1.5) / vec2(textureSize(s, 0));
    vec3 v = (((textureLod(s, p, lod).xyz + textureLod(s, p + vec2(ts.x, 0.0), lod).xyz) + textureLod(s, p + vec2(-ts.x, 0.0), lod).xyz) + textureLod(s, p + vec2(0.0, ts.y), lod).xyz) + textureLod(s, p + vec2(0.0, -ts.y), lod).xyz;
    v *= 0.20000000298023223876953125;
    vec3 param = v;
    TextureResourceParams param_1 = params;
    vec3 _186 = texture_remap_with_params(param, param_1);
    v = _186;
    return v;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    if (id >= uint(_202.instance_params.buffer_capacity))
    {
        return;
    }
    vec3 instance_position = vec3(0.0);
    uvec2 instance_id;
    instance_id.x = id % _220.instancing_generator_params.replicas.x;
    instance_id.y = id / _220.instancing_generator_params.replicas.x;
    if (_220.instancing_generator_params.grid_pattern == 0)
    {
        instance_position.x = float(instance_id.x) / float(_220.instancing_generator_params.replicas.x);
        instance_position.y = float(instance_id.y) / float(_220.instancing_generator_params.replicas.y);
    }
    if (_220.instancing_generator_params.grid_pattern == 1)
    {
        instance_position.x = float(instance_id.x) / float(_220.instancing_generator_params.replicas.x);
        instance_position.y = float(instance_id.y) / float(_220.instancing_generator_params.replicas.y);
        if ((instance_id.y & 1u) == 1u)
        {
            instance_position.x += (0.5 / float(_220.instancing_generator_params.replicas.x));
        }
    }
    vec2 sampling_position = instance_position.xy;
    vec3 _294 = instance_position;
    vec2 _302 = (_294.xy - vec2(0.5)) * _220.instancing_generator_params.dimmensions;
    instance_position.x = _302.x;
    instance_position.y = _302.y;
    if (_220.instancing_generator_params.plane == 0)
    {
        instance_position = vec3(0.0, instance_position.xy);
    }
    if (_220.instancing_generator_params.plane == 1)
    {
        instance_position = vec3(instance_position.x, 0.0, instance_position.y);
    }
    if (_220.instancing_generator_params.plane == 2)
    {
        instance_position = vec3(instance_position.xy, 0.0);
    }
    sampling_position.y = 1.0 - sampling_position.y;
    vec2 sampling_position2 = sampling_position;
    sampling_position.y = 1.0 - sampling_position.y;
    sampling_position2.y = 1.0030000209808349609375 - sampling_position2.y;
    vec2 param = sampling_position;
    float param_1 = 0.0;
    TextureResourceParams _363;
    _363.flip_y = _220.instancing_generator_params.instance_color_txt_params.flip_y;
    _363.clamp_range_01 = _220.instancing_generator_params.instance_color_txt_params.clamp_range_01;
    _363.remap_range_start = _220.instancing_generator_params.instance_color_txt_params.remap_range_start;
    _363.remap_range_end = _220.instancing_generator_params.instance_color_txt_params.remap_range_end;
    TextureResourceParams param_2 = _363;
    vec4 _364 = texture_sample_lod_with_params(sColorImage, param, param_1, param_2);
    vec3 sampled_color = _364.xyz;
    vec2 param_3 = sampling_position;
    float param_4 = 0.0;
    TextureResourceParams _375;
    _375.flip_y = _220.instancing_generator_params.instance_scale_txt_params.flip_y;
    _375.clamp_range_01 = _220.instancing_generator_params.instance_scale_txt_params.clamp_range_01;
    _375.remap_range_start = _220.instancing_generator_params.instance_scale_txt_params.remap_range_start;
    _375.remap_range_end = _220.instancing_generator_params.instance_scale_txt_params.remap_range_end;
    TextureResourceParams param_5 = _375;
    vec4 _376 = texture_sample_lod_with_params(sScaleImage, param_3, param_4, param_5);
    vec3 sampled_scale = _376.xyz;
    vec2 param_6 = sampling_position;
    float param_7 = 0.0;
    TextureResourceParams _387;
    _387.flip_y = _220.instancing_generator_params.instance_rotation_txt_params.flip_y;
    _387.clamp_range_01 = _220.instancing_generator_params.instance_rotation_txt_params.clamp_range_01;
    _387.remap_range_start = _220.instancing_generator_params.instance_rotation_txt_params.remap_range_start;
    _387.remap_range_end = _220.instancing_generator_params.instance_rotation_txt_params.remap_range_end;
    TextureResourceParams param_8 = _387;
    vec3 _388 = textureLodAvg(sRotationImage, param_6, param_7, param_8);
    vec3 sampled_rotation = _388;
    vec2 param_9 = sampling_position2;
    float param_10 = 0.0;
    TextureResourceParams _398;
    _398.flip_y = _220.instancing_generator_params.instance_displacement_txt_params.flip_y;
    _398.clamp_range_01 = _220.instancing_generator_params.instance_displacement_txt_params.clamp_range_01;
    _398.remap_range_start = _220.instancing_generator_params.instance_displacement_txt_params.remap_range_start;
    _398.remap_range_end = _220.instancing_generator_params.instance_displacement_txt_params.remap_range_end;
    TextureResourceParams param_11 = _398;
    vec4 _399 = texture_sample_lod_with_params(sDisplacementImage, param_9, param_10, param_11);
    vec3 sampled_displacement = _399.xyz;
    vec2 param_12 = sampling_position2;
    float param_13 = 0.0;
    TextureResourceParams _410;
    _410.flip_y = _220.instancing_generator_params.instance_mask_txt_params.flip_y;
    _410.clamp_range_01 = _220.instancing_generator_params.instance_mask_txt_params.clamp_range_01;
    _410.remap_range_start = _220.instancing_generator_params.instance_mask_txt_params.remap_range_start;
    _410.remap_range_end = _220.instancing_generator_params.instance_mask_txt_params.remap_range_end;
    TextureResourceParams param_14 = _410;
    vec3 _411 = textureLodAvg(sMaskImage, param_12, param_13, param_14);
    float sampled_mask = _411.x;
    if (sampled_mask <= 9.9999997473787516355514526367188e-05)
    {
        return;
    }
    sampled_displacement *= sampled_mask;
    sampled_scale *= sampled_mask;
    if (_220.instancing_generator_params.color_sampling_mode == 0)
    {
        sampled_color = vec3(dot(sampled_color, vec3(0.33329999446868896484375)));
    }
    if (_220.instancing_generator_params.scale_sampling_mode == 0)
    {
        sampled_scale = vec3(dot(sampled_scale, vec3(0.33329999446868896484375)));
    }
    if (_220.instancing_generator_params.rotation_sampling_mode == 0)
    {
        sampled_rotation = vec3(dot(sampled_rotation, vec3(0.33329999446868896484375)));
    }
    if (_220.instancing_generator_params.displacement_sampling_mode == 0)
    {
        sampled_displacement = vec3(dot(sampled_displacement, vec3(0.33329999446868896484375)));
    }
    sampled_scale = (sampled_scale * _220.instancing_generator_params.instance_scale_factor) + _220.instancing_generator_params.instance_scale_base;
    sampled_scale = max(vec3(0.0), sampled_scale);
    instance_position += (sampled_displacement * _220.instancing_generator_params.instance_displacement_factor);
    vec3 mx;
    vec3 my;
    vec3 mz;
    if (_220.instancing_generator_params.rotation_align_to_surface != 0)
    {
        ivec2 t_size = textureSize(sRotationImage, 0);
        float gradient_scale = 1.0;
        float d = gradient_scale / float(t_size.x);
        vec2 param_15 = sampling_position + vec2(d, 0.0);
        float param_16 = 0.0;
        TextureResourceParams _507;
        _507.flip_y = _220.instancing_generator_params.instance_rotation_txt_params.flip_y;
        _507.clamp_range_01 = _220.instancing_generator_params.instance_rotation_txt_params.clamp_range_01;
        _507.remap_range_start = _220.instancing_generator_params.instance_rotation_txt_params.remap_range_start;
        _507.remap_range_end = _220.instancing_generator_params.instance_rotation_txt_params.remap_range_end;
        TextureResourceParams param_17 = _507;
        vec3 _508 = textureLodAvg(sRotationImage, param_15, param_16, param_17);
        float v_x = dot(vec3(0.33329999446868896484375), _508);
        vec2 param_18 = sampling_position - vec2(0.0, d);
        float param_19 = 0.0;
        TextureResourceParams _520;
        _520.flip_y = _220.instancing_generator_params.instance_rotation_txt_params.flip_y;
        _520.clamp_range_01 = _220.instancing_generator_params.instance_rotation_txt_params.clamp_range_01;
        _520.remap_range_start = _220.instancing_generator_params.instance_rotation_txt_params.remap_range_start;
        _520.remap_range_end = _220.instancing_generator_params.instance_rotation_txt_params.remap_range_end;
        TextureResourceParams param_20 = _520;
        vec3 _521 = textureLodAvg(sRotationImage, param_18, param_19, param_20);
        float v_y = dot(vec3(0.33329999446868896484375), _521);
        float v = 0.0;
        if (_220.instancing_generator_params.rotation_sampling_mode == 0)
        {
            v = sampled_rotation.x;
        }
        else
        {
            v = dot(sampled_rotation, vec3(0.33329999446868896484375));
        }
        float d2 = d * float(t_size.x);
        vec3 dx = vec3(d, (v - v_x) * d2, 0.0);
        vec3 dy = vec3(0.0, (v - v_y) * d2, d);
        vec3 ndx = normalize(dx);
        vec3 ndy = normalize(dy);
        vec3 ndz = normalize(cross(ndy, ndx));
        mx = ndx;
        my = ndz;
        mz = ndy;
    }
    else
    {
        vec3 angles = (sampled_rotation * _220.instancing_generator_params.instance_rotation_factor) + _220.instancing_generator_params.instance_rotation_base;
        float cosb = cos(angles.z);
        float sinb = sin(angles.z);
        float cosp = cos(angles.x);
        float sinp = sin(angles.x);
        float _cosh = cos(angles.y);
        float _sinh = sin(angles.y);
        mx.x = (_cosh * cosb) + ((_sinh * sinp) * sinb);
        mx.y = ((_sinh * sinp) * cosb) - (_cosh * sinb);
        mx.z = _sinh * cosp;
        my.x = cosp * sinb;
        my.y = cosp * cosb;
        my.z = -sinp;
        mz.x = ((_cosh * sinp) * sinb) - (_sinh * cosb);
        mz.y = (_sinh * sinb) + ((_cosh * sinp) * cosb);
        mz.z = _cosh * cosp;
    }
    mat3 scale_transform;
    scale_transform[0] = vec3(sampled_scale.x, 0.0, 0.0);
    scale_transform[1] = vec3(0.0, sampled_scale.y, 0.0);
    scale_transform[2] = vec3(0.0, 0.0, sampled_scale.z);
    mat3 rotation_transform;
    rotation_transform[0] = vec3(mx.x, my.x, mz.x);
    rotation_transform[1] = vec3(mx.y, my.y, mz.y);
    rotation_transform[2] = vec3(mx.z, my.z, mz.z);
    mat3 transform = rotation_transform * scale_transform;
    transform = transpose(transform);
    int _716 = atomicAdd(_202.instance_params.instance_count, 1);
    uint instance_idx = uint(_716);
    if (instance_idx >= uint(_202.instance_params.buffer_capacity))
    {
        return;
    }
    _729.instance_transform[(instance_idx * 3u) + 0u] = vec4(transform[0], instance_position.x);
    _729.instance_transform[(instance_idx * 3u) + 1u] = vec4(transform[1], instance_position.y);
    _729.instance_transform[(instance_idx * 3u) + 2u] = vec4(transform[2], instance_position.z);
    sampled_color = mix(vec3(1.0), sampled_color, vec3(_220.instancing_generator_params.instance_color_factor));
    _778.instance_color[(instance_idx * 2u) + 0u] = packHalf2x16(sampled_color.xy);
    _778.instance_color[(instance_idx * 2u) + 1u] = packHalf2x16(vec2(sampled_color.z, 1.0));
    _798.instance_hash[instance_idx] = id;
}

 