#version 450
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct DispatchParams
{
    mat4 mat_projection;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
};

struct FromNormalParams
{
    vec2 resolution;
    vec2 inv_resolution;
    int worldspace;
    uint _pad0;
    uint _pad1;
    uint _pad2;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std140) uniform DeferredParams
{
    layout(row_major) DispatchParams dispatch_setup;
} _105;

layout(set = 0, binding = 2, std140) uniform FromNormalParamsBuffer
{
    FromNormalParams from_normal_params;
} _170;

layout(set = 0, binding = 3, r32ui) uniform readonly uimage2D imNormalMaterial;
layout(set = 0, binding = 4, r8) uniform writeonly image2D imTarget;

int decode_material(uint data)
{
    return int(data >> 31u);
}

vec2 unpackSnorm2x15(uint d)
{
    return (vec2(uvec2(d, d >> uint(15)) & uvec2(32767u)) / vec2(16383.5)) - vec2(1.0);
}

vec3 decode_normal(uint data)
{
    uint param = data;
    vec2 v = unpackSnorm2x15(param);
    uint s = data & 1073741824u;
    vec3 n;
    n.x = v.x;
    n.y = v.y;
    n.z = sqrt(clamp(1.0 - dot(n.xy, n.xy), 0.0, 1.0)) * ((s > 0u) ? 1.0 : (-1.0));
    return n;
}

void main()
{
    ivec2 storePos = ivec2(gl_GlobalInvocationID.xy);
    vec2 tex_coord = vec2(storePos) * _105.dispatch_setup.inv_resolution;
    vec3 view_direction;
    view_direction.x = ((-_105.dispatch_setup.camera_projection_params.x) * 0.5) + ((_105.dispatch_setup.camera_projection_params.x * float(storePos.x)) * _105.dispatch_setup.inv_resolution.x);
    view_direction.y = ((-_105.dispatch_setup.camera_projection_params.y) * 0.5) + ((_105.dispatch_setup.camera_projection_params.y * float(storePos.y)) * _105.dispatch_setup.inv_resolution.y);
    view_direction.z = 1.0;
    uint encoded_normal_material = imageLoad(imNormalMaterial, storePos).x;
    uint param = encoded_normal_material;
    int materialId = decode_material(param);
    bool is_background = (materialId & 1) == 1;
    if (_170.from_normal_params.worldspace != 0)
    {
    }
    vec3 output_val = vec3(0.0);
    if (is_background == false)
    {
        uint param_1 = encoded_normal_material;
        vec3 normal = decode_normal(param_1);
        output_val = (normal * 0.5) + vec3(0.5);
    }
    imageStore(imTarget, storePos, vec4(output_val, 0.0));
}

 