#version 450
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct TextureResourceParams
{
    int flip_y;
    int clamp_range_01;
    float remap_range_start;
    float remap_range_end;
};

struct TextureProcessParams
{
    int width;
    int height;
    float width_inv;
    float height_inv;
    int merge_op;
    int output_as_source2;
    float source1_factor;
    float source2_factor;
    float source1_base;
    float source2_base;
    int _pad0;
    int _pad1;
    vec2 source1_image_scale;
    vec2 source2_image_scale;
    TextureResourceParams source1_txt_params;
    TextureResourceParams source2_txt_params;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std140) uniform TextureProcessParamsBuffer
{
    TextureProcessParams texture_process_params;
} _114;

layout(set = 0, binding = 3) uniform sampler2D sSource1;
layout(set = 0, binding = 4) uniform sampler2D sSource2;
layout(set = 0, binding = 2, r16f) uniform image2D imDest;

vec4 texture_sample_lod_with_params(sampler2D smp, inout vec2 uv, float lod, TextureResourceParams params)
{
    if (params.flip_y != 0)
    {
        uv.y = 1.0 - uv.y;
    }
    vec4 v = textureLod(smp, uv, lod);
    v = (v - vec4(params.remap_range_start)) / vec4(params.remap_range_end - params.remap_range_start);
    if (params.clamp_range_01 != 0)
    {
        v = clamp(v, vec4(0.0), vec4(1.0));
    }
    return v;
}

void main()
{
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    uvec2 s1_size = uvec2(textureSize(sSource1, 0));
    uvec2 s2_size = uvec2(textureSize(sSource2, 0));
    vec2 param = (vec2(pixel_pos) / vec2(s1_size)) * _114.texture_process_params.source1_image_scale;
    float param_1 = 0.0;
    TextureResourceParams _127;
    _127.flip_y = _114.texture_process_params.source1_txt_params.flip_y;
    _127.clamp_range_01 = _114.texture_process_params.source1_txt_params.clamp_range_01;
    _127.remap_range_start = _114.texture_process_params.source1_txt_params.remap_range_start;
    _127.remap_range_end = _114.texture_process_params.source1_txt_params.remap_range_end;
    TextureResourceParams param_2 = _127;
    vec4 _128 = texture_sample_lod_with_params(sSource1, param, param_1, param_2);
    vec4 s1 = _128;
    vec2 param_3 = (vec2(pixel_pos) / vec2(s2_size)) * _114.texture_process_params.source2_image_scale;
    float param_4 = 0.0;
    TextureResourceParams _145;
    _145.flip_y = _114.texture_process_params.source2_txt_params.flip_y;
    _145.clamp_range_01 = _114.texture_process_params.source2_txt_params.clamp_range_01;
    _145.remap_range_start = _114.texture_process_params.source2_txt_params.remap_range_start;
    _145.remap_range_end = _114.texture_process_params.source2_txt_params.remap_range_end;
    TextureResourceParams param_5 = _145;
    vec4 _146 = texture_sample_lod_with_params(sSource2, param_3, param_4, param_5);
    vec4 s2 = _146;
    if (_114.texture_process_params.output_as_source2 != 0)
    {
        s2 = imageLoad(imDest, ivec2(pixel_pos));
    }
    s1 = (s1 * _114.texture_process_params.source1_factor) + vec4(_114.texture_process_params.source1_base);
    s2 = (s2 * _114.texture_process_params.source2_factor) + vec4(_114.texture_process_params.source2_base);
    vec4 d = vec4(0.0);
    if (_114.texture_process_params.merge_op == 0)
    {
        d = s1;
    }
    else
    {
        if (_114.texture_process_params.merge_op == 1)
        {
            d = s1 + s2;
        }
        else
        {
            if (_114.texture_process_params.merge_op == 2)
            {
                d = s1 * s2;
            }
        }
    }
    bool _211 = isnan(d.x);
    bool _218;
    if (!_211)
    {
        _218 = isnan(d.y);
    }
    else
    {
        _218 = _211;
    }
    bool _226;
    if (!_218)
    {
        _226 = isnan(d.z);
    }
    else
    {
        _226 = _218;
    }
    bool _233;
    if (!_226)
    {
        _233 = isnan(d.z);
    }
    else
    {
        _233 = _226;
    }
    if (_233)
    {
        d = vec4(0.0);
    }
    bool _238 = isinf(d.x);
    bool _245;
    if (!_238)
    {
        _245 = isinf(d.y);
    }
    else
    {
        _245 = _238;
    }
    bool _252;
    if (!_245)
    {
        _252 = isinf(d.z);
    }
    else
    {
        _252 = _245;
    }
    bool _259;
    if (!_252)
    {
        _259 = isinf(d.z);
    }
    else
    {
        _259 = _252;
    }
    if (_259)
    {
        d = vec4(0.0);
    }
    imageStore(imDest, ivec2(pixel_pos), d);
}

 