#version 450
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct TextureProcessParams
{
    int width;
    int height;
    float width_inv;
    float height_inv;
    float param1;
    float param2;
    float param3;
    float param4;
    vec4 param_color;
};

layout(set = 0, binding = 1, std140) uniform TextureProcessParamsBuffer
{
    TextureProcessParams texture_process_params;
} _72;

layout(set = 0, binding = 3) uniform sampler2D sSource;
layout(set = 0, binding = 2, rgba8) uniform writeonly image2D imDest;

void main()
{
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    vec3 c = texelFetch(sSource, ivec2(pixel_pos), 0).xyz;
    float a = ((c.x * 0.60000002384185791015625) + (c.y * 0.25)) + (c.z * 0.1500000059604644775390625);
    a = clamp(a, 0.0, 1.0);
    a = (((a - 0.5) * _72.texture_process_params.param2) * 0.100000001490116119384765625) + 0.5;
    a += (_72.texture_process_params.param1 * 0.00999999977648258209228515625);
    a = clamp(a, 0.0, 1.0);
    imageStore(imDest, ivec2(pixel_pos), vec4(a));
}

 