#version 450

struct TexGenCustomParams
{
    vec2 resolution;
    vec2 resolutionInv;
    float param1;
    float param2;
    float _pad0;
    float _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform TexGenCustomParamsBuffer
{
    TexGenCustomParams params;
} _95;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _68 = hash(param);
    uint param_1 = _68;
    float _70 = floatConstruct(param_1);
    return _70;
}

void main()
{
    vec4 base_color = vec4(1.0, 0.0, 0.5, 1.0);
    float x = vTexcoord0.x;
    float x_skewed = x + (((vTexcoord0.y * _95.params.param2) / 50.0) - 0.5);
    float stripe_idx = floor(vTexcoord0.y * 16.0);
    float param = stripe_idx * 0.00999999977648258209228515625;
    float stripe_skew = random(param);
    float f = (((x_skewed + (stripe_skew * 0.20000000298023223876953125)) * x) + (_95.params.param1 / 25.0)) - 1.0;
    f = clamp(f, 0.0, 1.0);
    f = 1.0 - f;
    vec3 _140 = vec3(f);
    base_color.x = _140.x;
    base_color.y = _140.y;
    base_color.z = _140.z;
    base_color.w = f;
    outColor = base_color;
}

 