#version 450

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    vec3 vCameraPosition;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct link_list_node
{
    uint value;
    uint next;
};

layout(set = 0, binding = 1, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_voxelize;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 0, binding = 2, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _241;

layout(set = 0, binding = 3) uniform sampler3D s_voxel_occupancy;
layout(set = 0, binding = 4) uniform sampler3D s_voxel_colors_filtered;

layout(location = 0) out uint instanceID;
layout(location = 1) out Vertex
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
} vtx_output;


vec3 get_vertex(uint idx)
{
    uint voxel_idx = uint(gl_InstanceIndex);
    vec3 voxel_p;
    voxel_p.x = float(voxel_idx % 256u);
    voxel_p.y = float((voxel_idx / 256u) % 256u);
    voxel_p.z = float((voxel_idx / 65536u) % 256u);
    vec3 p = vec3((ivec3(10362, 687, 12771) >> ivec3(uvec3(idx))) & ivec3(1));
    float scale = float(texelFetch(s_voxel_occupancy, ivec3(voxel_p), 0).x > 0.0);
    vec3 size = in_bbox_data.grid_size_voxelize.xyz;
    p = ((vec3(voxel_p) * in_bbox_data.grid_size_voxelize.xyz) + in_bbox_data.bbox_voxelize_min.xyz) + ((p * size) * scale);
    return p;
}

vec3 get_vertex_normal(uint idx)
{
    return vec3(1.0, 1.0, 0.0);
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

vec3 color_convert_rgbm_rgb(inout vec4 v)
{
    vec4 _41 = v;
    float _46 = v.w;
    vec3 _49 = (_41.xyz * _46) * 128.0;
    v.x = _49.x;
    v.y = _49.y;
    v.z = _49.z;
    return v.xyz * v.xyz;
}

vec4 get_vertex_color(uint idx)
{
    uint voxel_idx = uint(gl_InstanceIndex);
    vec3 voxel_p;
    voxel_p.x = float(voxel_idx % 256u);
    voxel_p.y = float((voxel_idx / 256u) % 256u);
    voxel_p.z = float((voxel_idx / 65536u) % 256u);
    vec4 param = textureLod(s_voxel_colors_filtered, (voxel_p + vec3(0.5)) / vec3(256.0), 0.0);
    vec3 _197 = color_convert_rgbm_rgb(param);
    vec4 color;
    color.x = _197.x;
    color.y = _197.y;
    color.z = _197.z;
    color.w = 1.0;
    return color + vec4(0.100000001490116119384765625);
}

vec2 get_vertex_uv0(uint idx)
{
    return vec2(0.0);
}

void main()
{
    instanceID = 0u;
    uint param = uint(gl_VertexIndex);
    vec3 pos = get_vertex(param);
    uint param_1 = uint(gl_VertexIndex);
    vec3 norm = get_vertex_normal(param_1);
    vtx_output.vLocalPos = pos;
    vec4 vPos1 = vec4(pos, 1.0);
    vec3 param_2 = pos;
    mat4 param_3 = _241.transform_params.mModelView;
    vec3 vPos = vector_transform_by_mat43(param_2, param_3);
    vec3 param_4 = pos;
    mat4 param_5 = _241.transform_params.mModel;
    vtx_output.vWorldPos = vector_transform_by_mat43(param_4, param_5);
    vtx_output.vWorldNorm = vec3((_241.transform_params.mModel * vec4(norm, 0.0)).xyz);
    vtx_output.vNorm.x = dot(_241.transform_params.mModelViewInvTrans[0].xyz, norm);
    vtx_output.vNorm.y = dot(_241.transform_params.mModelViewInvTrans[1].xyz, norm);
    vtx_output.vNorm.z = dot(_241.transform_params.mModelViewInvTrans[2].xyz, norm);
    vtx_output.vNorm = normalize(vtx_output.vNorm);
    gl_Position = _241.transform_params.mProjection * vec4(vPos, 1.0);
    uint param_6 = uint(gl_VertexIndex);
    vtx_output.vColor = vec4(get_vertex_color(param_6));
    uint param_7 = uint(gl_VertexIndex);
    vtx_output.vUV0 = vec2(get_vertex_uv0(param_7));
}

 