#version 450

struct TexGenCustomParams
{
    vec2 resolution;
    vec2 resolutionInv;
    float param1;
    float param2;
    float _pad0;
    float _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform TexGenCustomParamsBuffer
{
    TexGenCustomParams params;
} _21;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

void main()
{
    vec4 base_color = vec4(1.0, 0.0, 0.5, 1.0);
    float th = _21.params.param1 / 50.0;
    float spread = _21.params.param2 / 100.0;
    float x = vTexcoord0.x + th;
    float v = step(x - 0.5, 0.5);
    float v2 = step(fract(x * 16.0), spread);
    v = v2 + v;
    v = 1.0 - clamp(v, 0.0, 1.0);
    if (x < 0.0)
    {
        v = 0.0;
    }
    if (x > 2.0)
    {
        v = 1.0;
    }
    base_color = vec4(1.0 - v);
    base_color.x = 1.0;
    base_color.y = 1.0;
    base_color.z = 1.0;
    outColor = base_color;
}

 