#version 450

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct LightProperties
{
    vec4 diffuse;
    vec4 direction;
    vec4 position;
    vec4 up;
    vec4 right;
    vec2 dimensions;
    vec2 _pad1;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct InstancedMeshParams
{
    float scale;
    int merged_clones;
    int base_verts_num;
    int materialIndex;
    int lights_num;
};

struct _451
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    vec3 vCameraPosition;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _124;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    vec4 prt_positions[];
} _149;

layout(set = 0, binding = 3, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 0, binding = 4, std140) uniform InstancedMeshParamsBuffer
{
    InstancedMeshParams instanced_mesh_params;
} _412;

layout(set = 0, binding = 5, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _486;

layout(set = 0, binding = 6, std140) uniform LightPropertiesBuffer
{
    layout(row_major) LightProperties light_properties[16];
} lights;

layout(set = 0, binding = 7) uniform sampler2DShadow LightShadowmapCmpSamplers[16];

layout(location = 0) out uint instanceID;
layout(location = 1) out _451 vtx_output;

vec3 prt_get_position(uint id)
{
    return _149.prt_positions[id].xyz;
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(uint id)
{
    vec4 c = vec4(1.0);
    uint param = _124.prt_states[id].color;
    vec3 _165 = color_convert_uint_to_float3(param);
    c.x = _165.x;
    c.y = _165.y;
    c.z = _165.z;
    return c;
}

ParticleState prt_get_state(uint id)
{
    ParticleState _142;
    _142.life_time = _124.prt_states[id].life_time;
    _142.life_span = _124.prt_states[id].life_span;
    _142.generation_id = _124.prt_states[id].generation_id;
    _142.color = _124.prt_states[id].color;
    ParticleState _141 = _142;
    return _141;
}

bool prt_is_alive(uint id)
{
    return _124.prt_states[id].life_time < _124.prt_states[id].life_span;
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

float sampleShadowPCF(sampler2DShadow smpl, inout vec4 coords, out float in_frustum, int samples, float sampling_range)
{
    float fact = 0.0;
    in_frustum = 0.0;
    if (coords.w <= 0.0)
    {
        return 1.0;
    }
    bool _188 = coords.x < (-coords.w);
    bool _197;
    if (!_188)
    {
        _197 = coords.x > coords.w;
    }
    else
    {
        _197 = _188;
    }
    bool _207;
    if (!_197)
    {
        _207 = coords.y < (-coords.w);
    }
    else
    {
        _207 = _197;
    }
    bool _216;
    if (!_207)
    {
        _216 = coords.y > coords.w;
    }
    else
    {
        _216 = _207;
    }
    if (_216)
    {
        return 1.0;
    }
    in_frustum = 1.0;
    vec4 _220 = coords;
    float _226 = coords.w;
    vec2 _228 = (_220.xy * vec2(0.5)) + (vec2(0.5) * _226);
    coords.x = _228.x;
    coords.y = _228.y;
    coords.y /= coords.w;
    coords.y = 1.0 - coords.y;
    coords.y *= coords.w;
    vec3 samp = coords.xyz / vec3(coords.w);
    float sampling_r = 1.0;
    float _259 = -sampling_r;
    float y = _259;
    int iy = 0;
    for (; iy < samples; iy++, y += ((2.0 * sampling_r) / float(samples - 1)))
    {
        float _271 = -sampling_r;
        float x = _271;
        int ix = 0;
        for (; ix < samples; ix++, x += ((2.0 * sampling_r) / float(samples - 1)))
        {
            vec4 _297 = coords + vec4((x * sampling_range) * coords.w, (y * sampling_range) * coords.w, 0.0, 0.0);
            vec4 _300 = _297;
            _300.z = _297.w;
            float shadow = textureProjLod(smpl, vec4(_300.xy, _297.z, _300.z), 0.0);
            fact += shadow;
        }
    }
    float f = fact * (1.0 / float(samples * samples));
    return f;
}

float light_calculate_spot_attenuation(LightProperties light, vec3 pos)
{
    float cutoff = light.cutoff;
    float light_distance = length(light.position.xyz - pos);
    float falloff = dot(light.direction.xyz, (pos - light.position.xyz) / vec3(light_distance));
    float attenuation = 0.0;
    bool _365 = falloff > cutoff;
    bool _372;
    if (_365)
    {
        _372 = light_distance < light.range;
    }
    else
    {
        _372 = _365;
    }
    if (_372)
    {
        attenuation = 1.0 - ((1.0 - falloff) / (1.0 - cutoff));
        attenuation *= (1.0 - clamp(light_distance / light.range, 0.0, 1.0));
        attenuation = pow(attenuation, 2.0);
    }
    return attenuation;
}

void main()
{
    instanceID = uint(gl_InstanceIndex);
    MaterialPropertiesGPU _419;
    _419.diffuse = materials.material_properties[_412.instanced_mesh_params.materialIndex].diffuse;
    _419.transparency = materials.material_properties[_412.instanced_mesh_params.materialIndex].transparency;
    _419.emissive = materials.material_properties[_412.instanced_mesh_params.materialIndex].emissive;
    _419.roughness = materials.material_properties[_412.instanced_mesh_params.materialIndex].roughness;
    _419.triplanar_factor = materials.material_properties[_412.instanced_mesh_params.materialIndex].triplanar_factor;
    _419.refraction = materials.material_properties[_412.instanced_mesh_params.materialIndex].refraction;
    _419.normal_factor = materials.material_properties[_412.instanced_mesh_params.materialIndex].normal_factor;
    _419.emissive_factor = materials.material_properties[_412.instanced_mesh_params.materialIndex].emissive_factor;
    _419.temporal_accumulation_factor = materials.material_properties[_412.instanced_mesh_params.materialIndex].temporal_accumulation_factor;
    _419.shadowmap_bias = materials.material_properties[_412.instanced_mesh_params.materialIndex].shadowmap_bias;
    _419.metalness = materials.material_properties[_412.instanced_mesh_params.materialIndex].metalness;
    _419.albedo_sampler = materials.material_properties[_412.instanced_mesh_params.materialIndex].albedo_sampler;
    _419.emissive_sampler = materials.material_properties[_412.instanced_mesh_params.materialIndex].emissive_sampler;
    _419.normal_sampler = materials.material_properties[_412.instanced_mesh_params.materialIndex].normal_sampler;
    _419.metalic_roughness_sampler = materials.material_properties[_412.instanced_mesh_params.materialIndex].metalic_roughness_sampler;
    _419.flags = materials.material_properties[_412.instanced_mesh_params.materialIndex].flags;
    _419._pad0 = materials.material_properties[_412.instanced_mesh_params.materialIndex]._pad0;
    _419._pad1 = materials.material_properties[_412.instanced_mesh_params.materialIndex]._pad1;
    MaterialPropertiesGPU material = _419;
    int instance_idx = (gl_InstanceIndex * _412.instanced_mesh_params.merged_clones) + (gl_VertexIndex / _412.instanced_mesh_params.base_verts_num);
    int quad_vidx = gl_VertexIndex & 3;
    vec3 quad_coords;
    quad_coords.x = ((quad_vidx == 1) || (quad_vidx == 2)) ? (-0.5) : 0.5;
    quad_coords.y = ((quad_vidx == 0) || (quad_vidx == 1)) ? 0.5 : (-0.5);
    quad_coords.z = 0.0;
    vtx_output.vUV0 = vec2((quad_coords + vec3(0.5)).xy);
    uint param = uint(instance_idx);
    vec3 vInstPosition = prt_get_position(param);
    uint param_1 = uint(instance_idx);
    vec4 vInstColor = prt_get_color(param_1);
    uint param_2 = uint(instance_idx);
    ParticleState vState = prt_get_state(param_2);
    float quad_scale = _412.instanced_mesh_params.scale;
    quad_coords = vec3(dot(quad_coords, _486.transform_params.mModelView[0].xyz), dot(quad_coords, _486.transform_params.mModelView[1].xyz), dot(quad_coords, _486.transform_params.mModelView[2].xyz));
    vInstPosition += (quad_coords * quad_scale);
    vec3 pos = vInstPosition;
    uint param_3 = uint(instance_idx);
    if (!prt_is_alive(param_3))
    {
        pos = vec3(0.0);
    }
    vtx_output.vLocalPos = pos;
    vec3 vPos1 = pos;
    vec3 param_4 = vPos1;
    mat4 param_5 = _486.transform_params.mModelView;
    vec3 vPos = vector_transform_by_mat43(param_4, param_5);
    vec3 param_6 = vPos1;
    mat4 param_7 = _486.transform_params.mModel;
    vtx_output.vWorldPos = vector_transform_by_mat43(param_6, param_7);
    vtx_output.vNorm = vec3(0.0, 0.0, 1.0);
    vtx_output.vWorldNorm = vec3(0.0, 0.0, 1.0);
    gl_Position = _486.transform_params.mProjection * vec4(vPos, 1.0);
    vec3 light_color = vec3(0.0);
    float param_9;
    for (int light_idx = 0; light_idx < _412.instanced_mesh_params.lights_num; light_idx++)
    {
        LightProperties _580;
        _580.diffuse = lights.light_properties[light_idx].diffuse;
        _580.direction = lights.light_properties[light_idx].direction;
        _580.position = lights.light_properties[light_idx].position;
        _580.up = lights.light_properties[light_idx].up;
        _580.right = lights.light_properties[light_idx].right;
        _580.dimensions = lights.light_properties[light_idx].dimensions;
        _580._pad1 = lights.light_properties[light_idx]._pad1;
        _580.intensity = lights.light_properties[light_idx].intensity;
        _580.range = lights.light_properties[light_idx].range;
        _580.cutoff = lights.light_properties[light_idx].cutoff;
        _580.roughness_modifier = lights.light_properties[light_idx].roughness_modifier;
        _580.is_area = lights.light_properties[light_idx].is_area;
        _580.type = lights.light_properties[light_idx].type;
        _580.projector_sampler = lights.light_properties[light_idx].projector_sampler;
        _580.projector_intensity = lights.light_properties[light_idx].projector_intensity;
        _580.shadowmap_sampler0 = lights.light_properties[light_idx].shadowmap_sampler0;
        _580.shadowmap_sampler1 = lights.light_properties[light_idx].shadowmap_sampler1;
        _580.shadowmap_sampler2 = lights.light_properties[light_idx].shadowmap_sampler2;
        _580.shadowmap_sampler3 = lights.light_properties[light_idx].shadowmap_sampler3;
        _580.cascade_distance0 = lights.light_properties[light_idx].cascade_distance0;
        _580.cascade_distance1 = lights.light_properties[light_idx].cascade_distance1;
        _580.cascade_distance2 = lights.light_properties[light_idx].cascade_distance2;
        _580.cascade_distance3 = lights.light_properties[light_idx].cascade_distance3;
        _580.mat_shadow_mv = lights.light_properties[light_idx].mat_shadow_mv;
        _580.mat_shadow_p[0] = lights.light_properties[light_idx].mat_shadow_p[0];
        _580.mat_shadow_p[1] = lights.light_properties[light_idx].mat_shadow_p[1];
        _580.mat_shadow_p[2] = lights.light_properties[light_idx].mat_shadow_p[2];
        _580.mat_shadow_p[3] = lights.light_properties[light_idx].mat_shadow_p[3];
        _580.mat_shadow_mvp[0] = lights.light_properties[light_idx].mat_shadow_mvp[0];
        _580.mat_shadow_mvp[1] = lights.light_properties[light_idx].mat_shadow_mvp[1];
        _580.mat_shadow_mvp[2] = lights.light_properties[light_idx].mat_shadow_mvp[2];
        _580.mat_shadow_mvp[3] = lights.light_properties[light_idx].mat_shadow_mvp[3];
        LightProperties light = _580;
        vec4 projector_color = vec4(0.0);
        vec3 world = vtx_output.vWorldPos;
        float shadow = 0.0;
        bool calculate_shadows = (light.type & 8) != 0;
        if (((light.type & 3) != 0) && calculate_shadows)
        {
            float penumbra_scaling_factor = 0.5;
            vec4 vShadowCoords = light.mat_shadow_mvp[0] * vec4(world, 1.0);
            float in_frustum = 0.0;
            vec4 param_8 = vShadowCoords;
            int param_10 = 3;
            float param_11 = 9.9999997473787516355514526367188e-05;
            float _627 = sampleShadowPCF(LightShadowmapCmpSamplers[light.shadowmap_sampler0], param_8, param_9, param_10, param_11);
            in_frustum = param_9;
            shadow = _627;
        }
        shadow = 1.0 - shadow;
        if ((light.type & 130) == 130)
        {
            LightProperties param_12 = light;
            vec3 param_13 = world;
            float attenuation = light_calculate_spot_attenuation(param_12, param_13);
            shadow *= attenuation;
        }
        light_color += ((light.diffuse.xyz * sqrt(light.intensity)) * shadow);
    }
    vec4 _662 = vInstColor;
    vec3 _664 = _662.xyz * light_color;
    vInstColor.x = _664.x;
    vInstColor.y = _664.y;
    vInstColor.z = _664.z;
    vec4 _673 = vInstColor;
    vec3 _675 = _673.xyz * material.diffuse;
    vInstColor.x = _675.x;
    vInstColor.y = _675.y;
    vInstColor.z = _675.z;
    vec4 _687 = vInstColor;
    vec3 _689 = _687.xyz + (material.emissive * material.emissive_factor);
    vInstColor.x = _689.x;
    vInstColor.y = _689.y;
    vInstColor.z = _689.z;
    float life_time_factor = min(1.0, vState.life_time / vState.life_span);
    life_time_factor = 1.0 - sin((life_time_factor * 3.1415927410125732421875) * 0.5);
    vec4 _713 = vInstColor;
    vec3 _715 = _713.xyz * (1.0 - pow(life_time_factor, 4.0));
    vInstColor.x = _715.x;
    vInstColor.y = _715.y;
    vInstColor.z = _715.z;
    vtx_output.vCoords = vPos;
    vtx_output.vColor = vec4(vInstColor);
}

 