#version 450
layout(depth_greater) out float gl_FragDepth;

struct RaymarchParams
{
    vec3 function_scale;
    int show_bounding_box;
    vec3 function_origin;
    int clamp_to_volume;
    float param1;
    float param2;
    float param3;
    float param4;
    int use_instance_origin;
    int txt1_flip_y;
    int txt2_flip_y;
    int gradient_idx;
    vec4 near_far_plane;
    int trace_inside;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    vec3 vCameraPosition;
};

struct _969
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 2, std140) uniform RaymarchParamsBuffer
{
    RaymarchParams raymarch_params;
} _261;

layout(set = 1, binding = 3, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 4, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _730;

layout(set = 1, binding = 5, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _753;

layout(set = 1, binding = 1, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _763;

layout(set = 1, binding = 6, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _868;

layout(location = 0) flat in uint instanceID;
layout(location = 1) in _969 vtx_input;
layout(location = 2) out uvec4 outMetalnessRoughnessMeterialTags;
layout(location = 1) out uint outNormalMaterial;
layout(location = 0) out vec4 outAlbedo;

float det(mat2 matrix)
{
    return (matrix[0].x * matrix[1].y) - (matrix[0].y * matrix[1].x);
}

mat3 transpose_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat3 result = mat3(vec3(vec3(row0.x, row1.x, row2.x)), vec3(vec3(row0.y, row1.y, row2.y)), vec3(vec3(row0.z, row1.z, row2.z)));
    return result;
}

mat3 inverse_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat2 param = mat2(vec2(row1.y, row1.z), vec2(row2.y, row2.z));
    mat2 param_1 = mat2(vec2(row1.z, row1.x), vec2(row2.z, row2.x));
    mat2 param_2 = mat2(vec2(row1.x, row1.y), vec2(row2.x, row2.y));
    vec3 minors0 = vec3(det(param), det(param_1), det(param_2));
    mat2 param_3 = mat2(vec2(row2.y, row2.z), vec2(row0.y, row0.z));
    mat2 param_4 = mat2(vec2(row2.z, row2.x), vec2(row0.z, row0.x));
    mat2 param_5 = mat2(vec2(row2.x, row2.y), vec2(row0.x, row0.y));
    vec3 minors1 = vec3(det(param_3), det(param_4), det(param_5));
    mat2 param_6 = mat2(vec2(row0.y, row0.z), vec2(row1.y, row1.z));
    mat2 param_7 = mat2(vec2(row0.z, row0.x), vec2(row1.z, row1.x));
    mat2 param_8 = mat2(vec2(row0.x, row0.y), vec2(row1.x, row1.y));
    vec3 minors2 = vec3(det(param_6), det(param_7), det(param_8));
    mat3 param_9 = mat3(vec3(minors0), vec3(minors1), vec3(minors2));
    mat3 adj = transpose_mat3(param_9);
    return adj * (1.0 / dot(row0, minors0));
}

uvec2 encode_metalness_roughness_material(float metalness, float roughness, uint material)
{
    return uvec2((uint(min(1.0, metalness) * 255.0) << uint(8)) | (uint(min(1.0, roughness) * 255.0) << uint(0)), material);
}

uvec2 encode_component_tags(uint component_tags)
{
    return uvec2(component_tags & 65535u, component_tags >> uint(16));
}

float sdBox(vec3 p, vec3 b)
{
    vec3 q = abs(p) - b;
    return length(max(q, vec3(0.0))) + min(max(q.x, max(q.y, q.z)), 0.0);
}

float raymarchBBox(vec3 ro, vec3 rd, vec3 function_scale)
{
    float h = 0.00200000009499490261077880859375;
    float t = 0.0;
    float res = -1.0;
    for (int i = 0; i < 32; i++)
    {
        if ((h < 0.001000000047497451305389404296875) || (t > 2000.0))
        {
            break;
        }
        vec3 param = ro + (rd * t);
        vec3 param_1 = vec3(1000.0);
        vec3 param_2 = ro + (rd * t);
        vec3 param_3 = (function_scale * 0.5) + vec3(0.00999999977648258209228515625);
        h = max(sdBox(param, param_1), -sdBox(param_2, param_3));
        t += h;
    }
    if (t < 2000.0)
    {
        res = t;
    }
    return res;
}

vec2 DE(vec3 pos)
{
    float Power = 3.0 + (4.0 * (clamp(_261.raymarch_params.param1, -1.2999999523162841796875, 20.0) + 1.0));
    vec3 z = pos;
    float dr = 1.0;
    float r = 0.0;
    for (int i = 0; i < 64; i++)
    {
        r = length(z);
        if (r > 1.5)
        {
            break;
        }
        float theta = acos(z.z / r);
        float phi = atan(z.y, z.x);
        dr = ((pow(r, Power - 1.0) * Power) * dr) + 1.0;
        float zr = pow(r, Power);
        theta = (theta * Power) + _261.raymarch_params.param2;
        phi = (phi * Power) + _261.raymarch_params.param3;
        z = vec3(sin(theta) * cos(phi), sin(phi) * sin(theta), cos(theta)) * zr;
        z += pos;
    }
    return vec2(((0.5 * log(r)) * r) / dr, 50.0 * pow(dr, 0.00200000009499490261077880859375));
}

vec2 map(vec3 p, vec3 dummy)
{
    vec3 param = p;
    vec2 d = DE(param);
    return d;
}

float calcIntersection(vec3 ro, vec3 rd, float max_t, inout vec4 color)
{
    color = vec4(1.0);
    float maxd = max_t;
    float h = 0.00039999998989515006542205810546875;
    float t = 0.0;
    float res = -1.0;
    vec3 orbit_trap;
    for (int i = 0; i < 48; i++)
    {
        if ((h < 0.00019999999494757503271102905273438) || (t > maxd))
        {
            break;
        }
        vec3 param = ro + (rd * t);
        vec3 param_1 = orbit_trap;
        vec2 o = map(param, param_1);
        h = o.x;
        vec3 _414 = vec3(o.y);
        color.x = _414.x;
        color.y = _414.y;
        color.z = _414.z;
        t += h;
    }
    if (t < maxd)
    {
        res = t;
    }
    if (t > max_t)
    {
        return -1.0;
    }
    vec4 _438 = color;
    vec3 _440 = fract(_438.xyz);
    color.x = _440.x;
    color.y = _440.y;
    color.z = _440.z;
    return res;
}

vec3 doModelNormal(vec3 pos)
{
    vec3 param = pos + vec3(0.0089999996125698089599609375, -0.0089999996125698089599609375, -0.0089999996125698089599609375);
    vec3 trash;
    vec3 param_1 = trash;
    vec3 param_2 = pos + vec3(-0.0089999996125698089599609375, -0.0089999996125698089599609375, 0.0089999996125698089599609375);
    vec3 param_3 = trash;
    vec3 param_4 = pos + vec3(-0.0089999996125698089599609375, 0.0089999996125698089599609375, -0.0089999996125698089599609375);
    vec3 param_5 = trash;
    vec3 param_6 = pos + vec3(0.0089999996125698089599609375);
    vec3 param_7 = trash;
    return normalize((((vec3(1.0, -1.0, -1.0) * map(param, param_1).x) + (vec3(-1.0, -1.0, 1.0) * map(param_2, param_3).x)) + (vec3(-1.0, 1.0, -1.0) * map(param_4, param_5).x)) + (vec3(1.0) * map(param_6, param_7).x));
}

uint packSnorm2x15(vec2 v)
{
    uvec2 d = uvec2(round(vec2(16383.5) + (v * 16383.5)));
    return d.x | (d.y << 15u);
}

uint encode_normal_31bit(vec3 n)
{
    vec2 v = n.xy;
    uint s = uint((n.z > 0.0) ? 1073741824 : 0);
    vec2 param = v;
    return s | packSnorm2x15(param);
}

uint encode_normal_material(vec3 n, int id)
{
    vec3 param = n;
    uint normal_material = encode_normal_31bit(param);
    normal_material = (uint(id) << 31u) | normal_material;
    return normal_material;
}

void main()
{
    MaterialPropertiesGPU _737;
    _737.diffuse = materials.material_properties[_730.materialIndex].diffuse;
    _737.transparency = materials.material_properties[_730.materialIndex].transparency;
    _737.emissive = materials.material_properties[_730.materialIndex].emissive;
    _737.roughness = materials.material_properties[_730.materialIndex].roughness;
    _737.triplanar_factor = materials.material_properties[_730.materialIndex].triplanar_factor;
    _737.refraction = materials.material_properties[_730.materialIndex].refraction;
    _737.normal_factor = materials.material_properties[_730.materialIndex].normal_factor;
    _737.emissive_factor = materials.material_properties[_730.materialIndex].emissive_factor;
    _737.temporal_accumulation_factor = materials.material_properties[_730.materialIndex].temporal_accumulation_factor;
    _737.shadowmap_bias = materials.material_properties[_730.materialIndex].shadowmap_bias;
    _737.metalness = materials.material_properties[_730.materialIndex].metalness;
    _737.albedo_sampler = materials.material_properties[_730.materialIndex].albedo_sampler;
    _737.emissive_sampler = materials.material_properties[_730.materialIndex].emissive_sampler;
    _737.normal_sampler = materials.material_properties[_730.materialIndex].normal_sampler;
    _737.metalic_roughness_sampler = materials.material_properties[_730.materialIndex].metalic_roughness_sampler;
    _737.flags = materials.material_properties[_730.materialIndex].flags;
    _737._pad0 = materials.material_properties[_730.materialIndex]._pad0;
    _737._pad1 = materials.material_properties[_730.materialIndex]._pad1;
    MaterialPropertiesGPU material = _737;
    mat4 mat_instance_model;
    mat_instance_model[0] = vec4(1.0, 0.0, 0.0, 0.0);
    mat_instance_model[1] = vec4(0.0, 1.0, 0.0, 0.0);
    mat_instance_model[2] = vec4(0.0, 0.0, 1.0, 0.0);
    mat_instance_model[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (_753.instance_params.stride > 0)
    {
        vec4 inst_m0 = _763.instance_transform[(instanceID * uint(_753.instance_params.stride)) + 0u];
        vec4 inst_m1 = _763.instance_transform[(instanceID * uint(_753.instance_params.stride)) + 1u];
        vec4 inst_m2 = _763.instance_transform[(instanceID * uint(_753.instance_params.stride)) + 2u];
        vec3 _799 = vec3(inst_m0.x, inst_m1.x, inst_m2.x);
        mat_instance_model[0].x = _799.x;
        mat_instance_model[0].y = _799.y;
        mat_instance_model[0].z = _799.z;
        vec3 _812 = vec3(inst_m0.y, inst_m1.y, inst_m2.y);
        mat_instance_model[1].x = _812.x;
        mat_instance_model[1].y = _812.y;
        mat_instance_model[1].z = _812.z;
        vec3 _825 = vec3(inst_m0.z, inst_m1.z, inst_m2.z);
        mat_instance_model[2].x = _825.x;
        mat_instance_model[2].y = _825.y;
        mat_instance_model[2].z = _825.z;
        vec3 _839 = vec3(inst_m0.w, inst_m1.w, inst_m2.w);
        mat_instance_model[3].x = _839.x;
        mat_instance_model[3].y = _839.y;
        mat_instance_model[3].z = _839.z;
    }
    vec3 instance_function_origin = _261.raymarch_params.function_origin;
    if (_261.raymarch_params.use_instance_origin != 0)
    {
        instance_function_origin = (mat_instance_model * vec4(_261.raymarch_params.function_origin, 1.0)).xyz * 0.001000000047497451305389404296875;
    }
    mat_instance_model = _868.transform_params.mModel * mat_instance_model;
    mat4 mat_instance_model_inv = mat_instance_model;
    mat3 param = mat3(mat_instance_model_inv[0].xyz, mat_instance_model_inv[1].xyz, mat_instance_model_inv[2].xyz);
    mat3 inv = inverse_mat3(param);
    mat_instance_model_inv[0].x = inv[0].x;
    mat_instance_model_inv[0].y = inv[0].y;
    mat_instance_model_inv[0].z = inv[0].z;
    mat_instance_model_inv[1].x = inv[1].x;
    mat_instance_model_inv[1].y = inv[1].y;
    mat_instance_model_inv[1].z = inv[1].z;
    mat_instance_model_inv[2].x = inv[2].x;
    mat_instance_model_inv[2].y = inv[2].y;
    mat_instance_model_inv[2].z = inv[2].z;
    mat_instance_model_inv[3].x = -(((inv[0].x * mat_instance_model[3].x) + (inv[1].x * mat_instance_model[3].y)) + (inv[2].x * mat_instance_model[3].z));
    mat_instance_model_inv[3].y = -(((inv[0].y * mat_instance_model[3].x) + (inv[1].y * mat_instance_model[3].y)) + (inv[2].y * mat_instance_model[3].z));
    mat_instance_model_inv[3].z = -(((inv[0].z * mat_instance_model[3].x) + (inv[1].z * mat_instance_model[3].y)) + (inv[2].z * mat_instance_model[3].z));
    float g = (vtx_input.vNorm.z * 0.5) + 0.5;
    vec3 worldNorm = vtx_input.vWorldNorm;
    float param_1 = material.metalness;
    float param_2 = material.roughness;
    uint param_3 = uint(_730.materialIndex);
    uvec2 _995 = encode_metalness_roughness_material(param_1, param_2, param_3);
    outMetalnessRoughnessMeterialTags.x = _995.x;
    outMetalnessRoughnessMeterialTags.y = _995.y;
    uint param_4 = uint(_730.componentTags);
    uvec2 _1005 = encode_component_tags(param_4);
    outMetalnessRoughnessMeterialTags.z = _1005.x;
    outMetalnessRoughnessMeterialTags.w = _1005.y;
    vec3 ro = (mat_instance_model_inv * vec4(vtx_input.vWorldPos, 1.0)).xyz;
    vec3 rd = (mat_instance_model_inv * vec4(_868.transform_params.vCameraPosition, 1.0)).xyz;
    rd = normalize(ro - rd);
    ro *= _261.raymarch_params.function_scale;
    vec3 ro_bounding_volume = ro;
    ro += instance_function_origin;
    vec4 color = vec4(1.0);
    float bounding_volume_intersection = 100000.0;
    if (_261.raymarch_params.clamp_to_volume != 0)
    {
        vec3 param_5 = ro_bounding_volume;
        vec3 param_6 = rd;
        vec3 param_7 = _261.raymarch_params.function_scale;
        bounding_volume_intersection = raymarchBBox(param_5, param_6, param_7);
    }
    vec3 param_8 = ro;
    vec3 param_9 = rd;
    float param_10 = bounding_volume_intersection;
    vec4 param_11;
    float _1068 = calcIntersection(param_8, param_9, param_10, param_11);
    color = param_11;
    float intersection = _1068;
    if (intersection > 0.0)
    {
        vec3 ri = ro + (rd * intersection);
        vec3 param_12 = ri;
        vec3 normal = doModelNormal(param_12);
        vec3 world_normal = (mat_instance_model * vec4(normal, 0.0)).xyz;
        vec3 param_13 = normalize(world_normal);
        int param_14 = _730.materialId;
        outNormalMaterial = encode_normal_material(param_13, param_14);
        ri -= instance_function_origin;
        ri /= _261.raymarch_params.function_scale;
        ri = ((_868.transform_params.mView * mat_instance_model) * vec4(ri, 1.0)).xyz;
        vec3 _1126 = mix(vec3(1.0), color.xyz, vec3(_261.raymarch_params.param4));
        outAlbedo.x = _1126.x;
        outAlbedo.y = _1126.y;
        outAlbedo.z = _1126.z;
        if (true)
        {
            float near = -1.0;
            float far = 1.0;
            float depth = (_868.transform_params.mProjection * vec4(ri, 1.0)).z / (_868.transform_params.mProjection * vec4(ri, 1.0)).w;
            depth = ((((far - near) * depth) + near) + far) / 2.0;
            gl_FragDepth = depth;
        }
    }
    else
    {
        if (_261.raymarch_params.show_bounding_box != 0)
        {
            if (intersection == (-1.0))
            {
                outAlbedo = vec4(0.4000000059604644775390625, 0.20000000298023223876953125, 0.0, 1.0);
            }
            else
            {
                outAlbedo = vec4(5.0, 0.0, 0.0, 1.0);
            }
            vec3 _1191 = fract(vtx_input.vCoords * 0.00999999977648258209228515625);
            outAlbedo.x = _1191.x;
            outAlbedo.y = _1191.y;
            outAlbedo.z = _1191.z;
        }
        else
        {
            discard;
        }
    }
}

 