#version 450

struct GlowParams
{
    vec2 resolution;
    vec2 inv_resolution;
    vec3 threshold;
    float _pad0;
    vec3 color;
    float _pad1;
    float iteration;
};

layout(set = 1, binding = 1, std140) uniform GlowParamsBuffer
{
    GlowParams glow_params;
} _33;

layout(set = 1, binding = 2) uniform sampler2D s_texture0;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

vec3 threshold_input(vec3 inpt)
{
    return max(vec3(0.0), inpt - _33.glow_params.threshold);
}

vec3 KawaseBlurFilter(sampler2D tex, vec2 texCoord, vec2 pixelSize, float _distance)
{
    vec2 dUV = pixelSize * _distance;
    vec2 texCoordSample;
    texCoordSample.x = texCoord.x - dUV.x;
    texCoordSample.y = texCoord.y + dUV.y;
    vec3 cOut = texture(tex, texCoordSample).xyz;
    texCoordSample.x = texCoord.x + dUV.x;
    texCoordSample.y = texCoord.y + dUV.y;
    cOut += texture(tex, texCoordSample).xyz;
    texCoordSample.x = texCoord.x + dUV.x;
    texCoordSample.y = texCoord.y - dUV.y;
    cOut += texture(tex, texCoordSample).xyz;
    texCoordSample.x = texCoord.x - dUV.x;
    texCoordSample.y = texCoord.y - dUV.y;
    cOut += texture(tex, texCoordSample).xyz;
    cOut *= 0.25;
    vec3 param = cOut;
    return threshold_input(param);
}

void main()
{
    if (_33.glow_params.iteration == 0.0)
    {
        vec2 tc = vTexcoord0;
        vec2 param = tc;
        vec2 param_1 = _33.glow_params.inv_resolution;
        float param_2 = _33.glow_params.iteration + 0.5;
        outColor = vec4(KawaseBlurFilter(s_texture0, param, param_1, param_2), 1.0);
    }
    else
    {
        vec2 tc_1 = vTexcoord0;
        vec2 param_3 = tc_1;
        vec2 param_4 = _33.glow_params.inv_resolution * 0.5;
        float param_5 = _33.glow_params.iteration + 0.5;
        outColor = vec4(KawaseBlurFilter(s_texture0, param_3, param_4, param_5), 1.0);
    }
}

 