#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct TransformGeometryOutputVertexParams
{
    int coord_stride;
    int normal_stride;
    int uv0_stride;
    int coord_offset;
    int normal_offset;
    int uv0_offset;
    int _pad0;
    int _pad1;
};

struct TransformGeometryParams
{
    TransformGeometryOutputVertexParams output_vtx_params;
    uint instance_idx;
    uint surface_idx;
    uint voxelize;
    uint raytrace;
    uint material_idx;
    int _points_per_instance;
    int _faces_per_instance;
    int transform_normals;
    int calculate_bbox_raytrace;
    int calculate_bbox_voxelize;
    uint _instances_num;
    uint initialize_bbox;
    vec4 default_bbox_raytrace_min;
    vec4 default_bbox_raytrace_max;
    vec4 default_bbox_voxelize_min;
    vec4 default_bbox_voxelize_max;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct link_list_node
{
    uint value;
    uint next;
};

layout(set = 0, binding = 1, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _26;

layout(set = 0, binding = 4, std140) uniform TransformGeometryParamsBuffer
{
    TransformGeometryParams transform_geometry_params;
} _54;

layout(set = 0, binding = 2, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _66;

layout(set = 0, binding = 3, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _107;

shared vec3 calculate_bbox_min_for_thread[64];
shared vec3 calculate_bbox_max_for_thread[64];

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_26.in_vtx_data[coord_offset + 0u], _26.in_vtx_data[coord_offset + 1u], _26.in_vtx_data[coord_offset + 2u]);
    return p;
}

void main()
{
    uint prim_idx = _54.transform_geometry_params.instance_idx;
    uint first_idx = 0u;
    uint n = _66.transformed_data_location[prim_idx].last_face_idx + 1u;
    if (prim_idx > 0u)
    {
        n -= (_66.transformed_data_location[prim_idx - 1u].last_face_idx + 1u);
        first_idx = _66.transformed_data_location[prim_idx - 1u].last_face_idx + 1u;
    }
    uint face_idx = gl_GlobalInvocationID.x;
    if (face_idx >= n)
    {
        face_idx = n - 1u;
    }
    uint param = _107.transformed_data_indices[((first_idx + face_idx) * 3u) + 0u];
    vec3 v0 = rt_get_vertex(param);
    uint param_1 = _107.transformed_data_indices[((first_idx + face_idx) * 3u) + 1u];
    vec3 v1 = rt_get_vertex(param_1);
    uint param_2 = _107.transformed_data_indices[((first_idx + face_idx) * 3u) + 2u];
    vec3 v2 = rt_get_vertex(param_2);
    vec3 bbox_min = v0;
    vec3 bbox_max = v0;
    bbox_min = min(bbox_min, v1);
    bbox_min = min(bbox_min, v2);
    bbox_max = max(bbox_max, v1);
    bbox_max = max(bbox_max, v2);
    calculate_bbox_min_for_thread[gl_LocalInvocationIndex] = bbox_min;
    calculate_bbox_max_for_thread[gl_LocalInvocationIndex] = bbox_max;
    memoryBarrierShared();
    barrier();
    if (gl_LocalInvocationIndex == 0u)
    {
        for (uint i = 1u; i < 64u; i++)
        {
            bbox_min = min(bbox_min, calculate_bbox_min_for_thread[i]);
            bbox_max = max(bbox_max, calculate_bbox_max_for_thread[i]);
        }
        int _199 = atomicMin(_66.transformed_data_location[prim_idx].bbox_min.x, int(bbox_min.x));
        int _205 = atomicMin(_66.transformed_data_location[prim_idx].bbox_min.y, int(bbox_min.y));
        int _211 = atomicMin(_66.transformed_data_location[prim_idx].bbox_min.z, int(bbox_min.z));
        int _218 = atomicMax(_66.transformed_data_location[prim_idx].bbox_max.x, int(bbox_max.x));
        int _224 = atomicMax(_66.transformed_data_location[prim_idx].bbox_max.y, int(bbox_max.y));
        int _230 = atomicMax(_66.transformed_data_location[prim_idx].bbox_max.z, int(bbox_max.z));
    }
}

 