#version 450

struct TextureResourceParams
{
    int flip_y;
    int clamp_range_01;
    float remap_range_start;
    float remap_range_end;
};

struct VertexModifierUVParams
{
    mat4 transform;
    bool override;
    int override_mode;
};

struct VertexInput
{
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct VertexModifierNoiseParams
{
    mat4 transform_world_to_local;
    mat4 transform_local_to_world;
    mat4 transform_local;
    mat4 transform_local_inv;
    mat4 transform_parent;
    mat4 transform_parent_inv;
    vec4 noise_phase;
    vec3 noise_scale;
    int falloff_curve_idx;
    vec3 scale;
    int falloff_inverse;
    vec3 position;
    int noise_relative_to_modifier;
    vec3 radius;
    int displacement_mode;
    float noise_value_base;
    int noise_value_absolute;
};

struct VertexModifierTextureDisplaceParams
{
    mat4 transform_world_to_local;
    mat4 transform_local_to_world;
    mat4 transform_local;
    mat4 transform_local_inv;
    mat4 transform_parent;
    mat4 transform_parent_inv;
    vec3 value_scale;
    float value_base;
    vec3 scale;
    int falloff_inverse;
    vec3 position;
    int displacement_mode;
    vec3 radius;
    int value_absolute;
    int falloff_curve_idx;
    int material_id;
    int radial;
    int smooth_displacement;
    int mapping_plane;
    int _pad0;
    int _pad1;
    int _pad2;
    TextureResourceParams source_txt_params;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    vec3 vCameraPosition;
};

const int _1173[5] = int[](-2, -1, 0, 1, 2);
const float _1195[5] = float[](0.0625, 0.25, 0.375, 0.25, 0.0625);

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct VertexModifierUVParams_1
{
    mat4 transform;
    uint override;
    int override_mode;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct _2098
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer VTXCoords
{
    float coords[];
} vtx_coords;

layout(set = 0, binding = 2, std430) buffer VTXNormals
{
    float normals[];
} vtx_normals;

layout(set = 0, binding = 3, std430) buffer VTXAlbedo
{
    float albedo[];
} vtx_albedo;

layout(set = 0, binding = 4, std430) buffer VTXUV0
{
    float uv0[];
} vtx_uv0;

layout(set = 0, binding = 7, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _757;

layout(set = 0, binding = 8, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 0, binding = 9, std140) uniform GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _1875;

layout(set = 0, binding = 10, std140) uniform VM0
{
    layout(row_major) VertexModifierUVParams_1 VM0_params;
} _1921;

layout(set = 0, binding = 11, std140) uniform VM1
{
    layout(row_major) VertexModifierNoiseParams VM1_params;
} _1940;

layout(set = 0, binding = 12, std140) uniform VM2
{
    layout(row_major) VertexModifierTextureDisplaceParams VM2_params;
} _1954;

layout(set = 0, binding = 13, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1967;

layout(set = 0, binding = 5, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1978;

layout(set = 0, binding = 6, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _2060;

layout(set = 0, binding = 14) uniform sampler2D s_Curves;
layout(set = 0, binding = 15) uniform sampler2D material_textures[64];

layout(location = 0) out uint instanceID;
layout(location = 1) out _2098 vtx_output;

vec3 vtx_coords_load(uint idx)
{
    return vec3(vtx_coords.coords[(idx * 3u) + 0u], vtx_coords.coords[(idx * 3u) + 1u], vtx_coords.coords[(idx * 3u) + 2u]);
}

vec3 vtx_albedo_load(uint idx)
{
    return vec3(vtx_albedo.albedo[(idx * 3u) + 0u], vtx_albedo.albedo[(idx * 3u) + 1u], vtx_albedo.albedo[(idx * 3u) + 2u]);
}

vec3 vtx_normals_load(uint idx)
{
    return vec3(vtx_normals.normals[(idx * 3u) + 0u], vtx_normals.normals[(idx * 3u) + 1u], vtx_normals.normals[(idx * 3u) + 2u]);
}

vec2 vtx_uv0_load(uint idx)
{
    return vec2(vtx_uv0.uv0[(idx * 2u) + 0u], vtx_uv0.uv0[(idx * 2u) + 1u]);
}

void vertex_modifier_uv_apply(VertexModifierUVParams params, inout VertexInput vtx_input)
{
    vec2 uv = vtx_input.uv0;
    if (params.override)
    {
        if (params.override_mode == 0)
        {
            uv = vtx_input.pos.xy;
        }
        if (params.override_mode == 1)
        {
            uv = vtx_input.pos.yz;
        }
        if (params.override_mode == 2)
        {
            uv = vtx_input.pos.xz;
        }
        if (params.override_mode == 3)
        {
            uv.x = length(vtx_input.pos);
            uv.y = 0.0;
        }
    }
    uv = (params.transform * vec4(uv, 0.0, 1.0)).xy;
    vtx_input.uv0 = uv;
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise_grad(vec3 v, inout vec3 gradient)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.60000002384185791015625) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    vec4 m2 = m * m;
    vec4 m4 = m2 * m2;
    vec4 pdotx = vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3));
    vec4 temp = (m2 * m) * pdotx;
    gradient = ((((x0 * temp.x) + (x1 * temp.y)) + (x2 * temp.z)) + (x3 * temp.w)) * (-8.0);
    gradient += ((((p0 * m4.x) + (p1 * m4.y)) + (p2 * m4.z)) + (p3 * m4.w));
    gradient *= 42.0;
    return 42.0 * dot(m4, pdotx);
}

void vertex_modifier_noise_apply(VertexModifierNoiseParams params, inout VertexInput vtx_input)
{
    vec3 modifier_position = vec3(0.0);
    vec3 base_pos = vtx_input.pos;
    vec3 param = vtx_input.pos;
    mat4 param_1 = (params.transform_parent_inv * params.transform_local_inv) * _757.transform_params.mModel;
    vec3 influence_pos = vector_transform_by_mat43(param, param_1);
    vec3 noise_pos = influence_pos;
    if (params.noise_relative_to_modifier == 0)
    {
        vec3 param_2 = noise_pos;
        mat4 param_3 = params.transform_local;
        noise_pos = vector_transform_by_mat43(param_2, param_3);
    }
    vec3 rel_coords = base_pos;
    vec3 influence_rel_coords = influence_pos;
    float influence = length((influence_rel_coords - modifier_position) / params.radius);
    if (influence <= 1.0)
    {
        if (params.falloff_inverse == 0)
        {
            influence = 1.0 - influence;
        }
        int param_4 = params.falloff_curve_idx;
        float param_5 = influence;
        influence = clamp(curve_sample(param_4, param_5), 0.0, 1.0);
        vec3 ni = noise_pos * params.noise_scale;
        vec3 n1_grad = vec3(0.0);
        vec3 n2_grad = vec3(0.0);
        vec3 param_6 = (ni + (params.noise_phase.xyz * 0.100000001490116119384765625)) + vec3(params.noise_phase.w * 0.01229999959468841552734375);
        vec3 param_7;
        float _839 = snoise_grad(param_6, param_7);
        n1_grad = param_7;
        float n1 = _839;
        vec3 param_8 = ((ni * 0.5) + (params.noise_phase.xyz * 0.100000001490116119384765625)) + vec3(params.noise_phase.w * 0.02170000039041042327880859375);
        vec3 param_9;
        float _857 = snoise_grad(param_8, param_9);
        n2_grad = param_9;
        float n2 = _857;
        n1_grad *= params.noise_scale;
        n2_grad *= (params.noise_scale * 0.5);
        n2 *= 0.5;
        n2_grad *= 0.5;
        float d = 1.0;
        float n = (params.noise_value_base + n1) + n2;
        float n_dx = (((params.noise_value_base + n1) + (n1_grad.x * d)) + n2) + (n2_grad.x * d);
        float n_dy = (((params.noise_value_base + n1) + (n1_grad.y * d)) + n2) + (n2_grad.y * d);
        float n_dz = (((params.noise_value_base + n1) + (n1_grad.z * d)) + n2) + (n2_grad.z * d);
        if (params.noise_value_absolute != 0)
        {
            n = abs(n);
            n_dx = abs(n_dx);
            n_dy = abs(n_dy);
            n_dz = abs(n_dz);
        }
        vec3 scale = params.scale;
        vec3 local_norm = vtx_input.norm;
        if (params.displacement_mode == 1)
        {
            vec3 param_10 = modifier_position;
            mat4 param_11 = params.transform_local;
            local_norm = normalize(base_pos - vector_transform_by_mat43(param_10, param_11));
        }
        vec3 new_pos = base_pos + ((local_norm * n) * scale);
        vec3 new_pos_dx = (base_pos + vec3(d, 0.0, 0.0)) + ((local_norm * n_dx) * scale);
        vec3 new_pos_dy = (base_pos + vec3(0.0, d, 0.0)) + ((local_norm * n_dy) * scale);
        vec3 new_pos_dz = (base_pos + vec3(0.0, 0.0, d)) + ((local_norm * n_dz) * scale);
        new_pos = mix(base_pos, new_pos, vec3(influence));
        new_pos_dx = mix(base_pos + vec3(d, 0.0, 0.0), new_pos_dx, vec3(influence));
        new_pos_dy = mix(base_pos + vec3(0.0, d, 0.0), new_pos_dy, vec3(influence));
        new_pos_dz = mix(base_pos + vec3(0.0, 0.0, d), new_pos_dz, vec3(influence));
        vec3 dx = new_pos_dx - new_pos;
        vec3 dy = new_pos_dy - new_pos;
        vec3 dz = new_pos_dz - new_pos;
        vec3 new_norm = vec3(1.0);
        bool _1058 = abs(vtx_input.norm.x) >= abs(vtx_input.norm.y);
        bool _1068;
        if (_1058)
        {
            _1068 = abs(vtx_input.norm.x) >= abs(vtx_input.norm.z);
        }
        else
        {
            _1068 = _1058;
        }
        if (_1068)
        {
            dy = normalize(dy);
            dz = normalize(dz);
            dx = cross(dy, dz);
        }
        else
        {
            bool _1085 = abs(vtx_input.norm.y) >= abs(vtx_input.norm.x);
            bool _1095;
            if (_1085)
            {
                _1095 = abs(vtx_input.norm.y) >= abs(vtx_input.norm.z);
            }
            else
            {
                _1095 = _1085;
            }
            if (_1095)
            {
                dx = normalize(dx);
                dz = normalize(dz);
                dy = cross(dz, dx);
            }
            else
            {
                dx = normalize(dx);
                dy = normalize(dy);
                dz = cross(dx, dy);
            }
        }
        new_norm = mat3(vec3(dx), vec3(dy), vec3(dz)) * vtx_input.norm;
        vtx_input.pos = new_pos;
        vtx_input.norm = normalize(new_norm);
    }
}

vec4 texture_sample_lod_with_params(sampler2D smp, inout vec2 uv, float lod, TextureResourceParams params)
{
    if (params.flip_y != 0)
    {
        uv.y = 1.0 - uv.y;
    }
    vec4 v = textureLod(smp, uv, lod);
    v = (v - vec4(params.remap_range_start)) / vec4(params.remap_range_end - params.remap_range_start);
    if (params.clamp_range_01 != 0)
    {
        v = clamp(v, vec4(0.0), vec4(1.0));
    }
    return v;
}

float vertex_modifier_texture_displace_sample_texture_avg(sampler2D t, vec2 p, float lod, inout float d, TextureResourceParams t_params)
{
    float t_w = 0.0;
    float v = 0.0;
    ivec2 t_size = textureSize(t, int(lod));
    d = 1.0 / float(t_size.x);
    for (int y = 0; y < 5; y++)
    {
        for (int x = 0; x < 5; x++)
        {
            vec2 dp = (vec2(float(_1173[x]), float(_1173[y])) * d) * 1.5;
            float w = _1195[x] * _1195[y];
            vec2 param = p + dp;
            float param_1 = lod;
            TextureResourceParams param_2 = t_params;
            vec4 _1214 = texture_sample_lod_with_params(t, param, param_1, param_2);
            v += (_1214.x * w);
            t_w += w;
        }
    }
    return v / t_w;
}

float vertex_modifier_texture_displace_sample_texture(sampler2D t, vec2 p, float lod, float d, bool smooth_displacement, TextureResourceParams t_params)
{
    if (smooth_displacement)
    {
        vec2 param = p;
        float param_1 = lod;
        float param_2 = d;
        TextureResourceParams param_3 = t_params;
        float _1243 = vertex_modifier_texture_displace_sample_texture_avg(t, param, param_1, param_2, param_3);
        return _1243;
    }
    else
    {
        vec2 param_4 = p;
        float param_5 = lod;
        TextureResourceParams param_6 = t_params;
        vec4 _1252 = texture_sample_lod_with_params(t, param_4, param_5, param_6);
        return _1252.x;
    }
}

void vertex_modifier_texture_displace_apply(VertexModifierTextureDisplaceParams params, inout VertexInput vtx_input)
{
    if (params.material_id == 0)
    {
        return;
    }
    vec3 modifier_position = vec3(0.0);
    vec3 base_pos = vtx_input.pos;
    vec3 param = vtx_input.pos;
    mat4 param_1 = (params.transform_parent_inv * params.transform_local_inv) * _757.transform_params.mModel;
    vec3 influence_pos = vector_transform_by_mat43(param, param_1);
    vec3 texture_sample_pos = influence_pos;
    vec3 rel_coords = base_pos;
    vec3 influence_rel_coords = influence_pos;
    float influence = length((influence_rel_coords - modifier_position) / params.radius);
    if (influence <= 1.0)
    {
        MaterialPropertiesGPU _1312;
        _1312.diffuse = materials.material_properties[params.material_id].diffuse;
        _1312.transparency = materials.material_properties[params.material_id].transparency;
        _1312.emissive = materials.material_properties[params.material_id].emissive;
        _1312.roughness = materials.material_properties[params.material_id].roughness;
        _1312.triplanar_factor = materials.material_properties[params.material_id].triplanar_factor;
        _1312.refraction = materials.material_properties[params.material_id].refraction;
        _1312.normal_factor = materials.material_properties[params.material_id].normal_factor;
        _1312.emissive_factor = materials.material_properties[params.material_id].emissive_factor;
        _1312.temporal_accumulation_factor = materials.material_properties[params.material_id].temporal_accumulation_factor;
        _1312.shadowmap_bias = materials.material_properties[params.material_id].shadowmap_bias;
        _1312.metalness = materials.material_properties[params.material_id].metalness;
        _1312.albedo_sampler = materials.material_properties[params.material_id].albedo_sampler;
        _1312.emissive_sampler = materials.material_properties[params.material_id].emissive_sampler;
        _1312.normal_sampler = materials.material_properties[params.material_id].normal_sampler;
        _1312.metalic_roughness_sampler = materials.material_properties[params.material_id].metalic_roughness_sampler;
        _1312.flags = materials.material_properties[params.material_id].flags;
        _1312._pad0 = materials.material_properties[params.material_id]._pad0;
        _1312._pad1 = materials.material_properties[params.material_id]._pad1;
        MaterialPropertiesGPU material = _1312;
        if (material.albedo_sampler == (-1))
        {
            return;
        }
        if (params.falloff_inverse == 0)
        {
            influence = 1.0 - influence;
        }
        int param_2 = params.falloff_curve_idx;
        float param_3 = 1.0 - influence;
        influence = curve_sample(param_2, param_3);
        float lod = 0.0;
        float d_texel = 1.0 / float(textureSize(material_textures[material.albedo_sampler], int(lod)).x);
        vec2 d_gradient = vec2(0.02500000037252902984619140625);
        vec2 tpos = vec2(0.0);
        vec3 tpos_offset_x = vec3(0.0);
        vec3 tpos_offset_y = vec3(0.0);
        if (params.mapping_plane == 0)
        {
            d_gradient = (params.radius.yz * d_texel) / (params.scale.xy / vec2(2.0));
            tpos = texture_sample_pos.yz / (params.radius.yz * 2.0);
            tpos_offset_x = vec3(0.0, d_gradient.x, 0.0);
            tpos_offset_y = vec3(0.0, 0.0, d_gradient.y);
        }
        else
        {
            if (params.mapping_plane == 1)
            {
                d_gradient = (params.radius.xz * d_texel) / (params.scale.xy / vec2(2.0));
                tpos = texture_sample_pos.xz / (params.radius.xz * 2.0);
                tpos_offset_x = vec3(d_gradient.x, 0.0, 0.0);
                tpos_offset_y = vec3(0.0, 0.0, d_gradient.y);
            }
            else
            {
                d_gradient = (params.radius.xy * d_texel) / (params.scale.xy / vec2(2.0));
                tpos = texture_sample_pos.xy / (params.radius.xy * 2.0);
                tpos_offset_x = vec3(d_gradient.x, 0.0, 0.0);
                tpos_offset_y = vec3(0.0, d_gradient.y, 0.0);
            }
        }
        if (params.radial != 0)
        {
            float r = length(fract(abs(tpos)) - vec2(0.5));
            vec2 t = fract(tpos) - vec2(0.5);
            if (abs(t.y) < 9.9999997473787516355514526367188e-06)
            {
                t.y = 9.9999997473787516355514526367188e-06;
            }
            tpos.x = 1.0 - (abs((atan(t.y, t.x) / 3.1415927410125732421875) + 1.0) * 0.5);
            tpos.y = r * 2.0;
            tpos *= params.scale.xy;
        }
        else
        {
            tpos *= params.scale.xy;
            tpos -= vec2(0.5);
            tpos.y = 1.0 - tpos.y;
        }
        tpos.y = 1.0 - tpos.y;
        vec2 param_4 = tpos + vec2(-d_texel, 0.0);
        float param_5 = lod;
        float param_6 = d_texel;
        bool param_7 = params.smooth_displacement != 0;
        TextureResourceParams param_8 = params.source_txt_params;
        float b_x = vertex_modifier_texture_displace_sample_texture(material_textures[material.albedo_sampler], param_4, param_5, param_6, param_7, param_8);
        vec2 param_9 = tpos + vec2(0.0, d_texel);
        float param_10 = lod;
        float param_11 = d_texel;
        bool param_12 = params.smooth_displacement != 0;
        TextureResourceParams param_13 = params.source_txt_params;
        float b_y = vertex_modifier_texture_displace_sample_texture(material_textures[material.albedo_sampler], param_9, param_10, param_11, param_12, param_13);
        vec2 param_14 = tpos;
        float param_15 = lod;
        float param_16 = d_texel;
        bool param_17 = params.smooth_displacement != 0;
        TextureResourceParams param_18 = params.source_txt_params;
        float b = vertex_modifier_texture_displace_sample_texture(material_textures[material.albedo_sampler], param_14, param_15, param_16, param_17, param_18);
        float n = params.value_base + b;
        float n_dx = params.value_base + b_x;
        float n_dy = params.value_base + b_y;
        if (params.value_absolute != 0)
        {
            n = abs(n);
            n_dx = abs(n_dx);
            n_dy = abs(n_dy);
        }
        float scale = params.value_scale.z;
        vec3 local_norm = vtx_input.norm;
        if (params.displacement_mode == 1)
        {
            vec3 param_19 = modifier_position;
            mat4 param_20 = params.transform_local;
            local_norm = normalize(base_pos - vector_transform_by_mat43(param_19, param_20));
        }
        vec3 new_pos = base_pos + ((local_norm * n) * scale);
        vec3 new_pos_dx = (base_pos + tpos_offset_x) + ((local_norm * n_dx) * scale);
        vec3 new_pos_dy = (base_pos + tpos_offset_y) + ((local_norm * n_dy) * scale);
        new_pos = mix(base_pos, new_pos, vec3(influence));
        new_pos_dx = mix(base_pos + tpos_offset_x, new_pos_dx, vec3(influence));
        new_pos_dy = mix(base_pos + tpos_offset_y, new_pos_dy, vec3(influence));
        vec3 dx;
        vec3 dy;
        if (params.mapping_plane == 0)
        {
            dx = vec3(((n_dx - n) * influence) * scale, d_gradient.x, 0.0);
            dy = vec3(((n_dy - n) * influence) * scale, 0.0, d_gradient.y);
        }
        else
        {
            if (params.mapping_plane == 1)
            {
                dx = vec3(d_gradient.x, ((-(n_dx - n)) * influence) * scale, 0.0);
                dy = vec3(0.0, ((-(n_dy - n)) * influence) * scale, d_gradient.y);
            }
            else
            {
                dx = vec3(d_gradient.x, 0.0, ((n_dx - n) * influence) * scale);
                dy = vec3(0.0, d_gradient.y, ((n_dy - n) * influence) * scale);
            }
        }
        vec3 new_norm = vec3(1.0);
        dx = normalize(dx);
        dy = normalize(dy);
        vec3 dz = cross(dx, dy);
        dx = cross(dz, dy);
        mat3 m;
        m[0] = vec3(dx.x, dy.x, dz.x);
        m[1] = vec3(dx.y, dy.y, dz.y);
        m[2] = vec3(dx.z, dy.z, dz.z);
        if (params.mapping_plane == 0)
        {
            new_norm = mat3(vec3(dx), vec3(dy), vec3(dz)) * vtx_input.norm;
        }
        else
        {
            if (params.mapping_plane == 1)
            {
                mat3 _1820 = mat3(vec3(dx), vec3(dz), vec3(dy));
                new_norm = mat3(-_1820[0], -_1820[1], -_1820[2]) * vtx_input.norm;
            }
            else
            {
                new_norm = mat3(vec3(dx), vec3(dy), vec3(dz)) * vtx_input.norm;
            }
        }
        vtx_input.pos = new_pos;
        vtx_input.norm = normalize(new_norm);
    }
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

void main()
{
    uint param = uint(gl_VertexIndex);
    VertexInput vtx_input;
    vtx_input.pos = vtx_coords_load(param);
    vtx_input.norm = vec3(1.0, 0.0, 0.0);
    vtx_input.color = vec4(1.0);
    vtx_input.uv0 = vtx_input.pos.xy;
    if ((_1875.geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = uint(gl_VertexIndex);
        vtx_input.color = vec4(vtx_albedo_load(param_1), 1.0);
    }
    if ((_1875.geometry_information.builtin_attribute_mask & 2u) != 0u)
    {
        uint param_2 = uint(gl_VertexIndex);
        vtx_input.norm = vtx_normals_load(param_2);
    }
    if ((_1875.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_3 = uint(gl_VertexIndex);
        vtx_input.uv0 = vtx_uv0_load(param_3);
    }
    VertexInput vtx_modifier_input_base = vtx_input;
    VertexModifierUVParams param_4;
    param_4.transform = _1921.VM0_params.transform;
    param_4.override = _1921.VM0_params.override != 0u;
    param_4.override_mode = _1921.VM0_params.override_mode;
    VertexInput param_5 = vtx_input;
    vertex_modifier_uv_apply(param_4, param_5);
    vtx_input = param_5;
    VertexModifierNoiseParams _1945;
    _1945.transform_world_to_local = _1940.VM1_params.transform_world_to_local;
    _1945.transform_local_to_world = _1940.VM1_params.transform_local_to_world;
    _1945.transform_local = _1940.VM1_params.transform_local;
    _1945.transform_local_inv = _1940.VM1_params.transform_local_inv;
    _1945.transform_parent = _1940.VM1_params.transform_parent;
    _1945.transform_parent_inv = _1940.VM1_params.transform_parent_inv;
    _1945.noise_phase = _1940.VM1_params.noise_phase;
    _1945.noise_scale = _1940.VM1_params.noise_scale;
    _1945.falloff_curve_idx = _1940.VM1_params.falloff_curve_idx;
    _1945.scale = _1940.VM1_params.scale;
    _1945.falloff_inverse = _1940.VM1_params.falloff_inverse;
    _1945.position = _1940.VM1_params.position;
    _1945.noise_relative_to_modifier = _1940.VM1_params.noise_relative_to_modifier;
    _1945.radius = _1940.VM1_params.radius;
    _1945.displacement_mode = _1940.VM1_params.displacement_mode;
    _1945.noise_value_base = _1940.VM1_params.noise_value_base;
    _1945.noise_value_absolute = _1940.VM1_params.noise_value_absolute;
    VertexModifierNoiseParams param_6 = _1945;
    VertexInput param_7 = vtx_input;
    vertex_modifier_noise_apply(param_6, param_7);
    vtx_input = param_7;
    VertexModifierTextureDisplaceParams _1959;
    _1959.transform_world_to_local = _1954.VM2_params.transform_world_to_local;
    _1959.transform_local_to_world = _1954.VM2_params.transform_local_to_world;
    _1959.transform_local = _1954.VM2_params.transform_local;
    _1959.transform_local_inv = _1954.VM2_params.transform_local_inv;
    _1959.transform_parent = _1954.VM2_params.transform_parent;
    _1959.transform_parent_inv = _1954.VM2_params.transform_parent_inv;
    _1959.value_scale = _1954.VM2_params.value_scale;
    _1959.value_base = _1954.VM2_params.value_base;
    _1959.scale = _1954.VM2_params.scale;
    _1959.falloff_inverse = _1954.VM2_params.falloff_inverse;
    _1959.position = _1954.VM2_params.position;
    _1959.displacement_mode = _1954.VM2_params.displacement_mode;
    _1959.radius = _1954.VM2_params.radius;
    _1959.value_absolute = _1954.VM2_params.value_absolute;
    _1959.falloff_curve_idx = _1954.VM2_params.falloff_curve_idx;
    _1959.material_id = _1954.VM2_params.material_id;
    _1959.radial = _1954.VM2_params.radial;
    _1959.smooth_displacement = _1954.VM2_params.smooth_displacement;
    _1959.mapping_plane = _1954.VM2_params.mapping_plane;
    _1959._pad0 = _1954.VM2_params._pad0;
    _1959._pad1 = _1954.VM2_params._pad1;
    _1959._pad2 = _1954.VM2_params._pad2;
    _1959.source_txt_params.flip_y = _1954.VM2_params.source_txt_params.flip_y;
    _1959.source_txt_params.clamp_range_01 = _1954.VM2_params.source_txt_params.clamp_range_01;
    _1959.source_txt_params.remap_range_start = _1954.VM2_params.source_txt_params.remap_range_start;
    _1959.source_txt_params.remap_range_end = _1954.VM2_params.source_txt_params.remap_range_end;
    VertexModifierTextureDisplaceParams param_8 = _1959;
    VertexInput param_9 = vtx_input;
    vertex_modifier_texture_displace_apply(param_8, param_9);
    vtx_input = param_9;
    if (_1967.instance_params.stride > 0)
    {
        vec4 inst_m0 = _1978.instance_transform[(gl_InstanceIndex * _1967.instance_params.stride) + 0];
        vec4 inst_m1 = _1978.instance_transform[(gl_InstanceIndex * _1967.instance_params.stride) + 1];
        vec4 inst_m2 = _1978.instance_transform[(gl_InstanceIndex * _1967.instance_params.stride) + 2];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0, v);
        vtx_input.pos.y = dot(inst_m1, v);
        vtx_input.pos.z = dot(inst_m2, v);
        vec3 param_10 = vtx_input.norm;
        mat4 param_11 = transpose(mat4(vec4(inst_m0), vec4(inst_m1), vec4(inst_m2), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_10, param_11));
        vec2 _2067 = unpackHalf2x16(_2060.instance_color[(gl_InstanceIndex * 2) + 0]);
        vec4 inst_c;
        inst_c.x = _2067.x;
        inst_c.y = _2067.y;
        vec2 _2077 = unpackHalf2x16(_2060.instance_color[(gl_InstanceIndex * 2) + 1]);
        inst_c.z = _2077.x;
        inst_c.w = _2077.y;
        vec4 _2083 = vtx_input.color;
        vec3 _2087 = _2083.xyz * inst_c.xyz;
        vtx_input.color.x = _2087.x;
        vtx_input.color.y = _2087.y;
        vtx_input.color.z = _2087.z;
    }
    instanceID = uint(gl_InstanceIndex);
    vtx_output.vLocalPos = vtx_input.pos;
    vec3 param_12 = vtx_input.pos;
    mat4 param_13 = _757.transform_params.mModel;
    vec3 vPosModel = vector_transform_by_mat43(param_12, param_13);
    vec3 param_14 = vtx_input.norm;
    mat4 param_15 = _757.transform_params.mModelNormal;
    vtx_output.vWorldNorm = vec3(vector_transform_by_mat33(param_14, param_15));
    vec3 param_16 = vPosModel;
    mat4 param_17 = _757.transform_params.mView;
    vec3 vPosModelView = vector_transform_by_mat43(param_16, param_17);
    vtx_output.vCoords = vPosModelView;
    vtx_output.vWorldPos = vPosModel;
    vtx_output.vWorldNorm = normalize(vtx_output.vWorldNorm);
    vtx_output.vNorm.x = dot(_757.transform_params.mModelViewInvTrans[0].xyz, vtx_input.norm);
    vtx_output.vNorm.y = dot(_757.transform_params.mModelViewInvTrans[1].xyz, vtx_input.norm);
    vtx_output.vNorm.z = dot(_757.transform_params.mModelViewInvTrans[2].xyz, vtx_input.norm);
    vtx_output.vNorm = vec3(normalize(vtx_output.vNorm));
    vtx_output.vNorm = vec3(vtx_input.norm);
    vtx_output.vColor = vec4(vtx_input.color);
    vtx_output.vUV0 = vec2(vtx_input.uv0);
    gl_Position = _757.transform_params.mProjection * vec4(vtx_output.vCoords, 1.0);
}

 