#version 430

// background buffers for transparency
uniform sampler2D s_texture_depthbuffer;
uniform sampler2D s_texture_colorbuffer;

#include <shaders/materials/commons.glsl>
#include <shaders/materials/cellular_noise/fake_voronoi.glsl>

// #define HAS_GEOMETRY_SHADER
// NOTE: this is a bit quirky. think about nicer solution
//       in general when it comes to shader linking....

#ifdef HAS_GEOMETRY_SHADER
in vec3 vGSNorm;
in vec3 vGSLocalPos;
in vec4 vGSWorldPos;
in vec3 vGSWorldNorm;
in vec2 vGSTexCoord;
in float vGSBrightness;
#define vNorm vGSNorm
#define vLocalPos vGSLocalPos
#define vWorldPos vGSWorldPos
#define vWorldNorm vGSWorldNorm
#define vTexCoord vGSTexCoord
#define vBrightness vGSBrightness
#else
in vec3 vNorm;
in vec3 vLocalPos;
in vec4 vWorldPos;
in vec3 vWorldNorm;
in float vBrightness;
#endif

uniform vec4 colorDiffuse;
uniform int materialId;
uniform vec3 vSunPos;
uniform vec3 vCameraPosition;
uniform int gUseDerivedNormal;
uniform vec4 vDistortionColor;

// output for 2 buffers
#ifndef SHADOWMAP_PASS
layout(location = 0) out vec4 outAlbedo;
layout(location = 1) out vec4 outNormalMaterial;
#endif

vec4 checker3D(vec3 texc, vec4 color0, vec4 color1)
{
  if ((int(floor(texc.x) + floor(texc.y) + floor(texc.z)) & 1) == 0)
    return color0;
  else
    return color1;
}

vec3 voronoi_normal(vec3 pos, float d)
{
	float p = cellTile(pos);
	float px = cellTile(pos + vec3(d, 0.0, 0.0));
	float py = cellTile(pos + vec3(0.0, d, 0.0));
	float pz = cellTile(pos + vec3(0.0, 0.0, d));

	return normalize(vec3(px - p, py - p, pz - p));
}

void main() {
#ifndef SHADOWMAP_PASS
	float g = vNorm.z * 0.5 + 0.5;

	outNormalMaterial = vec4(normalize(vWorldNorm) * 0.5 + 0.5, float(materialId) / 255.0);
	vec4 color = vec4(0.0);//colorDiffuse;

	if (materialId == 2) // object
	{
		vec3 face_normal;

		if (true)
		{
			vec3 dFdxPos = dFdx(vWorldPos.xyz);
			vec3 dFdyPos = dFdy(vWorldPos.xyz);
			face_normal = normalize(cross(dFdxPos, dFdyPos));
		}
		else
		{
			face_normal = vWorldNorm;
		}

		color += mod(vLocalPos.y * 2.0, 1.0) > 0.5 ? 0.4 : 0.0;

		int cell_tile_id = cellTileID(vLocalPos.xyz * 10.0);
		//vec3 cell_tile = cellTile(vLocalPos.xyz * 10.0);
		//vec3 normal = normalize(face_normal * 0.7 + float(cell_tile_id) * 0.3);
		vec3 normal = normalize(face_normal * 0.7 + voronoi_normal(vLocalPos.xyz * 10.0, 0.01) * 0.3);
		outNormalMaterial = vec4(normal * 0.5 + 0.5, materialId / 255.0);

		color += float(cell_tile_id) * 0.1;

	} 
	else if (materialId == 2) // sky
	{
		//texture = vec4(0.0, 1.0, mod(vLocalPos.x * 10.0, 1.0) > 0.5 ? 0.4 : 0.3, 1.0);
		color = vec4(exp(-vLocalPos.y * 15.0));
		outNormalMaterial = vec4(0.0, 0.0, 0.0, materialId / 255.0);
	}
	else if (materialId = 31)  // 31 - checkermap TODO: create registry
	{
		color.r += texture(s_texture_colorbuffer, vTexCoord.xy + vBrightness * 0.0005).r;
		color.g += texture(s_texture_colorbuffer, vTexCoord.xy).g;
		color.b += texture(s_texture_colorbuffer, vTexCoord.xy - vBrightness * 0.0005).b;

		{
			vec3 dFdxPos = dFdx(vWorldPos.xyz);
			vec3 dFdyPos = dFdy(vWorldPos.xyz);
			vec3 face_normal = normalize(cross(dFdxPos, dFdyPos));
			color.rgb *= max(vec3(0.0), 0.2 + dot(vec3(0.0, 0.0, 1.0), face_normal));
		}
		
		

		//color += texture(s_texture_colorbuffer, gl_FragCoord.xy/vec2(1920.0, 1080.0));
		//color.x += gl_FragCoord.x;
		//color += checker3D(vWorldPos.xyz * 0.1, vec4(1.4, 1.4, 1.4, 1.4), vec4(0.0)); 
	}
	else if (materialId == 29)  // 29 - stippled terrain TODO: create registry
	{
		color += (mod(vWorldPos.y * 0.03, 1.0) > 0.5 ? 0.4 : 0.0);
	}
	else if (materialId == 28)  // 28 - sky(box) TODO: create registry
	{
		color += (mod(vWorldPos.y * 0.03, 1.0) > 0.5 ? 0.4 : 0.0);
	}
	else if (materialId == 27)  // 27 - stipple verticaly (local) TODO: create registry
	{
		color += (mod(vLocalPos.y * 0.03, 1.0) > 0.5 ? 0.4 : 0.0);
	}
	else
	{
		color += texture(s_texture_colorbuffer, vTexCoord.xy);
		color += texture(s_texture_colorbuffer, gl_FragCoord.xy/vec2(1920.0, 1080.0));
		color.x += gl_FragCoord.x;
		//texture = vec4((mod(vLocalPos.x * 10.0, 1.0) > 0.5 ? 0.4 : 0.3));
	}
	//outAlbedo = vec4(vBrightness * 0.1); //color * (vec4(vBrightness * 1.0) - 0.4);
	outAlbedo = color * (vec4(vBrightness * vDistortionColor) - 0.3) * vDistortionColor.a;
#endif
}