#version 430

#ifndef SPIRV_ENABLED
#extension GL_NV_gpu_shader5 : enable
#endif

uniform sampler2DArray s_BlueNoise;

#include <shaders/materials/commons.glsl>
#include <shaders/materials/raytrace_buffers.glsl>
#include <shaders/materials/raytrace_commons.glsl>
#include <shaders/deferred/lighting_support.glsl>

#ifdef SPIRV_VULKAN

layout(location = 0) flat in int vOrientationIndex;
layout(location = 1) in vec3 vGridCoords;

layout(location = 5) flat in uint vTriIndex[3];
//layout(location = 6) flat in vec3 vTriCoords[3];
//layout(location = 3) flat in f16vec3 vTriNormal;   // this normal is for the scaled (nonuniform) coords, not real triangle normal

#else

flat in int vOrientationIndex;
in vec3 vGridCoords;

flat in uint vTriIndex[3];
//flat in vec3 vTriCoords[3];
flat in f16vec3 vTriNormal;   // this normal is for the scaled (nonuniform) coords, not real triangle normal


#endif

#ifndef SPIRV_VULKAN
layout(r32ui) uniform uimage3D imGridMarkers0;
layout(r32ui) uniform uimage3D imGridMarkers2;
#else
layout(r32ui) uniform uimage3D imGridMarkers0;
layout(r32ui) uniform uimage3D imGridMarkers2;
#endif

#include <shaders/materials/partition_commons.glsl>

// ------------------------------------------------------------------------------------------------------------------

vec3 calculate_lighting_world(LightProperties light, in vec3 pos, in vec3 normal, in vec3 light_pos, in float NdotL)
{
	float d = NdotL;
	if (d < 0.0)
		d = 0.0;
	return vec3(vec3(d) * light.diffuse.xyz);
}

// ------------------------------------------------------------------------------------------------------------------

// 1 : mark cell as used
// 2 : if the cell was unmarked then initilize linked list. consume some constant amount of indices from the buffer
// 3 : if the cell was initialized then calculate brick in the cell and insert new triangle into it

// orientation index is to transform triangle into original coors space (0, 1, 2 -> YZ, XZ, XY)

uint build_step_dir()
{
	if (vOrientationIndex == 0)
		return 1;
	else if (vOrientationIndex == 1)
		return 2;
	else // if (vOrientationIndex == 2)
		return 4;
}

ivec3 unpack_step_dir(uint step_dir)
{
	return ivec3(
		(step_dir & 1) != 0 ? 1 : 0,
		(step_dir & 2) != 0 ? 1 : 0,
		(step_dir & 4) != 0 ? 1 : 0
	);
}

void main()
{
	vec3 bbox_origin = in_bbox_data.bbox_raytrace_min.xyz;
	vec3 bbox_grid_size = in_bbox_data.grid_size_raytrace.xyz;

	vec3 vTriCoords[3];
	vTriCoords[0] = rt_get_vertex(vTriIndex[0]);
	vTriCoords[1] = rt_get_vertex(vTriIndex[1]);
	vTriCoords[2] = rt_get_vertex(vTriIndex[2]);

	vec3 s = -bbox_origin;
	vTriCoords[0] += s;
	vTriCoords[1] += s;
	vTriCoords[2] += s;
	
	vec3 f = vec3(1.0) / bbox_grid_size;
	vTriCoords[0] *= f;
	vTriCoords[1] *= f;
	vTriCoords[2] *= f;

#ifdef SPIRV_VULKAN
	vec3 vTriNormal = normalize(cross(vTriCoords[1] - vTriCoords[0], vTriCoords[2] - vTriCoords[1]));
#endif

	//vec3 pos = vGridCoords;

	uint cx;// = uint(gl_FragCoord.x);
	uint cy;// = uint(gl_FragCoord.y);
	uint cz;// = uint(gl_FragCoord.z * GRID_RES);

	vec3 gc = gl_FragCoord.xyz / vec3(1.0, 1.0, 1.0/GRID_RES) + vec3(0.0, 0.0, 0.0);
    //gc.xy += 0.5;

#ifdef SPIRV_VULKAN
    gc.y = 255.5 - gc.y;

	// adjust from GL to Vulkan
	gc.z = gc.z * 0.5 + GRID_RES / 2;
#if 0
	vec3 gc_alt = vGridCoords + vec3(0.0, -0.5, 0.0);
	//if (abs(gc_alt.x - gc.x) > 0.005)
	//	return;
	//if (abs(gc_alt.y - gc.y) > 0.005)
	//	return;

	
	//if (abs(gc_alt.z - gc.z) > 0.005)
	//	return;

	gc.x = gc_alt.x;
	gc.y = gc_alt.y + 0.5;
	gc.z = gc_alt.z;
#endif
#else
	vec3 gc_alt = vGridCoords + vec3(0.0, -0.5, 0.0);
	//gc_alt.z = 1.0 - gc_alt.z * 0.5;// + GRID_RES;
	
	//gc_at.z = gc.z * 0.5 + GRID_RES / 2;

	if (abs(gc_alt.z - gc.z) > 0.01)
		return;
#endif

	//if (gc.z < -0.0)
	//	return;
	//if (gc.z > GRID_RES)
	//	return;

	// triangle bbox

	ivec3 mi = ivec3(floor(min(vTriCoords[0], min(vTriCoords[1], vTriCoords[2]))));
	ivec3 ma = ivec3(ceil(max(vTriCoords[0], max(vTriCoords[1], vTriCoords[2]))));
	
    //mi = ivec3(0,0,0);
    //ma = ivec3(GRID_RES-1,GRID_RES-1,GRID_RES-1);

	mi = clamp(mi, ivec3(0), ivec3(GRID_RES-1));
	ma = clamp(ma, ivec3(0), ivec3(GRID_RES-1));

	uint stepDir = 0;
	uvec3 stepStart = uvec3(0);
	int steps;

	if (vOrientationIndex == 0)
	{
		cy = uint(gc.x);
		cz = uint(gc.y);
		cx = uint(gc.z);
		stepStart = uvec3(mi.x, cy, cz);
		steps = ma.x - mi.x;
	}
	else if (vOrientationIndex == 1)
	{
		cz = uint(gc.x);
		cx = uint(gc.y);
		cy = uint(gc.z);

		stepStart = uvec3(cx, mi.y, cz);
		steps = ma.y - mi.y;
	}
	else
	{
		cx = uint(gc.x);
		cy = uint(gc.y);
		cz = uint(gc.z);

		stepStart = uvec3(cx, cy, mi.z);
		steps = ma.z - mi.z;
	}

	stepDir = build_step_dir();

	// NOTE: Conservative raster is not enough to properly fill the grid... We need to 
	// Actually trace through the triangle in 'depth' also to make it fully conservative in all dimensions
	// TODO: Conservative raster actually makes it produce a bit too many faces. We might want to optimize this
	// by also calculating triangle distance

	int stepMin = -1;
	int stepCount = 0;

	for(int s = 0; s < steps; s++)
	{
		vec3 cellPos = vec3(stepStart + unpack_step_dir(stepDir) * s);
		vec3 cellSize = vec3(1.0);

		if (checkTriCellOverlap(vTriCoords[0], vTriCoords[1], vTriCoords[2], vTriNormal, cellPos + cellSize * 0.5, cellSize * 0.5))
		{
			if (stepMin == -1)
				stepMin = s;

			stepCount++;
		}
	};

	if (stepCount == 0)
		return;

	stepStart = stepStart + unpack_step_dir(stepDir) * stepMin;

	while(stepCount-- > 0)
	{
		uint ccx = stepStart.x;
		uint ccy = stepStart.y;
		uint ccz = stepStart.z;

		uint list_index = ccx + ccy * GRID_RES + ccz * GRID_RES * GRID_RES;
		link_list_push_value(list_index, gl_PrimitiveID);

		rt_write_grid_marker_high_res(imGridMarkers0, ivec3(ccx, ccy, ccz));
		rt_write_grid_marker_low_res(imGridMarkers2, ivec3(ccx, ccy, ccz) >> 2);
		//imageAtomicAdd(imGridMarkers0, ivec3(ccx, ccy, ccz), 1);
		//imageStore(imGridMarkers0, ivec3(ccx, ccy, ccz), ivec4(1));
		//imageStore(imGridMarkers2, ivec3(ccx/4, ccy/4, ccz/4), ivec4(1));

		stepStart += unpack_step_dir(stepDir);
	};

}
