#version 430

#include <shaders/materials/noise/noise3d.glsl>
#include <shaders/materials/flatterrain_deform.glsl>

in vec3 vPosition;
in vec3 vNormal;
in float vAttribute1;
in float vAttribute0;

//uniform mat4 mModelview;
uniform mat4 mModel;
uniform vec4 vModelview[3];
uniform vec4 vModelviewInvTrans[3];
uniform mat4 mProjection;

out vec3 vNorm;
out vec3 vWorldNorm;
out vec3 vLocalPos;
out vec4 vWorldPos;

out float vVtxTweenFactor;
out float vVtxNoiseFactor;
out vec3 vLocalNorm;

void main() {
	
	vec3 pos = vPosition;
	vec3 norm = vNormal;
	vec4 vPos;

	pos = pos; // do the deformation in the tess shader deform_terrain(pos, norm, vAttribute0);
	vLocalPos = pos;
	vLocalNorm = norm;

	vec4 vPos1 = vec4(pos, 1.0);
	vPos.x = dot(vModelview[0], vPos1);
	vPos.y = dot(vModelview[1], vPos1);
	vPos.z = dot(vModelview[2], vPos1);
	vPos.w = 1.0;
	vWorldPos = mModel * vPos1;
	vWorldNorm = (mModel * vec4(norm, 0.0)).xyz;

	vNorm.x = dot(vModelviewInvTrans[0].xyz, norm);
	vNorm.y = dot(vModelviewInvTrans[1].xyz, norm);
	vNorm.z = dot(vModelviewInvTrans[2].xyz, norm);
	vNorm = normalize(vNorm);

	gl_Position = mProjection * vPos;
	vVtxTweenFactor = vAttribute1;
	vVtxNoiseFactor = vAttribute0;
}