#version 430

#include <shaders/materials/commons.glsl>

layout(std140, row_major) uniform TransformParamsBuffer{
	EntityTransformParams transform_params;
};

// TODO: figure out why the fuck using vec3 here breaks shit... even when padded. does it enforce padding?
struct VtxData
{
	float px, py, pz;		// to not have to bother about alignment
	float nx, ny, nz;		// to fix frame orientation along the path
	float cr, cg, cb, ca;	// hijack color as source coords
	float pad2_1;
	float pad1_1;
};

layout (std140, binding = 0) buffer InVertexBuffer {
   VtxData verts[];
} indata;

struct Vertex
{
	vec3 vCoords;

	vec3 vNorm;
	vec3 vWorldNorm;
	vec3 vLocalPos;
	vec3 vWorldPos;
	vec4 vsColor;
};

layout(location = 0) out Vertex vtx_output;

// all the data layout setup in noisedeform.comp

void main() {
	
	// fetch input data
	int vidx = SYS_VertexIndex / 2;		// 2 verts per particle = line
	float offset_factor = float(SYS_VertexIndex & 1);
	//int vidx = SYS_InstanceIndex;
	vec3 vInstPosition = vec3(indata.verts[vidx].px, indata.verts[vidx].py, indata.verts[vidx].pz);
	vec3 vInstPrevPosition = vec3(indata.verts[vidx].cr, indata.verts[vidx].cg, indata.verts[vidx].cb);

	vInstPosition += (vInstPrevPosition - vInstPosition) * offset_factor * 55.0;
	//vec3ivNormal = vec3(indata.verts[vidx].nx, indata.verts[vidx].ny, indata.verts[vidx].nz);
	//ivColor = vec4(indata.verts[vidx].cr, indata.verts[vidx].cg, indata.verts[vidx].cb, indata.verts[vidx].ca);

	vec3 pos = vInstPosition;

	vtx_output.vLocalPos = pos;
	//vPos = mModelview * vec4(pos, 1.0);
	
	vec4 vPos1 = vec4(pos, 1.0);
	vec4 vPos;
	vPos.x = dot(transform_params.mModelView[0], vPos1);
	vPos.y = dot(transform_params.mModelView[1], vPos1);
	vPos.z = dot(transform_params.mModelView[2], vPos1);
	vPos.w = 1.0;
	vtx_output.vWorldPos = (transform_params.mModel * vPos1).xyz;

	vtx_output.vWorldNorm = vec3(1.0);
	vtx_output.vNorm = vec3(1.0);

	//vPos = vec4(vProjection.x * vPos.x, vProjection.y * vPos.y, dot(vProjection.zw, vPos.zw), -vPos.z);	
	vPos = transform_params.mProjection * vPos;
	gl_Position = vPos;

	//float bri = clamp(0.5 + (vAttribute1 - 0.5) * 100.0, 0.0, 1.0);
	//brightness = vBrightness;
	//overbright = bri;

	//vWorldPos = mModel * vec4(vPos1.xyz, 1.0);
	vtx_output.vCoords = vPos.xyz;
	vtx_output.vsColor = vec4(indata.verts[vidx].ca);
}