#version 460

#include <shaders/materials/commons.glsl>

layout(std430) buffer VTXCoords {
	float coords[];
} vtx_coords;

vec3 vtx_coords_load(uint idx)
{
	return vec3(vtx_coords.coords[idx * 3 + 0], vtx_coords.coords[idx * 3 + 1], vtx_coords.coords[idx * 3 + 2]);
}

layout(std430) buffer VTXUV0 {
	float uv0[];
} vtx_uv0;

vec2 vtx_uv0_load(uint idx)
{
	return vec2(vtx_uv0.uv0[idx * 2 + 0], vtx_uv0.uv0[idx * 2 + 1]);
}

layout(std140, row_major) uniform TransformParamsBuffer{
	EntityTransformParams transform_params;
};

out vec2 vTexcoord0;

void main() {
	gl_Position = transform_params.mProjection * transform_params.mModelView * vec4(vtx_coords_load(SYS_VertexIndex), 1.0);
	gl_Position.zw = vec2(0.9999, 1.0);	// only blit it to clear portion of a display
	vTexcoord0.xy = vtx_uv0_load(SYS_VertexIndex).xy;
}
