#version 300 es

precision mediump float;
uniform mediump float stepx; // bind:/var/global/stepx
uniform mediump float stepy;
uniform mediump float scale;
uniform mediump vec4 color;
uniform mediump float threshold;

// we want 11 samples but only 8 varyings available...
in vec2 vTexcoord0;
in vec2 vTexcoord0_p1;
in vec2 vTexcoord0_p2;
in vec2 vTexcoord0_p3;
in vec2 vTexcoord0_p4;
in vec2 vTexcoord0_p5;
in vec2 vTexcoord0_m1;
in vec2 vTexcoord0_m2;

out vec4 gl_FragColor;

uniform sampler2D s_texture0;

void main() {
	vec2 off = vec2(stepx, stepy) * scale; // TODO: make it vec2 uniform...
	vec4 c = texture2D(s_texture0, vTexcoord0);
	c += texture2D(s_texture0, vTexcoord0_p1) * 0.95;
	c += texture2D(s_texture0, vTexcoord0_p2) * 0.8;
	c += texture2D(s_texture0, vTexcoord0_p3) * 0.48;
	c += texture2D(s_texture0, vTexcoord0_p4) * 0.33;
	c += texture2D(s_texture0, vTexcoord0_p5) * 0.2;
	c += texture2D(s_texture0, vTexcoord0_m1) * 0.95;
	c += texture2D(s_texture0, vTexcoord0_m2) * 0.8;
	c += texture2D(s_texture0, vTexcoord0 - off * 3.0) * 0.48;
	c += texture2D(s_texture0, vTexcoord0 - off * 4.0) * 0.33;
	c += texture2D(s_texture0, vTexcoord0 - off * 5.0) * 0.2;	
	
	float sum = 1.0 + (0.95+0.8+0.48+0.33+0.2)*2.0;
	c = c - threshold * sum;

	c = c * (color / sum);
	gl_FragColor = c;
		
}