# version 440

#define C_FLD 0
#define C_SRC 1
#define C_BND 2
// palette
vec4 color(float t, int k)
{
	const int siz = 12;
	float coltab[] = {
	0.5, 0.5, 0.5, 0.5, 0.65, 0.5, 1.0, 1.0, 1.0,  0.00, 0.33, 0.67,
	0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 1.0, 1.0, 1.0, 0.00, 0.10, 0.20 ,//!!
	0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 1.0, 1.0, 1.0, 0.30, 0.20, 0.20 ,//good
	0.5, 0.5, 0.5, 0.5, 0.5, 0.5,  1.0, 1.0, 0.5,  0.80, 0.90, 0.30,
	0.5, 0.5, 0.5, 0.5, 0.5, 0.5,  1.0, 0.7, 0.4,  0.00, 0.15, 0.20,//gld
	0.5, 0.5, 0.5, 0.5, 0.5, 0.5,  2.0, 1.0, 0.0,  0.50, 0.20, 0.25, // nice bumpmap
	0.8, 0.5, 0.4, 0.2, 0.4, 0.2,  2.0, 1.0, 1.0,  0.00, 0.25, 0.25};
	int of = siz * k;   // offset
	vec4 col;
	col.r = coltab[0 + of] + coltab[3 + of] * cos(2 * 3.1416 * (coltab[6 + of] * t + coltab[9 + of]));
	col.g = coltab[1 + of] + coltab[4 + of] * cos(2 * 3.1416 * (coltab[7 + of] * t + coltab[10 + of]));
	col.b = coltab[2 + of] + coltab[5 + of] * cos(2 * 3.1416 * (coltab[8 + of] * t + coltab[11 + of]));
	col.a = 1;
	return col;
}

struct Particle
{
	vec4 pos;
	vec4 col;
};

layout(rgba8, binding = 4) uniform image2D img; 

layout(binding = 16) buffer dcE { float E [  ]; };
layout(binding = 17) buffer dcEnew { float Enew [  ]; };
layout(binding = 18) buffer dcU { float U [  ]; };
layout(binding = 19) buffer dcF { int F [  ]; };
layout(binding = 20) buffer particle { Particle p []; };
layout(local_size_x = 1000, local_size_y = 1, local_size_z = 1) in;

float per(float x, int nx)      // periodic bnd's
{
	if (x < 0) x = nx - 1;
	else
	if (x > nx - 1) x = 0;
	return x;
}


uniform int NX;
uniform int NY;
uniform int NZ;

uniform float alpha1 = 0.0025;
uniform float alpha2 = 0.15;
uniform float detectE1 = 0.3;

void main()
{
	int idx = int(gl_GlobalInvocationID.x);
	float px = p[idx].pos.x;
	float py = p[idx].pos.y;
	float pz = p[idx].pos.z;

	px = per(px, NX);
	py = per(py, NY);
	pz = per(pz, NZ);
	int i = int(px);
	int j = int(py);
	int k = int(pz);
	int idxF = i + j * NX + k * NX * NY;

	vec4 col;
	//if(tt<200.0)
	//{
	//col = color(0.25 - 132.0 * (0.000003 * (E[idxF])));

	if (345 * abs(Enew[idxF]) > 0.3)
	{
		col = color(245 * abs(Enew[idxF]), 2);
		col.a = alpha1;
	}
	else
		col = vec4(0.0, 0, 0, 0.0);

	if (i > NX / 2)
	{
		//if (Enew[idxF] > 0.0001)
		if (345 * abs(Enew[idxF]) > 0.05) // detectE1)
		{
			col = color(145 * abs(Enew[idxF]), 1);
			//else
			//else
			//col = vec4(0.0, 0, 0, 0.0);
			//col = col * 30.0;
			//col.a = 1.0;
			col.a = alpha2*0.6;
		}
		else
			col.a = 0.0;
	}

	

	//vec2 particle = p2[i].pos.xy;
	p[idx].pos.x = px;
	p[idx].pos.y = py;
	p[idx].pos.z = pz;
	p[idx].col = col;

	//if (F[idxF] == C_BND && i == NX / 2)
	//	p[idx].col = vec4(0.32, 0.43, 0.5, 0.05);


}

