# version 440
layout(binding = 0) buffer dcA { int A [  ]; };
layout(binding = 1) buffer dcB { int B [  ]; };
layout(rgba8, binding = 2) uniform writeonly image2D img;
layout(rgba8, binding = 3) uniform image2D img2;
layout(rgba8, binding = 4) uniform image2D img3;
layout(local_size_x = 10, local_size_y = 10, local_size_z = 1) in;

uniform int NX;
uniform int NY;
uniform int c;
uniform float demotime=0;
uniform int scena = 0;

void main()
{
	//vec4 col2 = imageLoad(img3, ivec2(gl_GlobalInvocationID.xy));       // pixel from image
	int i = int(gl_GlobalInvocationID.x);
	int j = int(gl_GlobalInvocationID.y);
    vec2 q = vec2(i/float(NX), j/float(NY));
    
    float d;
    float colmnoznik = 1.0;

    if (scena == 1)     // planar
    {
        q.x -= 0.5;
        q.y -= 0.25 + 1.435 * sin(demotime * 0.25);
        vec2 uv;
        d = abs(q.y + 0.8);                     //+0.2*sin(iTime));
        uv = vec2(q) / (d);                                   ///sin(phi);
        uv.y -= demotime * 0.05;
        q = uv + vec2(demotime * 0.75, demotime * 0.35);
        q *= 0.6;
        colmnoznik = (0.5 + 2.0 * d);
    }


    if (scena == 3)     // tunnel
    {
        q.y *= 0.77;
        vec2 c = 3*vec2(0.2 * sin(demotime*0.2), 0.23 * cos(demotime*0.5));
        q = q + c;
        float a = atan(q.y / q.x);
        float d = length(q);
        vec2 uv = vec2(0.3 / d + 0.2 * demotime, a / 3.14159);
        q = uv;
        colmnoznik = d*d*3.0;
    }

    if (scena == 4)     // star->ball
    {
        /* vec2 c = vec2(0.2 * sin(demotime), 0.23 * cos(demotime));
         q = q - vec2(0.5, 0.5);
         float d2 = length(q);
         q = (q) / d2;
         q = q + c;

         colmnoznik = 1.0;// (1.2 + 1.0 * d2);
         q *= 0.5;*/

        vec2 c = vec2(.45 * sin(demotime * 1.0), .353 * cos(demotime * 1.0));
        vec2 uv = q - vec2(0.5, 0.5);
        uv += c * 0.07;
        uv.y *= 0.66;
        float d = length(uv);
        vec2 uv1;
        float R = 0.17 + 0.05 * sin(demotime * 2.2);
        if (d > R) uv1 = (uv) / (d * d);
        if (d < R) uv1 = (1.5 / R) * 1.5 * (uv) * (1.0 + pow(d, 0.5));
        q = 0.1*uv1 + c;
        if (d < R) colmnoznik= (1.0 - d / R) * 3.0;
        if (d > R) colmnoznik= (1.0 - (2.0 - d / R) * 1.0);
    }

    q.x = mod(q.x, 1);
    q.y = mod(q.y, 1);    
    vec4 col = imageLoad(img3, ivec2(q * vec2(NX, NY)));
       
    col *= colmnoznik;
    //col += 0.04*(1.0+0.2*sin(cos(40*demotime + 10.35) + 0.33));
    imageStore(img, ivec2(gl_GlobalInvocationID.xy), col);
}

