; 	Christmas 2022 Star/snowflake size compo.     Entry by Bushy555.
;	For the VZ200/VZ300/Laser210/Laser310 Z80 8-bit platform.
;
;	The VZ/Laser uses the 6847 video chip, which, in text mode, only supports 32 chars wide by 16 chars height.
;	Therefore the first few lines of the 17 char height snowflake/star symbol scrolls off the screen.
;
;	6.ASM_HIRES_beauty
;
; 	Assemble with PASMO assembler.
;		> PASMO VZENTRY.ASM VZENTRY.VZ
;
;

	org	$8000-24

	defb	'VZF1'			; HEADER: vzmagic       	[04]
	defb	'FILENAME.VZ      '    	; HEADER: filename      	[17]
	defb	$F1			; HEADER: Filetype      	[01]
	defw	$8000			; HEADER: Start address 	[02]

	org	$8000			; *** Start of program execution at $8000.

	ld	a, 8
	ld	($6800), a
	di

loop0:	

random1:ld 	a, r			; Get 0-3 for table.
	rrca
	rrca
	neg
seed1	equ 	$+1
	xor 	0
	rrca
	ld 	(seed1), a
	and 	$3   					; value range 0..3



	cp	1
	jr	z, yellow
	cp 	2
	jr	z, blue
	cp	3
	jr	z, red
	jr	loop0
yellow:	ld	hl, table1
	ld	ixh, %11111111
	jr	cont0
blue:	ld	hl, table2
	ld	ixh, %01010101
	jr	cont0
red:	ld	hl, table3
	ld	ixh, %10101010
cont0:	call	random2

	; de = random output destination


	ld	b, 17
loopa:	push	bc
	ld	b, 5
loopb:	ld	a, (hl)

	
;	cp	0
;	jr	nz, write1
;	ld	c, a
;	ld	a, ixh
;	or	c
;	ld	a, (de)
;	and	c
	

write1:	ld	(de), a
	inc	de
	inc	hl
	djnz	loopb
	push	hl
	ld	hl, 32-5
	add	hl, de
	push	hl
	pop	de

	pop	hl
	pop	bc
	djnz	loopa

	LD 	hl,0x6800
sync2:	BIT 	7,(hl)			; fancy wait retrace.
	jr	NZ,sync2

	call	display2

	ld	hl, $9000
	ld	de, $7000
	ld	bc, 2048
	ldir

	jr	loop0

display2:
	ld	de, $9000 + 8*32+8
	ld	hl, bigstar
	ld	b, 51
d2loopa:push	bc
	ld	b, 14
d2loopb:ld	a, (hl)
	cp	255
	jr	nz, write3

write2:	ld	a,(de)
write3:	ld	(de), a
	inc	de
	inc	hl
	djnz	d2loopb
	push	hl
	ld	hl, 32-14
	add	hl, de
	push	hl
	pop	de
	pop	hl
	pop	bc
	djnz	d2loopa
	ret




; ===================================================
random2:			
;
;	Returns DE as a random number between ~$7000 and $7FFF
;       (Somewhere anywhere in the Video RAM)
;	de:   $7000 + (RND(53)*32) + RND(27)

; ===================================================

	push	bc			; get Y
	push	hl
	ld 	a, r
	rrca
	rrca
	neg
seed3:	equ 	$+1
	xor 	0
	rrca
	ld 	(seed3), a
;	or	16
	and 	63-10   					; value range 0..63

	ld	b, a
	ld 	a, r			; get X
	rrca
	rrca
	neg
seed4:	equ 	$+1
	xor 	0
	rrca
	ld 	(seed4), a
;	or	5
;	and	32-5			; value range 0..27

	ld	ixl, a
	ld	d, 32
	ld	h, b


mull:	; Multiply h by d and return in hl.


imul   	ld 	e,d              ; HL = H * D
       	ld 	c,h              ; make c first multiplier.
imul0  	ld 	hl,0             ; zeroise total.
       	ld 	d,h              ; zeroise high byte.
       	ld 	b,8              ; repeat 8 times.
imul1  	rr 	c                ; rotate rightmost bit into carry.
       	jr 	nc,imul2         ; wasn't set.
       	add 	hl,de           ; bit was set, so add de.
       	and 	a               ; reset carry.
imul2  	rl 	e                ; shift de 1 bit left.
       	rl 	d
       	djnz 	imul1          ; repeat 8 times.

	ld	a, l
	add	a, ixl
	ld	l, a
	ld	de, $9000
	add	hl, de
	push	hl
	pop	de
	pop	hl
	pop	bc
	ret







table1:	db %11111111,%11111101,%11111111,%11111101,%11111111	; YELLOW on RED
	db %11111111,%11111101,%01111111,%11110101,%11111111
	db %11111111,%11111101,%01011111,%11010101,%11111111
	db %11111111,%11111101,%01010111,%01010101,%11111111
	db %11111101,%01010101,%01010101,%01010101,%01010101
	db %11111111,%01010101,%01010101,%01010101,%01010111
	db %11111111,%11010101,%01010101,%01010101,%01011111
	db %11111111,%11110101,%01010101,%01010101,%01111111
	db %11111111,%11111101,%01010101,%01010101,%11111111
	db %11111111,%11110101,%01010101,%01010101,%01111111
	db %11111111,%11010101,%01010101,%01010101,%01011111
	db %11111111,%01010101,%01010101,%01010101,%01010111
	db %11111101,%01010101,%01010101,%01010101,%01010101
	db %11111111,%11111101,%01010111,%01010101,%11111111
	db %11111111,%11111101,%01011111,%11010101,%11111111
	db %11111111,%11111101,%01111111,%11110101,%11111111
	db %11111111,%11111101,%11111111,%11111101,%11111111


table2:	db %01010101,%01010110,%01010101,%01010110,%01010101	; BLUE on YELLOW
	db %01010101,%01010110,%10010101,%01011010,%01010101
	db %01010101,%01010110,%10100101,%01101010,%01010101
	db %01010101,%01010110,%10101001,%10101010,%01010101
	db %01010110,%10101010,%10101010,%10101010,%10101010
	db %01010101,%10101010,%10101010,%10101010,%10101001
	db %01010101,%01101010,%10101010,%10101010,%10100101
	db %01010101,%01011010,%10101010,%10101010,%10010101
	db %01010101,%01010110,%10101010,%10101010,%01010101
	db %01010101,%01011010,%10101010,%10101010,%10010101
	db %01010101,%01101010,%10101010,%10101010,%10100101
	db %01010101,%10101010,%10101010,%10101010,%10101001
	db %01010110,%10101010,%10101010,%10101010,%10101010
	db %01010101,%01010110,%10101001,%10101010,%01010101
	db %01010101,%01010110,%10100101,%01101010,%01010101
	db %01010101,%01010110,%10010101,%01011010,%01010101
	db %01010101,%01010110,%01010101,%01010110,%01010101


table3:	db %10101010,%10101011,%10101010,%10101011,%10101010	; RED on BLUE
	db %10101010,%10101011,%11101010,%10101111,%10101010
	db %10101010,%10101011,%11111010,%10111111,%10101010
	db %10101010,%10101011,%11111110,%11111111,%10101010
	db %10101011,%11111111,%11111111,%11111111,%11111111
	db %10101010,%11111111,%11111111,%11111111,%11111110
	db %10101010,%10111111,%11111111,%11111111,%11111010
	db %10101010,%10101111,%11111111,%11111111,%11101010
	db %10101010,%10101011,%11111111,%11111111,%10101010
	db %10101010,%10101111,%11111111,%11111111,%11101010
	db %10101010,%10111111,%11111111,%11111111,%11111010
	db %10101010,%11111111,%11111111,%11111111,%11111110
	db %10101011,%11111111,%11111111,%11111111,%11111111
	db %10101010,%10101011,%11111110,%11111111,%10101010
	db %10101010,%10101011,%11111010,%10111111,%10101010
	db %10101010,%10101011,%11101010,%10101111,%10101010
	db %10101010,%10101011,%10101010,%10101011,%10101010

bigstar:db %11111111,%11111111,%11111111,%11111100,%00001111,%11111111,%11111111,%11111111,%11111111,%11111100,%00001111,%11111111,%11111111,%11111111	
	db %11111111,%11111111,%11111111,%11111100,%00001111,%11111111,%11111111,%11111111,%11111111,%11111100,%00001111,%11111111,%11111111,%11111111	
	db %11111111,%11111111,%11111111,%11111100,%00001111,%11111111,%11111111,%11111111,%11111111,%11111100,%00001111,%11111111,%11111111,%11111111	
	db %11111111,%11111111,%11111111,%11111100,%00000000,%00111111,%11111111,%11111111,%11111111,%00000000,%00001111,%11111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%11111100,%00000000,%00111111,%11111111,%11111111,%11111111,%00000000,%00001111,%11111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%11111100,%00000000,%00111111,%11111111,%11111111,%11111111,%00000000,%00001111,%11111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%11111100,%00000000,%00000000,%11111111,%11111111,%11000000,%00000000,%00001111,%11111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%11111100,%00000000,%00000000,%11111111,%11111111,%11000000,%00000000,%00001111,%11111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%11111100,%00000000,%00000000,%11111111,%11111111,%11000000,%00000000,%00001111,%11111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%11111100,%00000000,%00000000,%00000011,%11110000,%00000000,%00000000,%00001111,%11111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%11111100,%00000000,%00000000,%00000011,%11110000,%00000000,%00000000,%00001111,%11111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%11111100,%00000000,%00000000,%00000011,%11110000,%00000000,%00000000,%00001111,%11111111,%11111111,%11111111
	db %11111100,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00001111
	db %11111100,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00001111
	db %11111100,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00001111
	db %11111111,%11110000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000011,%11111111
	db %11111111,%11110000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000011,%11111111
	db %11111111,%11110000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000011,%11111111
	db %11111111,%11111111,%11000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%11111111,%11111111
	db %11111111,%11111111,%11000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%11111111,%11111111
	db %11111111,%11111111,%11000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%11111111,%11111111
	db %11111111,%11111111,%11111111,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%11111100,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000011,%11111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%11111100,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000011,%11111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%11111100,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000011,%11111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00111111,%11111111,%11111111
	db %11111111,%11111111,%11000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%11111111,%11111111
	db %11111111,%11111111,%11000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%11111111,%11111111
	db %11111111,%11111111,%11000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%11111111,%11111111
	db %11111111,%11110000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000011,%11111111
	db %11111111,%11110000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000011,%11111111
	db %11111111,%11110000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000011,%11111111
	db %11111100,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00001111
	db %11111100,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00001111
	db %11111100,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00001111
	db %11111111,%11111111,%11111111,%11111100,%00000000,%00000000,%00000011,%11110000,%00000000,%00000000,%00001111,%11111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%11111100,%00000000,%00000000,%00000011,%11110000,%00000000,%00000000,%00001111,%11111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%11111100,%00000000,%00000000,%00000011,%11110000,%00000000,%00000000,%00001111,%11111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%11111100,%00000000,%00000000,%11111111,%11111111,%11000000,%00000000,%00001111,%11111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%11111100,%00000000,%00000000,%11111111,%11111111,%11000000,%00000000,%00001111,%11111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%11111100,%00000000,%00000000,%11111111,%11111111,%11000000,%00000000,%00001111,%11111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%11111100,%00000000,%00111111,%11111111,%11111111,%11111111,%00000000,%00001111,%11111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%11111100,%00000000,%00111111,%11111111,%11111111,%11111111,%00000000,%00001111,%11111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%11111100,%00000000,%00111111,%11111111,%11111111,%11111111,%00000000,%00001111,%11111111,%11111111,%11111111
	db %11111111,%11111111,%11111111,%11111100,%00001111,%11111111,%11111111,%11111111,%11111111,%11111100,%00001111,%11111111,%11111111,%11111111	
	db %11111111,%11111111,%11111111,%11111100,%00001111,%11111111,%11111111,%11111111,%11111111,%11111100,%00001111,%11111111,%11111111,%11111111	
	db %11111111,%11111111,%11111111,%11111100,%00001111,%11111111,%11111111,%11111111,%11111111,%11111100,%00001111,%11111111,%11111111,%11111111	
	