CHROUT=		$f1ca			; KERNAL: output character to screen
NEWLINE=	$aad7			; BASIC: newline to current device

XABS=		$fb
YABS=		$fc

.org $07ff
		.word	$0801		; load address (2 bytes)
		.word	$080b		; BASIC stub (12 bytes)
		.word	2022
		.byte	$9e
		.byte	"2061",$0,$0,$0

		ldy	#$f7		; -8, in one's complement
mainloop:	ldx	#$f7
rowloop:	txa
		bpl	rightside
		eor	#$ff		; X to absolute value
rightside:	sta	XABS
		tya
		bpl	bottompart
		eor	#$ff		; Y to absolute value
bottompart:	sta	YABS
		sec
		sbc	XABS		; calculate diff of X and Y
		bcc	diffok		; we want negative values, so
		eor	#$ff		; invert when positive.
diffok:		sbc	#$fb		; |X-Y| < 5? (consistent result with
		bmi	isspace		; carry for one's complement)
		lda	#4		; for the corners, either |X| or |Y|
		cmp	YABS		; must be > 4 to be a space
		bcs	isstar
		cmp	XABS
isstar:		lda	#$2a
		bcs	doout
isspace:	lda	#$20
doout:		jsr	CHROUT
nextchr:	inx
		beq	nextchr		; skip "+0" in one's complement for X
		cpx	#9		; line done when reaching +9
		bne	rowloop
		jsr	NEWLINE
next:		iny
		beq	next		; skip "+0" in one's complement for Y
		cpy	#9		; all done when reaching +9
		bne	mainloop
		rts
