; STAR-SYS265
; Printing the VC3 2022 star on a Commodore 64
; by Wil
; December 2022
;
; Size: 63 Byte - 2 Byte load adress = 61 Byte program
;
; compile with 
; cl65 star-sys265.s -C c64-asm.cfg --start-addr $F7 -o star-sys265.prg
; load with LOAD "STAR-SYS265",8,1
; start with SYS 265

.SETCPU "6502X"		;enable mnemonics for unintented opcodes
.org $f7

data1:
	.byte $50-1	;first number is the spaces, second number the stars
	.byte $50-2
	.byte $50-3
	.byte $50-4
	.byte $10-8
	.byte $20-6
	.byte $30-4
	.byte $40-2
	.byte $50-1

data2:
	.byte $80-1
	.byte $60-2
	.byte $40-3
	.byte $20-4
	.byte $10-9
	.byte $10-9
	.byte $10-9
	.byte $10-9
	.byte $10-8

main:
	ldx data1,y
	jsr print_spc_n_stars
	ldx data2,y
	jsr print_spc_n_stars
	jsr $aad7	;output newline character 
	iny
	cpy #$09
overwrite=*+1
	bne main
	stx overwrite	;X is 0 after calling $aad7
	dey
	dey
	bpl main
exit_rts:
	rts

print_spc_n_stars=lp1_entry
outlp1:
	inc $d3		;inc current cursor row = crsr right
lp1_entry:
	txa
	axs #$10	;decrement high nibble of X, only possible if X==A
	bpl outlp1
outlp2:
	lda #$2a
	jsr $ffd2
	inx
	bmi outlp2
	rts


