	.title Little Xmas Star by Stanislav Maslovski, Dec 2022.
	.sbttl This program uses modular arithmetics. Works both in 64 and 32 columns.

	; This program has to be loaded from tape ("M" directive) and run ("S" directive)
	; from within the monitor of BK0010 home computer after a fresh restart.
	; If you don't have the hardware, you can use an emulator (e.g. BkEmu on Android).
	; The program is loaded into a screen line in the system message area.
	; This line is cleared by the monitor upon restart and remains untouched.
	; When started from BK0010's monitor, r5 = program's start address, flags = 0.
	; The whole code is only 30 bytes long, which is 14 instructions + 1 word of data.

	.asect
	.=40040
star:
	.word	13.+<400*7>	; these data are seen by CPU as instruction BLE, harmless
	movb	(r5)+, r1	; get number 13 for the x counter limit
1$:
	mov	r1, r3		; initialize the y counter
2$:
	movb	(r5), r2	; get number 7 and ...
	movb	pc, r0		;  ... (here, PC has the code of '*' in low byte) ...
	add	r3, r2		;   ... add 7 to the y-counter value
3$:
	add	pc, r1		; here, PC has number 46 in low byte. The x arithmetics
	emt	24		;   is effectively modulo 64 or 32 due to screen folding.
	emt	16		;  emt 24 sets cursor position to (r1,r2)
				;  emt 16 prints out a char in r0
	neg	r1
	bmi	3$

	neg	r2		; the y arithmetics is effectively modulo 24
	bmi	3$		;   for the same reason.

	sob	r3, 2$
	sob	r1, 1$

	; Beyond this point the CPU hits 0s (the code of HALT instruction).
	; The program terminates and returns to monitor's prompt.

	.end star
