;
; Copyright © 2022 Antonio A. Carrillo "Peluko" (http://github.com/peluko)
;
; This work is free. You can redistribute it and/or modify it under the
; terms of the Do What The Fuck You Want To Public License, Version 2,
; as published by Sam Hocevar. See http://www.wtfpl.net/ for more details.
;
;
;        DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE 
;                    Version 2, December 2004 
;
; Copyright (C) 2004 Sam Hocevar <sam@hocevar.net> 
;
; Everyone is permitted to copy and distribute verbatim or modified 
; copies of this license document, and changing it is allowed as long 
; as the name is changed. 
;
;            DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE 
;   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION 
;
;  0. You just DO WHAT THE FUCK YOU WANT TO.
;
		DEVICE	NOSLOT64K
		SLDOPT	COMMENT WPMEM,LOGPOINT,ASSERTION

LF		equ	0Ah
CR		equ	0Dh

CHPUT		equ	00A2h	; BIOS output char
INIT32		equ	006Fh

PAGE_SIZE	equ	4000h	; 16kB

LINL32		equ	0F3AFh

		org	4000h

; ### ROM header ###

ROMSTART	db	"AB"		; ID para ROM
		dw	INIT
		dw	0
		dw	0
		dw	0
		dw	0,0,0	; Reserved

INIT
		; SCREEN 1
		ld	a,32
		ld	(LINL32),a
		call	INIT32

PRINTSTAR	ld	hl,STARDATA
		ld	d,DATAEND-STARDATA

10
		ld	c,(hl)
		ld	a,d
		cp	5
		jr	c,20f
		cp	14
		jr	30f
20		ccf

30		ld	b,9
40		ld	a,' '
		rl	c
		jr	nc,45f
		add	a,10
		scf
45		call	CHPUT
		djnz	40b

		ld	b,8
50		ld	a,' '
		rr	c
		jr	nc,55f
		add	a,10
55		call	CHPUT
		djnz	50b

		ld	a,CR
		call	CHPUT
		ld	a,LF
		call	CHPUT

		inc	hl
		dec	d
		jr	nz,10b

PAUSE		jr	PAUSE

STARDATA	db	08h,0Ch,0Eh,0Fh,0FFh,7Fh,3Fh,1Fh
		db	0Fh
		db	1Fh,3Fh,7Fh,0FFh,0Fh,0Eh,0Ch,08h
DATAEND

		SAVEBIN	"star.rom",4000h,DATAEND-ROMSTART

