screenMapLB     = $33           ; Low byte of screen memory map
screenMapHB     = $34           ; High byte of screen memory map
up?             = $FB           ; Drawing upper part or lower part of the star
nChars          = $FC           ; Number of remaining times the current char will be drawn
colorMapLB      = $F3           ; Low byte of screen color map
colorMapHB      = $F4           ; High byte of screen color map
charToDraw      = $FF           ; Next char to be drawn (32-SPACE / 42-ASTERISK). Starts with 32

*=4096                          ; 10 SYS4109

        BYTE    $00, $0B, $12, $0A, $00, $9E, $34, $31, $30, $39, $00, $00, $00

; To save some bytes, I have chosen, for 'variables', memory locations with the right values at startup. This is the 
; case for screenMapLB/HB ($00/$1E), up? (0) and charToDraw (32). Regarding colorMapHB/LB, while it also has the rights 
; values, after Loading and running, it points to second mamoery page, so will decrease it before starting drawing
; Don't need to initialize CPU registers (A,X,Y) either, since they are already zero after SYS call

*=4109
        DEC colorMapHB          ; After loading the PRG it points to 2nd memory page so decrease it

changingChar
        LDA halfStarMap,X       ; Read number of chars (spaces or asterisks) to be drawn
        BNE sameDirection       ; Anything different to 0 means we don't have to change direction
        LDA #1                  ; If we read a '0' in the number of chars, we set up? to 1 to indicate 
        STA up?                 ; we'll change direction and start drawing lower part of the start by reading 
        DEX                     ; halfStarMap from bottom to top. We decrease 'X' twice to 'jump' the zero just
        DEX                     ; read and the last line of the start we had drawn (that is only drawn once)
        BNE changingChar        ; BNE, here, is equivalent to JMP (X here will never be zero) and saves 1 byte

sameDirection
        STA nChars              ; Store number of chars to be drawn

mainLoop
        LDA #6                  ; Foreground color (Blue)
        STA (colorMapLB),Y      ;
        LDA charToDraw          ; Draw the char
        STA (screenMapLB),Y     ;
        INY                     ; Increase 'Y' (used as a pointer from memory at xxLB/xxHB)
        BNE sameMemoryPage      ; If Y <> 0, continue with next screen location
        INC screenMapHB         ; When Y reaches 0 => change memory page for screen and color maps
        INC colorMapHB          ;

sameMemoryPage
        DEC nChars              ; Decrease number of remaining chars
        BNE mainLoop            ; If not zero, continue

        EOR #%00001010          ; When nChars reaches zero, change 32->42 (or 42->32) and store the new 
        STA charToDraw          ; value in charToDraw
        
        INX                     ; 
        LDA up?                 ; Depending if we are going down or going up, we'll 
        BEQ changingChar        ; need to increase or decrease X. So, we always increase once and, 
        DEX                     ; if going up (up? = 1), we'll decrease twice. 
        DEX                     ;
        BMI end                 ; If after decreasing, we are below zero -> we have finished
        BPL changingChar        ; If not finished, continue with next group of chars

end
        BMI end                 ; Stay in a loop to avoid 'READY' message to destroy the star

; Definition of star symbol. Alternatively, number of spaces/asterisks. Zero to change direction
; Initial number of spaces (72) allows to center vertically/horizontally
halfStarMap
        BYTE 72,1,7,1,13,2,5,2,13,3,3,3,13,4,1,4,9 
        BYTE 17,6,15,8,13,10,11,12,9,0
