comment +
Vintage Computing Christmas Challenge 2022

see https://logiker.com/Vintage-Computing-Christmas-Challenge-2022

Target: print following star with minimal executable code as possible

    *       *
    **     **
    ***   ***
    **** ****
*****************
 ***************
  *************
   ***********
    *********
   ***********
  *************
 ***************
*****************
    **** ****
    ***   ***
    **     **
    *       *


    +

.model tiny  		  	  ; generate .com program
.code			  	        ; code segment
org   100h		  		  ; code starts at offset 100h	

main proc near                  ; main procedure
      mov   si,offset table     ; point to table start
      mov   bh,9                ; starting with 9 rows
      
rows:
      lodsw                     ; load 16 bits and increment source register
      mov   bl,16               ; 16 bits to be processed 
      
bitloop:
      shl   ax,1                ; shift left 1 bit
      push  ax                  ; save bit line register
      jc    asterisk            ; if carry flag is set, jump
      
      mov   dl," "              ; set space
      jmp   print               ; go to print section
      
asterisk:
      mov   dl,"*"              ; set asterisk
      
print:
      mov   ah,02h              ; display character
      int   21h                 ; 
      pop   ax                  ; restore bit line register
      dec   bl                  ; decrement bit counter  
      jnz   bitloop             ; process next bit

      cmp   bh,5                ; line 5 has extra character
      jnz   crlf
      
      mov   ah,02h              ; print additional asterisk - dl still has "*" value
      int   21h
      
crlf:
      mov   ah,02h
      mov   dl,10               ; line feed
      int   21h      
      
      dec   bh                  ; decrement line counter
      jnz   rows                ; process next row

      cmp   si,offset table - 2 ; is pointer before table address?
      jz    done                ; if so, leave program
      
      std                       ; change direction - lodsw decrements from now on
      sub   si,4                ; set pointer back
      mov   bh,8                ; 8 more lines to be printed - table is processed backwards now
      jmp   rows                

done:    
      ret                       ; exit program      	        
      
main endp 

comment +
        table contains 2 bytes (1 dw) per line
        bit are 0 for space, 1 for asterisk
        +

table    dw  00000100000001000b
         dw  00000110000011000b
         dw  00000111000111000b
         dw  00000111101111000b
         dw  01111111111111111b
         dw  00111111111111111b
         dw  00011111111111110b
         dw  00001111111111100b
         dw  00000111111111000b
         
end main
