; Commodore MAX Machine Christmas Star by GeirS, 2022-12-22
; Size: 128 bytes excl. CRT file header and ROM filler data. Assemble using 64tass (e.g. 64tass -i -b star-128.asm -o star-128.crt)

ScreenAddr      = $02               ; Pointer to screen address
Counter         = $04               ; Variable for counting rows and columns

                * = 0

                .include "crt-header.asm" ; CRT file header

                .logical $e000      ; Address of ROMHI

                .fill 8192-128,$ff  ; ROM filler data

                .char $00,$00,$00,$00,$00,$00,$00,$00 ; Space character ($f0)
                .char $00,$66,$3c,$ff,$3c,$66,$00,$00 ; Asterisk character ($f1)

; Address adjustment for each row of each triangle
AddrAdjLo       .char -40,-39,40,41

; Lo byte of initial screen address of each triangle
AddrLo          .char $e2,$de       ; Instruction 'ldx #$9e' below is the last two bytes of this table ($a2,$9e)

Reset           ldx #$9e            ; Index to data for last triangle ($9b+3)
                lda #%00011011
                sta $d011           ; Set screen visible
                sta $d016
                lda #%00011110
                sta $d018           ; Screen RAM at $0400 and charset at $f800
                ldy #0
                sty $d020           ; Black border and screen
                sty $d021
ClearLoop       lda #$f0            ; Space character
                sta $0400,y         ; Clear the screen
                sta $0500,y
                sta $0600,y
                sta $0700,y
                lda #$07            ; Yellow
                sta $d900,y         ; Set char color for used part of screen
                sta $da00,y
                sta $db00,y
                iny
                bne ClearLoop

TriangleLoop    lda AddrLo-$9b,x    ; Get lo byte of screen address
End             bpl End             ; Loop forever here when done (a=41)
                sta ScreenAddr
                cmp #$de            ; Set carry flag if this is the 1st or 2nd triangle
                ldy #12             ; Row and column counter
                tya
                adc #-7             ; Calculate hi byte of screen address
                clc
RowLoop         sta ScreenAddr+1
                sty Counter
                lda #$f1            ; Asterisk character
ColumnLoop      sta (ScreenAddr),y  ; Put it on screen
                dey
                bpl ColumnLoop      ; Loop for all columns
                lda ScreenAddr
                adc AddrAdjLo-$9b,x ; Adjust lo byte of screen address
                sta ScreenAddr
                tya                 ; y is $ff here
                adc ScreenAddr+1    ; Adjust hi byte of screen address
                cpx #$9d            ; Set carry flag if 3rd or 4th triangle
                adc #0              ; Adjust hi byte again if required
                ldy Counter
                dey
                bpl RowLoop         ; Loop for all rows
                dex
                bne TriangleLoop    ; Loop for all triangles

DoRti           rti
                .word DoRti         ; NMI vector
                .word Reset         ; Reset vector (cartridge autostart)
                .word DoRti         ; IRQ vector

                .endlogical
