; C64 Christmas Star by GeirS, 2022-12-22
; Size: 52 bytes excl. load address and BASIC stub. Assemble using 64tass.

ScreenAddr      = $ad               ; Pointer to screen address
Counter         = $c2               ; Variable for counting rows and columns
AddrAdjHi       = $ecb7             ; Byte values $ff,$ff,$00,$00 are available here

                * = $0801           ; Load address
; BASIC stub
                .word (NextLine),1337
                .null $9e,format("%4d",Start)
NextLine        .word 0

; Address adjustment for each row of each triangle
AddrAdjLo       .char -40,-39,40,41

; Lo byte of initial screen address of each triangle
AddrLo          .char $e2,$de       ; Instruction 'ldx #$9e' below is the last two bytes of this table ($a2,$9e)

Start           ldx #$9e            ; Index to data for last triangle ($9b+3)
TriangleLoop    lda AddrLo-$9b,x    ; Get lo byte of screen address
End             bpl End             ; Loop forever here when done (a=41)
                sta ScreenAddr
                cmp #$de            ; Set carry flag if this is the 1st or 2nd triangle
                ldy #12             ; Row and column counter
                tya
                adc #-7             ; Calculate hi byte of screen address
RowLoop         jsr $f7e0           ; Set ScreenAddr+1 and Counter and clear the carry flag
                lda #$2a            ; Asterisk character
ColumnLoop      sta (ScreenAddr),y  ; Put it on screen
                dey
                bpl ColumnLoop      ; Loop for all columns
                lda ScreenAddr
                adc AddrAdjLo-$9b,x ; Adjust screen address
                sta ScreenAddr
                lda ScreenAddr+1
                adc AddrAdjHi-$9b,x
                ldy Counter
                dey
                bpl RowLoop         ; Loop for all rows
                dex
                bne TriangleLoop    ; Loop for all triangles
