/** 
	Parallelograms'n'Triangles drawing method. Draws two overlapping diagonal
	parallelograms and two vertical triangles.
 	- Routine: 54 bytes
	- Filesize: 56 bytes
	- Started with SYS931
*/

//	Where to start drawing the parallelograms and triangles
.const par1_start	= $040a
.const par2_start 	= par1_start + 8
.const tri1_start 	= par1_start + 4
.const tri2_start 	= par1_start + 12

//	Reusable values on ZP
.const zp_y		= $2b // =$01. Lo byte of $0801 (pointer to BASIC area)
.const zp_ctr	= $2c // =$08. Hi byte of $0801
.const tri2_ptr	= $b2 // Pointer to tape buffer, $033c

// Address we need a pointer for (tri2+1): $33c+$84 = $03c0
* = $03a3 // $033c + $84 - 29

// SYS 931
newline:lda #'*'
		ldy zp_y
		cpy #5
		bcc tri1

		ldx #9
par1:	sta par1_start, x
par2:	sta par2_start, x
		dex
		bne par1

		inc par1+1
		dec par2+1

tri1:	sta tri1_start, y
tri2:	sta tri2_start, y
		dey
		bne tri1

		jsr $e981

		dec zp_ctr
		bmi decy
		dcp (tri2_ptr), y
		inc zp_y
		bne newline
decy:	isc (tri2_ptr), y
		dec zp_y
		bne newline
		
		rts