;
; VCCC 2022 IBM pc as boot block / DOS com program
;
; Build with nasm
;

; Draws a triangle rotated 90 degrees (at least) four times
; to create the xmas star shape.
;
; The triangle is drawn one transformed asterisk at a time with a lot of
; over-drawing to create an animated effect.
;
; The transformation includes stride scaling to avoid having to map row/col
; coordinates to memory locations separately.
;
; The baked transformation becomes:
; y1 = x * width - ytran
; x1 = xtran - y / width

%ifndef HIRES
%define width 40
%define xtran 66
%define ytran 560
%else
%define width 80
%define xtran 106
%define ytran 4320
%endif

%define stride width * 2
%define delay 100

	cpu 8086
	bits 16
%ifndef BOOT
	org 0x100
%else
	org 0

	jmp short start
%endif

start:
%ifdef HIRES
	mov ax, 3
%else
	xor ax, ax
%endif
	int 0x10

	mov ax, 0xb800	; screen segment
	mov es, ax

	; dx = xoffset
	; bx = yoffset
	; screen position = es:[dx + bx]
	;
	; si = line length

	; Tip of the star centered at line 10
	mov bx, stride * 8
	mov dx, (width / 2 - 8) * 2
	mov si, 17

again:
	add bx, stride
	mov cx, si	; line length
	
rotate_and_draw:
	mov bp, 4 * delay
rotate:
	
	mov ax, width
	mul dl; x
	sub ax, ytran
	; new y in ax

	xchg ax, bx
	; old y in ax
	; new y in bx

	mov dl, width
	div dl
	mov dl, xtran
	sub dl, al; al <= 255/width
	; new x in dx

	mov di, bx
	add di, dx
	mov al, '*'
	stosb

	dec bp
	jnz rotate

	; Since we did four rotations, we are back where we started
	; and can just increase x
	inc dx
	inc dx
	loop rotate_and_draw

	; Increase the loop length by two to draw the next line of
	; our triangle.
	;
	; Now dx (x) was incremented by 2 * si in the loop above
	; and needs to be incremented by 2 to draw our triangle, so
	; we mix them here.
	; dx -= 2 * si - 2 = 2 * (si - 1)

	dec si
	sub dx, si
	sub dx, si
	dec si
	jns again

%ifndef BOOT
	ret
%else
	jmp $
%endif

%assign size ($-$$)
%warning Size: size

%ifdef BOOT
	times 512-2-($-$$) db '~'

boot_marker:
	dw 0xAA55

%assign size ($-$$)
%if ($-$$) != 512
%error Boot block: size != 512
%endif
%endif
