OSNEWL	equ $FFE7
OSWRCH	equ $FFEE

    org $3000

	lda #0
	sta $80  			; $80 = Data (run length) pointer
	ldy #$20 			; Y = printable char

TextLoop:
	ldx $80  			; X = Current run length
	inc $80				; Increment the data pointer
	lda StarData,X		; Get the next run length
	beq EndProg
	pha					; Push to stack for later
	and #$7F			; Mask out the MSB
	tax					; X = Run length

CharLoop:
	tya					; Y = printable char
	jsr OSWRCH			; Print to screen
	dex					; Decrement run length
	bne CharLoop		; If non-zero print more
	
	cpy #$20  			; What's the current char?
	beq StarNext
	ldy #$20			; Flip the char from '*' to ' '
	jmp EndOfRun 
StarNext:
	ldy #$2A			; Flip from ' ' to '*'

EndOfRun:
	pla					; pull from stack
	and #$80			; If MSB is non-zero = newline
	beq TextLoop

EndOfLine:
	jsr OSNEWL
	jmp TextLoop 

EndProg:
	rts					; And we're done...

StarData:
	db $0F,$01,$07,$81
	db $0F,$02,$05,$82
	db $0F,$03,$03,$83
	db $0F,$04,$01,$84
	db $0B,$91
	db $0C,$8F
	db $0D,$8D
	db $0E,$8B
	db $0F,$89
	db $0E,$8B
	db $0D,$8D
	db $0C,$8F
	db $0B,$91
	db $0F,$04,$01,$84
	db $0F,$03,$03,$83
	db $0F,$02,$05,$82
	db $0F,$01,$07,$81
	db $0
