;
;.snowflake
;
;author:          bfox
;category:        christmas challenge
;system:          ZX Spectrum (any) or compatible
;language:        assembler
;len source code: 0x0120, 288 bytes
;len exe file:    0x002c, 44 bytes
;len code only:   0x0023, 35 bytes
;instructions:
;                 you can use any emulator of your choice. I recommend SpecEMU (windows) & FUSE (macOS/linux);
;		  in most cases it's enough to drag&drop the .tap file into emulator's window,
;                 then go to BASIC and type:
;                                             LOAD""CODE
;                                             LIST USR 3e4 (or something like that)
;
;                 source code follows below.
;                 you can compile it using sjasmplus (for example) from terminal/command promt:
;
;                                            sjasmplus.exe snowflake.asm
;                                                         or
;                                              sjasmplus snowflake.asm
;
;                 you will get two files on the disk:         snowflake.tap - emulator image
;                                                             snowflake.bin - raw machine code compiled to 30000
;description:
;                 I divided the figure into four right-angled triangles that overlap each other.
;                 the ROM character print procedure at address 16 (#10) is used for the output.
;                 unfortunately, on the ZX Spectrum it's impossible to set the coordinates for the output via
;                 system variables, so I had to use <AT> control code with the parameters, also passed through
;                 that [goddamned] RST16.  the procedure in #200a helped with this.
;                 my code doesn't clear the screen and doesn't open the 'main screen' channel - I'm sure you'll
;                 do it just fine on your own:) especially since it's not really necessary here... everything
;                 starts successfully from BASIC (see video).
;
;video:           https://youtu.be/ZPhEGh3yPtg
;
;comments:        thanks to the organizers for a great contest! see you next year:)
;
;----------------------------------------------------------------------- ----- ---- --- -- - -  -   -    -     -

		device	zxspectrum48

		org	30000
start
		ld	de,13
loop
		ld	c,e
		call	lines
		ld	a,d : add 5 :	ld c,a
		call	lines

		inc	d
		dec	e
		jr	nz,loop
		ret
lines
		ld	b,d
		call	line
		ld	b,4
line
		call	#200a

		ld	b,e
1		ld 	a,#2a : rst 16 : djnz 1b
		ret

end
;----------------------------------------------------------------------- ----- ---- --- -- - -  -   -    -     -

		savebin "snowflake.bin",start,end-start
		savetap	"snowflake.tap",code,"snowflake",start,end-start

		display "------------------------------"
		display "start:   ",/A,start," bytes"
		display "total:   ",/A,end-start," bytes"
		display "------------------------------"
