;8B8R8PS.ASM

;8 Bytes,
;8 Registers
;  and an
;8-Pointed Star

;ENTRY FOR THE #VCC2022
;By Leosoft (arnOLdE)

;size = 37 bytes

;Draw a simple triangle [(8,4),(-8,4),(0,-4)] full of *s, but mirror
;every * in all 4 directions

;registers use:
;A  all purpose & calc, of course
;B  counter for 4x swap_n_print
;C  x-coord (relative)
;D  starting x for current y
;E  y-coord (relative)
;H  x-coord (absolute)
;L  y-coord (absolute)

;addresses of the two firmware functions used:
TXT_OUTPUT equ #bb5a     ;A=ascii of character to print
SET_CURSOR equ #bb75     ;input H=x, L=y

org #B000                ;but can be loaded wherever

ld de,#0804              ;initial y=4, initial starting x=8
y_loop:
  ld c,d                 ;load starting coord
  x_loop:
    ld b,4               ;four iterations/stars
    swap_n_print:
      xor a
      sub e              ;negate y
      ld e,c             ;y = x
      ld c,a             ;x = -y
      add 17             ;convert to absolute coords with center in 17,17
      ld h,a             ;H=absolute x
      sub c              ;=17 again
      add e              ;+y
      ld l,a             ;L=absolute y
      call SET_CURSOR
      ld a,"*"           ;this way, we print *s at
      call TXT_OUTPUT    ;(-y,x),(-x,-y),(y,-x),(x,y)
      djnz swap_n_print  ;after 4 iterations, C & E are back to original values)
    dec c                ;next x in row/column
    ld a,d
    cpl                  ;=0-D-1 (cpl is one byte less than neg and it
    cp c                 ;provides us with the exact value we need!)
    jr nz,x_loop
  dec e                  ;next y (1 up)
  dec d                  ;next x starts 1 left (and ends 1 right)
ret m                    ;done if D<0 done
  jr y_loop
