#version 330 core

uniform vec4 time;
uniform sampler2D tex0;
uniform vec4 opasity;
uniform vec4 twist;
uniform vec4 ofs;

uniform vec4 intensities;

in vec2 texcoord0;

layout(location = 0, index = 0) out vec4 out_color0;

vec3 render_tunnel( vec2 p )
{
	float a = atan(p.y,p.x);
	float r = sqrt(dot(p,p));

	//float t = ofs.x;

	vec2 uv;
	uv.x = ofs.x + 0.1f/ r;
	uv.y = a / 3.1416f;
	uv.x *= -1.0;

	uv.y += twist.x * sqrt(r);

	uv *= 2;

	vec3 col = texture(tex0, uv).xyz;

	return vec3( col*r*r * opasity.x );
}

////////////////////////////////////////////////////////
// https://www.youtube.com/watch?v=QCxTEkG5ILg&t=18m50s

float remap( float v, float i0, float i1, float o0, float o1 )
{
    return o0 + (o1-o0) * clamp( (v-i0)/(i1-i0), 0.0, 1.0 );
}

//note: uniform pdf rand [0;1[
float hash11n(float p)
{
	vec2 p2 = fract(vec2(p * 5.3987, p * 5.4421));
    p2 += dot(p2.yx, p2.xy + vec2(21.5351, 14.3137));
	return fract(p2.x * p2.y * 95.4307);
}

vec2 rot2d( vec2 p, float v )
{
	vec2 sc = vec2(sin(v),cos(v));
	return vec2( dot( p, vec2(sc.y, -sc.x) ), dot( p, sc.xy ) );
}

vec3 lineits( vec2 p, int idx, float baserot, float in_time )
{
    float rnd0 = hash11n(float(idx));
    float rnd1 = hash11n(float(rnd0 + 81.0));
    float rnd2 = hash11n(float(rnd0 + 89.0));
    float rnd4 = hash11n(float(rnd0 + 1227.0));

    p = p * 2.0 - 1.0;

    float siz_deg = remap( rnd0*rnd0, 0.0, 1.0, 25.0, 5.0) * (3.14159265 / 180.0);

    //note: small ones move fast, big ones slow
    float rotspeed_s = remap( pow(rnd0, 0.25), 0.0, 1.0, 0.1, 1.0 );
    rotspeed_s *= (rnd4>0.5) ? 1.0 : -1.0;
    
    p = rot2d( p, baserot + rnd1 * 6.28 + rotspeed_s * in_time );

    //TODO: can be moved out
    float r = length( p );
    r = remap( r, 0.0, 1.46, 0.0, 1.0 );
    float v = 1.0 - pow(r, 0.5 );
    
    float a = acos( normalize(p).x );
    v *= remap( siz_deg - a, 0.0, 0.05, 0.0, 1.0 );

    v += pow( remap( r, 0.0, 0.3, 1.0, 0.0 ), 2.0);

    const vec3 c0 = vec3(1, 0.3, 0.8);
    const vec3 c1 = vec3(0.25, 0.5, 1);

    return v * mix( c0, c1, rnd2 );
}

vec3 renderlines( vec2 uv, float in_time )
{
    const int NUM_LINES = 6;
    vec3 its = vec3(0.0);
    for ( int i = 0; i<NUM_LINES; ++i )
    {
        vec3 its0 = lineits( uv, i, 0.0, in_time );
        vec3 its1 = lineits( uv, i, 2.1, in_time );
        vec3 its2 = lineits( uv, i, 4.2, in_time );
        its += max( its0, max(its1,its2) );
     }
    return its;
}

////////////////

void main(void)
{
	vec2 ssuv = texcoord0;

	float tunnel_tile = 1.0; //TODO: input
	vec2 uv = fract( tunnel_tile * ssuv );
	uv = 2.0 * uv - 1.0;
	vec3 col_tunnel = render_tunnel( uv );

	vec3 col_lines = renderlines( ssuv, time.x );

	out_color0 = vec4( intensities.x * col_tunnel + intensities.y * col_lines, 1 );
}
